import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/AutoComplete/Bloc/AutoCompleteFilterPerusahaanBloc.dart';
import 'package:absenkuv3/UI/Template/templateFormKanban.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../style.dart';

typedef void AutoCompletePerusahaanFilterKanban2Callback(DataDropdown? val);
// ignore: must_be_immutable
class AutoCompletePerusahaanFilterKanban2 extends StatefulWidget {
  ModelFilter? modelFilter;
  String? initialData;
  double? formHeight;
  double? radius;
  String? title;
  double? fontSize;
  Icon? prefixIcon;
  AutoCompletePerusahaanFilterKanban2Callback? dataCallback;
  AutoCompletePerusahaanFilterKanban2(this.modelFilter,{this.radius, this.formHeight, this.initialData, this.title, this.prefixIcon, this.fontSize, this.dataCallback});
  @override
  _AutoCompletePerusahaanFilterKanban2State createState() => _AutoCompletePerusahaanFilterKanban2State();
}

class _AutoCompletePerusahaanFilterKanban2State extends State<AutoCompletePerusahaanFilterKanban2> {
  TextEditingController keyword = new TextEditingController();
  // ModelFilter modelFilter = new ModelFilter();
  bool openDropdown = false;
  DataDropdown? selectedPelanggan;

  @override
  void initState() {
    super.initState();
    // modelFilter = new ModelFilter();
    if(widget.modelFilter!.namaPerusahaan != null){
      keyword.text = widget.modelFilter!.namaPerusahaan!;
      selectedPelanggan = DataDropdown(id: widget.modelFilter!.idPerusahaan, nama: widget.modelFilter!.namaPerusahaan);
      keyword.addListener(cariListener);
    }else{
      keyword.addListener(cariListener);
    }

  }

  cariListener() {
    BlocProvider.of<AutoCompleteFilterPerusahaanBloc>(context).add(GetFilterPerusahaan(keyword.text));
    // setState(() {
        openDropdown = true;
    // });
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<String>(
        future: PengaturanBahasa().getDataBahasa(),
        builder: (context, snapshot) {
          return Container(
            margin: EdgeInsets.only(bottom: 12),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                BlocBuilder<AutoCompleteFilterPerusahaanBloc, AutoCompleteFilterPerusahaanState>(
                  builder: (BuildContext context, AutoCompleteFilterPerusahaanState state){
                    if(state is SetFilterPerusahaanSuccess && state.perusahaan!=null) {
                      selectedPelanggan = state.perusahaan;
                      return TemplateFormKanban(
                        fontSize:widget.fontSize??null,
                        titleText:widget.title??null,
                        prefixIcon: widget.prefixIcon??null,
                        hintText: selectedPelanggan!=null?selectedPelanggan!.nama: snapshot.data == null || snapshot.data == 'en' ? "All Customer" : "Semua Pelanggan",
                        controller: keyword,
                        color: CustomStyle.fontColorBlack,
                        formHeight: widget.formHeight,
                        radius: widget.radius,
                        contentPadding: EdgeInsets.fromLTRB(0, 0, 0, 21),
                        bottomMargin: 0,
                        dataCallback: (v){
                          if(v == false){
                            setState(() {
                              openDropdown = false;
                            });
                          }
                        },
                        suffixIcon: GestureDetector(
                            onTap: (){
                              // BlocProvider.of<AutoCompletePegawaiBawahanBloc>(context).add(SetPegawaiBawahan(null));
                              setState(() {
                                selectedPelanggan = null;
                                keyword.clear();
                                openDropdown = false;
                                widget.dataCallback!(null);
                              });
                            },
                            child: Container(
                                margin: EdgeInsets.only(bottom: 13),
                                child: Icon(Icons.close, color: Colors.red, size: 22,))),
                        // buttonEnd: GestureDetector(
                        //     onTap: (){
                        //       BlocProvider.of<AutoCompletePegawaiBawahanBloc>(context).add(SetPegawaiBawahan(null));
                        //       setState(() {
                        //         selectedPegawai = null;
                        //         keyword.clear();
                        //         openDropdown = false;
                        //         widget.dataCallback!(null);
                        //       });
                        //     },
                        //     child: Icon(Icons.close, color: Colors.red, size: 22,)),
                      );
                    }
                    else {
                      if(state is SetFilterPerusahaanSuccess && state.perusahaan == null) {
                        keyword.text = "";
                        openDropdown = false;
                      }
                      if(keyword.text.trim().isEmpty){
                        selectedPelanggan = null;
                      }
                      return TemplateFormKanban(
                        fontSize:widget.fontSize??null,
                        titleText:widget.title??null,
                        prefixIcon: widget.prefixIcon??null,
                        hintText: selectedPelanggan!=null?selectedPelanggan!.nama:snapshot.data == null || snapshot.data == 'en' ? "All Customer" : "Semua Pelanggan",
                        controller: keyword,
                        color: CustomStyle.fontColorBlack,
                        suffixIcon: selectedPelanggan!=null
                            ? GestureDetector(
                                onTap: (){
                                  setState(() {
                                    selectedPelanggan = null;
                                    keyword.clear();
                                    openDropdown = false;
                                    widget.dataCallback!(null);
                                  });
                                },
                                child: Container(
                                  margin: EdgeInsets.only(bottom: 13),
                                  child: Icon(Icons.close, color: Colors.red, size: 22,)))
                            : Container(
                                margin: EdgeInsets.only(bottom: 13),
                                child: Icon(Icons.arrow_drop_down)),
                        formHeight: widget.formHeight,
                        radius: widget.radius,
                        contentPadding: EdgeInsets.fromLTRB(0, 0, 0, 21),
                        dataCallback: (v){
                          if(v == false){
                            setState(() {
                              openDropdown = false;
                            });
                          }else{
                            setState(() {
                              openDropdown = true;
                            });
                          }
                        },
                        bottomMargin: 0,);
                    }},
                ),
                openDropdown?BlocBuilder<AutoCompleteFilterPerusahaanBloc, AutoCompleteFilterPerusahaanState>(
                    builder: (BuildContext context, AutoCompleteFilterPerusahaanState state){
                      if(state is GetFilterPerusahaanSuccess) return Container(
                        margin: EdgeInsets.only(top: 6),
                        padding: EdgeInsets.fromLTRB(8,4,8,12),
                        decoration: BoxDecoration(
                            boxShadow: [
                              BoxShadow(
                                color: Colors.grey.withOpacity(0.16),
                                spreadRadius: 1,
                                blurRadius: 7,
                                offset: Offset(0, 1), // changes position of shadow
                              ),
                            ],
                            color: Colors.white,
                            borderRadius: new BorderRadius.all(Radius.circular(0))
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: state.listPerusahaan!
                              .map((item) => templateContentAutoComplete(item))
                              .toList(),
                        ),
                      );
                      else if(state is ProgressState) return Container(
                          height: 100,
                          child: Center(child: CircularProgressIndicator(strokeWidth: 8,)));
                      else return Container(
                            height: 100,
                            child: Center(child: Text(snapshot.data == null || snapshot.data == 'en' ? "Customer not found" : "Customer tidak ditemukan", style: TextStyle(fontSize: CustomStyle.fontSizeSmall),),));
                    }):Container(),
              ],
            ),
          );
        }
    );
  
  }

  Widget templateContentAutoComplete(DataDropdown data){
    return GestureDetector(
      onTap: (){
        setState(() {
          keyword.text = data.nama!;
          selectedPelanggan = data;
          openDropdown = false;
          widget.dataCallback!(selectedPelanggan);
          FocusScopeNode currentFocus = FocusScope.of(context);

          if (!currentFocus.hasPrimaryFocus) {
            currentFocus.unfocus();
          }
        });
        // BlocProvider.of<AutoCompletePegawaiBawahanBloc>(context).add(SetPegawaiBawahan(data));
      },
      child: Container(
          width: MediaQuery.of(context).size.width,
          decoration: BoxDecoration(
              border: Border(
                bottom: BorderSide( //                   <--- left side
                  color: Colors.grey[300]!,
                  width: 0.5,
                ),
              )),
          padding: EdgeInsets.fromLTRB(14,16,14,16),
          child: Text(data.nama!, style: TextStyle(fontSize: widget.fontSize??CustomStyle.fontSizeSmall),)),
    );
  }
}
