import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Service/dropdownApi.dart';
import 'package:bloc/bloc.dart';

abstract class AutoCompleteFilterGroupAreaEvent {}

class GetFilterGroupArea extends AutoCompleteFilterGroupAreaEvent {
  String? keywords;
  GetFilterGroupArea(this.keywords);
}

class GetFilterGroupAreaNoLoading extends AutoCompleteFilterGroupAreaEvent {
  String? keywords;
  GetFilterGroupAreaNoLoading(this.keywords);
}

class SetFilterGroupArea extends AutoCompleteFilterGroupAreaEvent {
  DataDropdown? GroupArea;
  SetFilterGroupArea(this.GroupArea);
}

abstract class AutoCompleteFilterGroupAreaState {
  List<DataDropdown>? listGroupArea;
}

class GetFilterGroupAreaSuccess extends AutoCompleteFilterGroupAreaState {
  GetFilterGroupAreaSuccess(List<DataDropdown>? _listFilterGroupArea) {
    listGroupArea = _listFilterGroupArea;
  }
}

class SetFilterGroupAreaSuccess extends AutoCompleteFilterGroupAreaState {
  DataDropdown? GroupArea;
  List<DataDropdown>? listGroupArea;
  SetFilterGroupAreaSuccess(this.GroupArea, this.listGroupArea);
}

class ErrorState extends AutoCompleteFilterGroupAreaState {}

class GroupProgressState extends AutoCompleteFilterGroupAreaState {}

class AutoCompleteFilterGroupAreaBloc extends Bloc<AutoCompleteFilterGroupAreaEvent, AutoCompleteFilterGroupAreaState> {
  List<DataDropdown>? listGroupArea = <DataDropdown>[];

  AutoCompleteFilterGroupAreaBloc(AutoCompleteFilterGroupAreaState initialState) : super(initialState);

  @override
  Stream<AutoCompleteFilterGroupAreaState> mapEventToState(AutoCompleteFilterGroupAreaEvent event) async* {
    if (event is GetFilterGroupArea) {
      yield GroupProgressState();
      listGroupArea!.clear();
      DropdownRespon dropdownRespon = await DropdownApi().getFilterGroupArea(event.keywords);
      if (dropdownRespon.success!) {
        listGroupArea = dropdownRespon.data;
        yield GetFilterGroupAreaSuccess(listGroupArea);
      } else {
        yield ErrorState();
      }
    } else if (event is SetFilterGroupArea) {
      yield SetFilterGroupAreaSuccess(event.GroupArea, listGroupArea);
    } else if (event is GetFilterGroupAreaNoLoading) {
      listGroupArea!.clear();
      DropdownRespon dropdownRespon = await DropdownApi().getFilterGroupArea(event.keywords);
      if (dropdownRespon.success!) {
        listGroupArea = dropdownRespon.data;
        yield GetFilterGroupAreaSuccess(listGroupArea);
      } else {
        yield ErrorState();
      }
    }
  }
}
