import 'package:absenkuv3/Bloc/CustomBloc.dart';
import 'package:absenkuv3/Bloc/Shift/PilihShiftBloc.dart';
import 'package:absenkuv3/Bloc/Shift/TukarShiftBloc.dart' as tukarShift;
import 'package:absenkuv3/Bloc/Shift/TukarShiftBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mTukarShiftPage.dart';
import 'package:absenkuv3/Repository/Model/mShift2.dart';
import 'package:absenkuv3/Repository/Model/mShiftTeman.dart';
import 'package:absenkuv3/Repository/Model/mTukarShift.dart';
import 'package:absenkuv3/UI/Modul/Shift/KomponenShift.dart';
import 'package:absenkuv3/UI/Modul/TukarShift/Template/BottomSheet.dart';
import 'package:absenkuv3/UI/Modul/TukarShift/Template/TemplateDialogKeterangan.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

// ignore: must_be_immutable
class CardTukarShift extends StatefulWidget {
  DataShift data;
  String konteks;
  GlobalKey<ScaffoldState> scaffoldKey;
  GlobalKey<FormState> formKey;
  PageTukarShiftModel redaksional;
  CardTukarShift(this.data, this.konteks, this.scaffoldKey, this.formKey, this.redaksional);

  @override
  _CardTukarShiftState createState() => _CardTukarShiftState();
}

class _CardTukarShiftState extends State<CardTukarShift> {
  Datum dataShiftSendiri = Datum(kodeShift: '', namaShift: '', masuk: '', pulang: '');

  @override
  Widget build(BuildContext context) {
    return Container(
        padding: EdgeInsets.fromLTRB(12, 16, 12, 16),
        decoration: CustomStyle.boxDecoration,
        margin: EdgeInsets.only(top: 8, right: 10, left: 10),
        child: Column(
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                Column(
                  children: [
                    Text(DateFormat('EE', widget.redaksional.menuTukarShift!.locale).format(DateTime.parse(widget.data.tanggalRaw!)).toUpperCase(),
                      style: TextStyle(fontSize: 12, color: CustomStyle.fontColorGrey, fontWeight: FontWeight.w400)),
                    SizedBox(height: 2),
                    Text(DateFormat('dd').format(DateTime.parse(widget.data.tanggalRaw!)),
                        style: TextStyle(fontSize: 16, fontWeight: FontWeight.w600)),
                    SizedBox(height: 2),
                    Text(DateFormat('MMM').format(DateTime.parse(widget.data.tanggalRaw!)),
                        style: TextStyle(fontSize: 12, color: CustomStyle.fontColorGrey, fontWeight: FontWeight.w400)),
                  ],
                ),
                SizedBox(width: 20),
                VerticalDividerWidget(height: 50, color: Colors.grey),
                SizedBox(width: 20),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(widget.data.kodeShift! + ' - ' + widget.data.namaShift!,
                        style: TextStyle(fontWeight: FontWeight.w600, fontSize: CustomStyle.fontSizeNormal, color: CustomStyle.fontColorBlack)),
                      SizedBox(height: 5),
                      Text(widget.data.jamMasuk! + ' - ' + widget.data.jamPulang!,
                        style: TextStyle(fontSize: CustomStyle.fontSizeSmall, color: CustomStyle.fontColorGrey)),
                      SizedBox(height: 5),
                      widget.konteks == 'shiftTeman' || widget.konteks == 'shiftKaryawan'
                          ? Text(widget.data.nik.toString()+' - '+  widget.data.namaLengkap.toString(),
                              style: TextStyle(
                                  fontSize: CustomStyle.fontSizeSmall,
                                  fontWeight: FontWeight.w600,
                                  color: CustomStyle.fontColorGrey))
                          : Container()
                    ],
                  ),
                ),
                Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    widget.data.button == true
                        ? Column(
                          children: [
                            TemplateButton(
                                radius: 15,
                                bold: false,
                                color: Colors.green,
                                contentColor: Colors.white,
                                expandText: false,
                                label: widget.redaksional.menuTukarShift!.data!.header,
                                heightButton: 30,
                                fontSize: 12,
                                paddingTopBottom: 0,
                                onClick: () {
                                  Datum dataShiftHariIni = Datum(
                                    namaLengkap: '',
                                    nik: '',
                                    tglShift: widget.data.tanggalRaw!,
                                    kodeShift: widget.data.kodeShift!,
                                    namaShift: widget.data.namaShift!,
                                    masuk: widget.data.jamMasuk!,
                                    pulang: widget.data.jamPulang!,
                                  );
                                  if(widget.konteks == 'shiftSaya') {
                                      BlocProvider.of<tukarShift.TukarShiftBloc>(context)
                                          .add(tukarShift.getListShiftTemanEvent(context, widget.data.tanggalRaw!, '', 'tukar_shift'));
                                      showModalBottomSheet(
                                        context: context,
                                        showDragHandle: true,
                                        shape: RoundedRectangleBorder(
                                          borderRadius: BorderRadius.only(
                                            topLeft: Radius.circular(17),
                                            topRight: Radius.circular(17)
                                          )
                                        ),
                                        builder: (BuildContext context) {
                                          return MultiBlocProvider(
                                            providers: [
                                              BlocProvider(
                                                create: (context) => TukarShiftBloc(TukarShiftProgressState())),
                                              BlocProvider(
                                                create: (context) => PilihShiftBloc(DataShiftProgress())),
                                            ],
                                            child: BottomSheetContent(
                                                widget.data.tanggalRaw,
                                                widget.scaffoldKey,
                                                widget.formKey,
                                                dataShiftHariIni,
                                                true,
                                                widget.konteks,
                                                widget.redaksional)
                                          );
                                        },
                                      );
                                    }else {
                                      BlocProvider.of<tukarShift.TukarShiftBloc>(context)
                                          .add(tukarShift.getListShiftSendiriEvent(context,widget.data.tanggalRaw!));

                                      TemplateDialogKeterangan().openDialogKeteranganJadwalTeman(context,
                                          ModelTukarShift(
                                              widget.data.tanggalRaw!, dataShiftSendiri.kodeShift, dataShiftSendiri.namaShift, dataShiftSendiri.masuk, dataShiftSendiri.pulang,
                                              widget.data.idKaryawan, widget.data.kodeShift, widget.data.namaShift, widget.data.jamMasuk, widget.data.jamPulang,
                                              ''), widget.scaffoldKey, widget.formKey, 'tukar_shift', widget.konteks, widget.redaksional);

                                    }
                                }),
                          ],
                        )
                        : Container(),
                  ],
                )
              ],
            ),
          ],
        ));
  }
}



