import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mTukarShiftPage.dart';
import 'package:absenkuv3/Repository/Model/mPengajuanSaya.dart';
import 'package:absenkuv3/UI/Modul/Shift/KomponenShift.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

// ignore: must_be_immutable
class CardPengajuan extends StatefulWidget {
  DataPengajuanSaya data;
  String konteks;
  GlobalKey<ScaffoldState> scaffoldKey;
  GlobalKey<FormState> formKey;
  PageTukarShiftModel redaksional;

  CardPengajuan(this.data, this.konteks, this.scaffoldKey, this.formKey, this.redaksional);

  @override
  _CardPengajuanState createState() => _CardPengajuanState();
}

class _CardPengajuanState extends State<CardPengajuan> {
  @override
  Widget build(BuildContext context) {

    return GestureDetector(
      onTap: ()=> BlocProvider.of<NavigatorBloc>(context)
          .add(NavigateToDetailTukarShift(context, [widget.data.idPengajuan, widget.konteks])),
      child: Container(
        margin: EdgeInsets.only(top: 8),
        child: Stack(
          children: [
            Container(
                padding: EdgeInsets.fromLTRB(12, 16, 12, 16),
                decoration: CustomStyle.boxDecoration,
                margin: EdgeInsets.only(top: 8, right: 13, left: 10),
                child: Column(
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                      children: [
                        Column(
                          children: [
                            Text(DateFormat('MMM').format(DateTime.parse(widget.data.tglShift!)),
                                style: TextStyle(
                                    fontSize: 12,
                                    color: CustomStyle.fontColorGrey,
                                    fontWeight: FontWeight.w400)),
                            SizedBox(height: 2),
                            Text(DateFormat('dd').format(DateTime.parse(widget.data.tglPengajuanRaw!)),
                                style: TextStyle(fontSize: 16, fontWeight: FontWeight.w600)),
                          ],
                        ),
                        SizedBox(width: 11),
                        VerticalDividerWidget(color: Colors.grey, height: 40),
                        SizedBox(width: 13),
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(widget.data.noPengajuan!,
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeNormal,
                                    fontWeight: FontWeight.w700,
                                    color: CustomStyle.fontColorBlack)),
                              SizedBox(height: 5),
                              Text(widget.data.shiftAwal!.namaShift! + ' ${widget.redaksional.menuTukarShift!.data!.ditukarDengan} ' + widget.data.shiftBaru!.namaShift!,
                                style: TextStyle(fontSize: CustomStyle.fontSizeSmall-1, color: CustomStyle.fontColorGrey)),
                            ],
                          ),
                        ),
                        SizedBox(width: 7),
                        Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          children: [
                            Wrap(spacing: 8, runSpacing: 4, children: [
                                 Container(
                                      padding: EdgeInsets.all(8),
                                      decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(7),
                                        color: Color(int.parse(widget.data.status!.color!)),
                                      ),
                                      child: Text(widget.data.status!.status!,
                                          style: TextStyle(
                                              fontSize: 13,
                                              fontWeight: FontWeight.bold,
                                              color: Color(int.parse(widget.data.status!.fontColor!)))),
                                    )
                            ])
                          ],
                        )
                      ],
                    ),
                    Divider(
                      thickness: 1,
                      color: Colors.grey,
                    ),
                    Row(
                      children: [
                          Text('${widget.redaksional.menuTukarShift!.data!.ditukarDengan} : ',
                            style: TextStyle(
                                fontSize: CustomStyle.fontSizeSmall-1,
                                color: CustomStyle.fontColorGrey)),
                        widget.konteks=='shiftTeman'?
                          Text(widget.data.shiftAwal!.nik! +' - '+widget.data.shiftAwal!.karyawan!,
                            style: TextStyle(
                                fontSize: CustomStyle.fontSizeSmall-1,
                                fontWeight: FontWeight.bold,
                                color: CustomStyle.fontColorGrey))
                        : Text(widget.data.shiftBaru!.nik! +' - '+widget.data.shiftBaru!.karyawan!,
                            style: TextStyle(
                                fontSize: CustomStyle.fontSizeSmall-1,
                                fontWeight: FontWeight.bold,
                                color: CustomStyle.fontColorGrey)),
                      ],
                    )
                  ],
                )),
          ],
        ),
      ),
    );
  }
}
