import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TargetSalesBloc.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateMenu.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

class HalamanSalesActivity extends StatefulWidget {

  @override
  State<HalamanSalesActivity> createState() => _HalamanSalesActivityState();
}

class _HalamanSalesActivityState extends State<HalamanSalesActivity> {

  @override
  void initState() {
    super.initState();
    BlocProvider.of<TargetSalesBloc>(context).add(GetTargetSalesEvent(context));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: CustomStyle.backgroundColor,
      appBar: AppBar(
        centerTitle: true,
        shadowColor: Colors.transparent,
        backgroundColor: CustomStyle.color1,
        title: Text(
          'Sales Monitoring',
          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
        ),
      ),
      body: BlocBuilder<TargetSalesBloc, TargetSalesState>(
        builder: (context, state) {
          return Column(
            children: [
              Stack(
                children: [
                  Container(
                    color: CustomStyle.color1,
                    height: 100,
                  ),
                  Container(
                    child: Column(
                      children: [
                        Container(
                          margin: EdgeInsets.fromLTRB(20, 25, 20, 27),
                          child: Row(
                            children: [
                              Expanded(
                                child: Container(
                                  child: Card(
                                    shape: RoundedRectangleBorder(
                                      borderRadius: BorderRadius.circular(13),
                                    ),
                                    elevation: 1,
                                    child: Container(
                                      margin: EdgeInsets.only(top: 17, left: 13),
                                      child: Column(
                                        crossAxisAlignment: CrossAxisAlignment.start,
                                        children: [
                                          Image.asset(ValueImage.iconTargetBulanan, height: 35),
                                          SizedBox(height: 9),
                                          Text('Target Bulanan', style: TextStyle(color: Colors.grey/*Colors.orange*/, fontSize: 13, fontWeight: FontWeight.w400)),
                                          SizedBox(height: 5),
                                          Wrap(
                                            crossAxisAlignment: WrapCrossAlignment.start,
                                            alignment: WrapAlignment.start,
                                            children: [
                                              state is TargetSalesSuccessState
                                                // ? Text(state.targetSalesRespon!.dataTarget!.targetNominalBulanan!.nominalTarget!, style: TextStyle(color: Colors.orange, fontSize: 16, fontWeight: FontWeight.w700))
                                                ? Text(state.targetSalesRespon!.dataTarget!.targetNominalBulanan!.nominalTarget!, style: TextStyle(color: Colors.black, fontSize: 16, fontWeight: FontWeight.w700))
                                                : Container(
                                                  margin: EdgeInsets.only(right: 5),
                                                  child: ShimerTarget()),
                                              SizedBox(width: 7),
                                            ],
                                          ),
                                          SizedBox(height: 9),
                                          Container(
                                            margin: EdgeInsets.only(right: 5, bottom: 17),
                                            width: double.infinity,
                                            child:
                                              state is TargetSalesSuccessState
                                                ? Column(
                                                  crossAxisAlignment: CrossAxisAlignment.start,
                                                  children: [
                                                    Text('Realisasi Bulanan', style: TextStyle(color: Colors.grey/*Colors.orange*/, fontSize: 13, fontWeight: FontWeight.w400)),
                                                    SizedBox(height: 3),
                                                    Row(
                                                        crossAxisAlignment: CrossAxisAlignment.start,
                                                        children: [
                                                          // Text('/', style: TextStyle(color: Colors.orange, fontSize: 14, fontWeight: FontWeight.w400)),
                                                          // SizedBox(width: 5),
                                                          // Expanded(child: Text(state.targetSalesRespon!.dataTarget!.targetNominalBulanan!.nominalRealisasi!, style: TextStyle(color: Colors.orange, fontSize: 16, fontWeight: FontWeight.w700))),
                                                          Expanded(child: Text(state.targetSalesRespon!.dataTarget!.targetNominalBulanan!.nominalRealisasi!, style: TextStyle(color: Colors.black, fontSize: 16, fontWeight: FontWeight.w700))),
                                                          // SizedBox(width: 5),
                                                        ],
                                                      ),
                                                  ],
                                                )
                                                : ShimerTarget(),
                                          )
                                        ],
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                              SizedBox(width: 20),
                              Expanded(
                                child: Container(
                                  child: Card(
                                    shape: RoundedRectangleBorder(
                                      borderRadius: BorderRadius.circular(13),
                                    ),
                                    elevation: 1,
                                    child: Container(
                                      margin: EdgeInsets.only(top: 17, left: 13),
                                      child: Column(
                                        crossAxisAlignment: CrossAxisAlignment.start,
                                        children: [
                                          Image.asset(ValueImage.iconTargetPoint, height: 35),
                                          SizedBox(height: 9),
                                          Text('Target Poin Harian', style: TextStyle(color: Colors.grey/*Colors.teal.shade300*/, fontSize: 12, fontWeight: FontWeight.w400)),
                                          SizedBox(height: 5),
                                          Wrap(
                                            crossAxisAlignment: WrapCrossAlignment.start,
                                            alignment: WrapAlignment.start,
                                            children: [
                                              state is TargetSalesSuccessState
                                                ? Text(state.targetSalesRespon!.dataTarget!.targetPointHarian!, style: TextStyle(color: Colors.black/*Colors.teal.shade300*/, fontSize: 16, fontWeight: FontWeight.bold))
                                                : Container(
                                                    margin: EdgeInsets.only(right: 5),
                                                    child: ShimerTarget()),
                                              SizedBox(width: 7),
                                            ],
                                          ),
                                          SizedBox(height: 9),
                                          Container(
                                            margin: EdgeInsets.only(right: 5, bottom: 17),
                                            width: double.infinity,
                                            child: state is TargetSalesSuccessState
                                              ? Column(
                                                crossAxisAlignment: CrossAxisAlignment.start,
                                                children: [
                                                  Text('Realisasi Poin Harian', style: TextStyle(color: Colors.grey/*Colors.teal.shade300*/, fontSize: 12, fontWeight: FontWeight.w400)),
                                                  SizedBox(height: 3),
                                                  Row(
                                                      crossAxisAlignment: CrossAxisAlignment.start,
                                                      children: [
                                                        // Text('/', style: TextStyle(color: Colors.teal.shade300, fontSize: 14, fontWeight: FontWeight.w400)),
                                                        // SizedBox(width: 3),
                                                        Expanded(child: Text(state.targetSalesRespon!.dataTarget!.realisasiPointHarian!, style: TextStyle(color: Colors.black/*Colors.teal.shade300*/, fontSize: 16, fontWeight: FontWeight.bold))),
                                                        // SizedBox(width: 5),
                                                      ],
                                                    ),
                                                ],
                                              )
                                              : ShimerTarget(),
                                          )
                                        ],
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ],
                          ),
                        ),
                        TemplateMenu(
                          icon: ValueImage.iconKanbanBoard,
                          title: 'Kanban Board',
                          subtitle: 'Daftar Penjualan',
                          onClick: () => BlocProvider.of<NavigatorBloc>(context)
                              .add(NavigateToKambanBoardSalesActivityPage(context)),
                        ),
                        TemplateMenu(
                          icon: ValueImage.iconDailyActivity,
                          title: 'Daily Activity',
                          subtitle: 'Daftar Aktivitas Sales',
                          onClick: () => BlocProvider.of<NavigatorBloc>(context)
                              .add(NavigateToDailySalesActivityPage(context)),
                        ),
                      ],
                    ),
                  )
                ],
              ),


            ],
          );
        }
      ),
    );
  }
}

class ShimerTarget extends StatelessWidget {
  const ShimerTarget({super.key});

  @override
  Widget build(BuildContext context) {
    return Column(
        children: [
          card(context)]);
  }

  Widget card(BuildContext context) {
    return Container(
      height: 20,
      width: MediaQuery.of(context).size.width,
      child: Shimmer.fromColors(
        baseColor: Colors.grey[200]!,
        highlightColor: Colors.white,
        period: Duration(seconds: 4),
        child: Card(),
      ),
    );
  }
}
