import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/SalesActivity/KambanBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/StepperBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mPerusahaan.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Layanan/dataCustomerPage.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Layanan/dataProdukLayananPage.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/templateStepper.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayanan.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateConfirmationDialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanAddLayanan extends StatefulWidget {
  var firstTahapan;
  HalamanAddLayanan(this.firstTahapan);

  @override
  State<HalamanAddLayanan> createState() => _HalamanAddLayananState();
}

class _HalamanAddLayananState extends State<HalamanAddLayanan> {
  GlobalKey<ScaffoldState> _scaffoldKey = GlobalKey();
  List<Layanan> dataDraft = [];
  DataPerusahaan? dataPerusahaan;
  int indexStepper = 0;

  Future<bool> keluar() async {
    if(indexStepper == 0){
      Navigator.pop(context);
    }else{
      BlocProvider.of<StepperBloc>(context)
          .add(SetStepper(0));
    }
    return false;
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    print("FIRST TAHAPAN : ${widget.firstTahapan}");
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: Scaffold(
        key: _scaffoldKey,
        appBar: AppBar(
          centerTitle: true,
          flexibleSpace: Image(
            image: AssetImage(ValueImage.headerBiruDashboard),
            fit: BoxFit.cover,
          ),
          backgroundColor: Colors.transparent,
          title: Text(
            'Tambah Data',
            style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
          )
        ),
        body: BlocBuilder<StepperBloc, int>(
          builder: (BuildContext _context, int state) {
            indexStepper = state;
            return Stack(
              children: [
                Container(
                  // margin: EdgeInsets.only(bottom: 300),
                  child: Column(
                    children: [
                      TemplateStepper(state),
                      state == 0
                          ? DataProdukLayananPage(
                              _scaffoldKey,
                              dataCallback: (val){
                                dataDraft = val;
                              }
                            )
                          : DataCustomerPage(
                              dataCallback: (valu){
                                dataPerusahaan = valu;
                              },
                            ),
                      SizedBox(height: 35),
                    ],
                  ),
                ),
                Positioned(
                    bottom: 0,
                    child: Container(
                      padding: EdgeInsets.only(left: 22, right: 22, top: 7, bottom: 7),
                      decoration: BoxDecoration(
                        boxShadow: [
                          BoxShadow(
                              color: Colors.grey.shade300,
                              spreadRadius: 2
                          ),
                        ],
                        color: Colors.white,
                      ),
                      height: 62,
                      width: MediaQuery.of(context).size.width,
                      child: BlocBuilder<AuthBloc, LoginRespon>(
                        builder: (context, stateLogin) {
                          return TemplateButton(
                            onClick: (){
                              // print("object : ${dataDraft.length}");
                              if(state == 0){
                                if(dataDraft.length == 0){
                                  TemplateConfirmationDialog(
                                      'Data Produk/Layanan belum ada, apakah Anda yakin ingin melanjutkan?',
                                          (){
                                        Navigator.pop(context);
                                        BlocProvider.of<StepperBloc>(context)
                                            .add(SetStepper(1));
                                      },
                                      context);
                                }else{
                                  BlocProvider.of<StepperBloc>(context)
                                      .add(SetStepper(1));
                                }
                              }else{
                                // BlocProvider.of<StepperBloc>(context)
                                //     .add(SetStepper(0));
                                if(dataPerusahaan == null){
                                  showSnackBarDelayed(_scaffoldKey, "Data Perusahaan wajib diisi", context);
                                }else {
                                  print("sampai sini mas bos : ${stateLogin.dataLogin!.adminAtasan} - ${dataPerusahaan!.idSalesBawahan}");
                                  if(stateLogin.dataLogin!.adminAtasan! && dataPerusahaan!.idSalesBawahan == null){
                                    showSnackBarDelayed(_scaffoldKey, "Sales wajib diisi", context);
                                  }
                                  else if(dataPerusahaan!.namaPerusahaan!.trim().isEmpty){
                                    showSnackBarDelayed(_scaffoldKey, "Nama Pelanggan wajib diisi", context);
                                    // }else if(dataPerusahaan!.jenisPerusahaan == null && dataPerusahaan!.kategoriPelanggan == 'Perusahaan'){
                                  }else if(dataPerusahaan!.jenisPerusahaan == null){
                                    showSnackBarDelayed(_scaffoldKey, "Jenis Perusahaan wajib diisi", context);
                                  }else if(dataPerusahaan!.leadSource == null){
                                    showSnackBarDelayed(_scaffoldKey, "Lead Source wajib diisi", context);
                                  }else if(dataPerusahaan!.alamat!.trim().isEmpty){
                                    showSnackBarDelayed(_scaffoldKey, "Alamat wajib diisi", context);
                                  }else if(dataPerusahaan!.provinsi == null){
                                    showSnackBarDelayed(_scaffoldKey, "Provinsi wajib diisi", context);
                                  }else if(dataPerusahaan!.kota == null){
                                    showSnackBarDelayed(_scaffoldKey, "Kota wajib diisi", context);
                                  }else if(dataPerusahaan!.picNama!.trim().isEmpty && dataPerusahaan!.kategoriPelanggan == 'Perusahaan'){
                                    showSnackBarDelayed(_scaffoldKey, "Nama PIC wajib diisi", context);
                                  }
                                  // else if(dataPerusahaan!.picEmail!.trim().isEmpty){
                                  //   showSnackBarDelayed(_scaffoldKey, "Email wajib diisi", context);
                                  // }
                                  else if(dataPerusahaan!.picTelp!.trim().isEmpty){
                                    showSnackBarDelayed(_scaffoldKey, "Nomor telepon wajib diisi", context);
                                  }else if(dataPerusahaan!.title!.trim().isEmpty){
                                    showSnackBarDelayed(_scaffoldKey, "Title wajib diisi", context);
                                  }else if(dataPerusahaan!.keterangan!.trim().isEmpty){
                                    showSnackBarDelayed(_scaffoldKey, "Keterangan wajib diisi", context);
                                  }else{
                                    print("LOLOS BOS");
                                    // print(dataPerusahaan!.idPelanggan);
                                    // print(dataPerusahaan!.namaPerusahaan);
                                    // print(dataPerusahaan!.pelangganBaru);
                                    // print(dataPerusahaan!.title);
                                    // print(dataPerusahaan!.keterangan);
                                    // print(dataPerusahaan!.kategoriPelanggan);
                                    // print(dataPerusahaan!.leadSource!.idLeadM);
                                    BlocProvider.of<KambanBloc>(context)
                                        .add(addKambanEvent(context, _scaffoldKey, dataPerusahaan, widget.firstTahapan));
                                  }
                                }
                                // print("phphph: $dataPerusahaan");
                              }
                            },
                            label: state == 0 ? "Selanjutnya" : "SIMPAN",
                            color: CustomStyle.color1,
                            heightButton: 28,
                            radius: CustomStyle.boxRadius + 4,
                            bold: true,
                            fontSize: CustomStyle.fontSizeSmall - 1,
                            iconSize: 16,
                            paddingTopBottom: 0,
                          );
                        }
                      ),
                    )
                )
              ],
            );
          }
        ),
      ),
    );
  }
}





































// import 'package:absenkuv3/Setting/value_image.dart';
// import 'package:absenkuv3/UI/Template/style.dart';
// import 'package:absenkuv3/UI/Template/templateButton.dart';
// import 'package:flutter/material.dart';
//
// class HalamanAddLayanan extends StatefulWidget {
//
//   @override
//   State<HalamanAddLayanan> createState() => _HalamanAddLayananState();
// }
//
// class _HalamanAddLayananState extends State<HalamanAddLayanan> {
//   int currentStep = 0;
//
//   @override
//   Widget build(BuildContext context) {
//     return Scaffold(
//       backgroundColor: CustomStyle.backgroundColor,
//       appBar: AppBar(
//         centerTitle: true,
//         flexibleSpace: Image(
//           image: AssetImage(ValueImage.headerBiruDashboard),
//           fit: BoxFit.cover,
//         ),
//         backgroundColor: Colors.transparent,
//         title: Text(
//           'Tambah Data',
//           style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
//         )
//       ),
//       body: SingleChildScrollView(
//         child: Container(
//           width: MediaQuery.of(context).size.width,
//           height: MediaQuery.of(context).size.height-85,
//           // color: Colors.orange,
//           child: Stack(
//             children: [
//               Stepper(
//                   steps: [
//                     Step(
//                         title: Text('Data Produk / Layanan'),
//                          content: Container(
//                            color: Colors.yellow,
//                            margin: EdgeInsets.only(top: 53),
//                            height: MediaQuery.of(context).size.height/1.5,
//                            child: Column(
//                              children: [
//
//                                SizedBox(height: 13)
//                              ],
//                            ),
//                          ),
//                       isActive: currentStep == 0 ? true : false
//                     ),
//                     Step(
//                       title: Text('Data Pelanggan'),
//                       content: Container(
//                         color: Colors.red,
//                         height: MediaQuery.of(context).size.height/1.5,
//                         child: Stack(
//                           children: [
//                             Text('Data Pelanggan'),
//                           ],
//                         ),
//                       ),
//                       isActive: currentStep == 0 ? false : true,
//                     )
//                   ],
//                 currentStep: currentStep,
//                 controlsBuilder: (context, pp) {
//                   return Container();
//                 },
//
//                 type: StepperType.horizontal,
//                 margin: EdgeInsets.all(100),
//
//               ),
//               Container(
//                 margin: EdgeInsets.only(top: MediaQuery.of(context).size.height/9.5),
//                   child: Column(
//                     children: [
//                       Container(
//                         // color: Colors.grey,
//                         margin: EdgeInsets.symmetric(horizontal: 23),
//                         child: Row(
//                           crossAxisAlignment: CrossAxisAlignment.start,
//                           mainAxisAlignment: MainAxisAlignment.spaceBetween,
//                           children: [
//                             Column(
//                               crossAxisAlignment: CrossAxisAlignment.start,
//                               children: [
//                                 Text('0 Layanan'),
//                                 Text('Rp 0'),
//                               ],
//                             ),
//                             TemplateButton(
//                               onClick: ()=> setState(() { currentStep==0?currentStep = 1:currentStep = 0; }),
//                               label: "Tambah Produk",
//                               color: CustomStyle.color1,
//                               heightButton: 28,
//                               radius: CustomStyle.boxRadius + 4,
//                               bold: true,
//                               icon: Icons.add_circle_outline_outlined,
//                               fontSize: CustomStyle.fontSizeSmall - 1,
//                               iconSize: 16,
//                               paddingTopBottom: 0,
//                             )
//                           ],
//                         ),
//                       ),
//                       Divider(color: Colors.grey.shade300,thickness: 2),
//                     ],
//                   )),
//               Positioned(
//                   bottom: 0,
//                   child: Container(
//                     padding: EdgeInsets.only(left: 22, right: 22, top: 7, bottom: 7),
//                     decoration: BoxDecoration(
//                         boxShadow: [
//                           BoxShadow(
//                             color: Colors.grey.shade300,
//                             spreadRadius: 2
//                           ),
//                         ],
//                         color: Colors.white,
//                     ),
//                     height: 62,
//                     width: MediaQuery.of(context).size.width,
//                     child: TemplateButton(
//                       onClick: ()=> setState(() { currentStep==0?currentStep = 1:currentStep = 0; }),
//                       label: "Selanjutnya",
//                       color: CustomStyle.color1,
//                       heightButton: 28,
//                       radius: CustomStyle.boxRadius + 4,
//                       bold: true,
//                       fontSize: CustomStyle.fontSizeSmall - 1,
//                       iconSize: 16,
//                       paddingTopBottom: 0,
//                     ),
//                   )
//               )
//               // MaterialButton(
//               //   onPressed: () {
//               //     setState(() {
//               //       currentStep = 1;
//               //     });
//               //   },
//               //   color: CustomStyle.color1,
//               //   child: Text('Selanjutnya', style: TextStyle(color: Colors.white)),
//               // ),
//             ],
//           ),
//         ),
//       ),
//     );
//   }
// }
