import 'package:absenkuv3/Bloc/Dropdown/DropdownProdukLayananBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataLayananDetailBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/LayananDraftBloc.dart' as draft;
import 'package:absenkuv3/Bloc/SalesActivity/TotalDataLayananDetailBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataKanban.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataProduct.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mTotalDataLayananDetail.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/DropdownDataProduct.dart';
import 'package:absenkuv3/UI/Template/dialog/alertDialog.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateDashLine.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:extended_masked_text/extended_masked_text.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/cardLayananPage.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

class komponenDataProdukLayanan extends StatefulWidget {
  DataKanban data;
  String idTahapanM;
  GlobalKey<ScaffoldState> scaffoldKey;
  bool actionEdit;
  komponenDataProdukLayanan(this.data, this.idTahapanM, this.scaffoldKey, {this.actionEdit = true});

  @override
  State<komponenDataProdukLayanan> createState() => _komponenDataProdukLayananState();
}

class _komponenDataProdukLayananState extends State<komponenDataProdukLayanan> {
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<TotalDataLayananDetailBloc>(context).add(getTotalDataLayananDetailEvent(context, widget.data.idPipelineMain));
    BlocProvider.of<DataLayananDetailBloc>(context).add(getDataLayananDetailEvent(context, widget.data.idPipelineMain));
    _scrollController.addListener(()=>BlocProvider.of<DataLayananDetailBloc>(context).add(loadMoreEvent(context, _scrollController, widget.data.idPipelineMain!)));
  }

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        Column(
          children: [
            BlocBuilder<TotalDataLayananDetailBloc, TotalDataLayananDetailState>(
              builder: (context, stateTotal) {
                return Container(
                  margin: EdgeInsets.fromLTRB(23,23,23,3),
                  child: Column(
                    children: [
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text("Layanan", style: TextStyle(fontSize: 12, color: Colors.grey.shade600)),
                          stateTotal is getTotalDataLayananDetailSuccessState
                              ? Text(stateTotal.dataTotalDataLayananDetail!.layanan!, style: TextStyle(fontSize: 12, fontWeight: FontWeight.w500))
                              : Container(
                            height: 15,
                            width: 50,
                            child: Shimmer.fromColors(
                              baseColor: Colors.grey[300]!,
                              highlightColor: Colors.white,
                              period: Duration(seconds: 4),
                              child: Card(),
                            ),
                          )
                        ],
                      ),
                      SizedBox(height: 3),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text("Total Item", style: TextStyle(fontSize: 12, color: Colors.grey.shade600)),
                          stateTotal is getTotalDataLayananDetailSuccessState
                            ? Text(stateTotal.dataTotalDataLayananDetail!.totalItem!, style: TextStyle(fontSize: 12, fontWeight: FontWeight.w500))
                            : Container(
                                height: 15,
                                width: 50,
                                child: Shimmer.fromColors(
                                  baseColor: Colors.grey[300]!,
                                  highlightColor: Colors.white,
                                  period: Duration(seconds: 4),
                                  child: Card(),
                                ),
                              )
                        ],
                      ),
                      SizedBox(height: 3),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text("Total Diskon", style: TextStyle(fontSize: 12, color: Colors.grey.shade600)),
                          stateTotal is getTotalDataLayananDetailSuccessState
                              ? Text("( ${stateTotal.dataTotalDataLayananDetail!.totalDiskon!} )", style: TextStyle(fontSize: 12, fontWeight: FontWeight.w500))
                              : Container(
                            height: 15,
                            width: 50,
                            child: Shimmer.fromColors(
                              baseColor: Colors.grey[300]!,
                              highlightColor: Colors.white,
                              period: Duration(seconds: 4),
                              child: Card(),
                            ),
                          )
                        ],
                      ),
                      SizedBox(height: 3),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text("Total Harga", style: TextStyle(fontSize: 12, color: Colors.grey.shade600)),
                          stateTotal is getTotalDataLayananDetailSuccessState
                              ? Text("${stateTotal.dataTotalDataLayananDetail!.totalHarga!}", style: TextStyle(fontSize: 12, fontWeight: FontWeight.w500))
                              : Container(
                            height: 15,
                            width: 50,
                            child: Shimmer.fromColors(
                              baseColor: Colors.grey[300]!,
                              highlightColor: Colors.white,
                              period: Duration(seconds: 4),
                              child: Card(),
                            ),
                          )
                        ],
                      ),
                      SizedBox(height: 13),
                      // Divider(thickness: 1),
                    ],
                  ),
                );
              }
            ),
            Divider(thickness: 1),
            Expanded(
              child: BlocBuilder<DataLayananDetailBloc, DataLayananDetailState>(
                  builder: (BuildContext context, DataLayananDetailState stateData){
                    if(stateData is getDataLayananDetailSuccessState || stateData is LoadMoreProgressState)
                      return stateData.dataLayananDetail!.length > 0
                            ? Stack(
                                children: <Widget>[
                                  ListView.builder(
                                      physics: AlwaysScrollableScrollPhysics(),
                                      controller: _scrollController,
                                      itemCount: stateData.dataLayananDetail!.length,
                                      itemBuilder: (BuildContext context, index) {
                                        return Column(
                                          children: [
                                            CardLayananPage(widget.data, stateData.dataLayananDetail![index], widget.scaffoldKey, false, 'detail', widget.actionEdit),
                                            index == stateData.dataLayananDetail!.length-1
                                              ? Container(
                                                  margin: EdgeInsets.only(top: 5),
                                                  child: Divider(thickness: 1),
                                                )
                                              : Divider(thickness: 1)
                                          ],
                                        );
                                      }
                                  ),
                                  stateData is LoadMoreProgressState? Positioned(
                                      bottom :16,
                                      child: Container(
                                          width: MediaQuery.of(context).size.width,
                                          child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                                ],
                              ) : Center(child: Image.asset(ValueImage.noData, height: 250,),);
                    else if(stateData is DataLayananDetailProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                    else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                  }),
            )
          ],
        ),
      ],
    );
  }
}
