import 'package:absenkuv3/Repository/Model/SalesActivity/mDailyActivity.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataAktivitasSales.dart';
import 'package:flutter/material.dart';
import 'package:flutter_html/flutter_html.dart';

class CardAktivitas extends StatefulWidget {
  DataAktivitasSales? data;
  CardAktivitas(this.data);

  @override
  State<CardAktivitas> createState() => _CardAktivitasState();
}

class _CardAktivitasState extends State<CardAktivitas> {

  @override
  Widget build(BuildContext context) {
    return widget.data!.kategori! == ""
      ? ListView.builder(
          shrinkWrap: true,
          physics: NeverScrollableScrollPhysics(),
          itemCount: widget.data!.data!.length,
          itemBuilder: (context, ind){
            return Container(
              margin: EdgeInsets.fromLTRB(27, 13, 27, 7),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(widget.data!.data![ind].waktu!, style: TextStyle(fontSize: 13, fontWeight: FontWeight.w400)),
                        SizedBox(height: 3),
                        widget.data!.data![ind].ketMove == ""
                          ? widget.data!.data![ind].tahapanSebelum == ""
                            ? Wrap(
                                children: [
                                  Text(widget.data!.data![ind].aktivitas!, style: TextStyle(fontSize: 13, fontStyle: FontStyle.italic, fontWeight: FontWeight.w700)),
                                  SizedBox(width: 5),
                                  Text(widget.data!.data![ind].tahapanSekarang!, style: TextStyle(fontSize: 13)),
                                ],
                              )
                            : Wrap(
                                children: [
                                  Text(widget.data!.data![ind].aktivitas!, style: TextStyle(fontSize: 13, fontStyle: FontStyle.italic, fontWeight: FontWeight.w700)),
                                  SizedBox(width: 5),
                                  Text(widget.data!.data![ind].tahapanSebelum!, style: TextStyle(fontSize: 13)),
                                  SizedBox(width: 7),
                                  Icon(Icons.arrow_forward_sharp, size: 17),
                                  SizedBox(width: 7),
                                  Text(widget.data!.data![ind].tahapanSekarang!, style: TextStyle(fontSize: 13)),
                                ],
                              )
                          : Wrap(
                              children: [
                                Text(widget.data!.data![ind].ketMove!.split(",")[0], style: TextStyle(fontSize: 13, fontStyle: FontStyle.italic, fontWeight: FontWeight.w700)),
                                SizedBox(width: 5),
                                Text(widget.data!.data![ind].ketMove!.split(",")[1], style: TextStyle(fontSize: 13)),
                                SizedBox(width: 5),
                                Icon(Icons.arrow_forward_sharp, size: 17),
                                SizedBox(width: 5),
                                Text(widget.data!.data![ind].ketMove!.split(",")[2], style: TextStyle(fontSize: 13)),
                              ],
                            ),
                        // SizedBox(height: 17),
                      ],
                    ),
                  ),
                  widget.data!.data![ind].showStatus!
                      ? Container(
                    margin: EdgeInsets.only(left: 13, right: 17),
                    decoration: BoxDecoration(
                      color: Color(int.parse(widget.data!.data![ind].status!.labelColor!)),
                      borderRadius: BorderRadius.circular(9),
                    ),
                    padding: EdgeInsets.symmetric(vertical: 5, horizontal: 13),
                    child: Text(widget.data!.data![ind].status!.status!, style: TextStyle(color: Color(int.parse(widget.data!.data![ind].status!.labelFontColor!)), fontWeight: FontWeight.w400, fontSize: 12)),
                  )
                      : Container()
                ],
              ),
            );
          })
      : Container(
      margin: EdgeInsets.symmetric(horizontal: 27, vertical: 13),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(widget.data!.kategori!, style: TextStyle(fontWeight: FontWeight.w700)),
          Divider(thickness: 1),
          ListView.builder(
              itemCount: widget.data!.data!.length,
              shrinkWrap: true,
              physics: NeverScrollableScrollPhysics(),
              itemBuilder: (context, inde){
                return GestureDetector(
                  onTap: (){
                    print(widget.data!.data![inde].status!.status);
                    Navigator.pushNamed(context, '/detail_daily_sales_activity',arguments: [
                      DataDailyAktivitasSales(
                        idPipelineMain: widget.data!.data![inde].idPipelineMain,
                        tabel: widget.data!.data![inde].tabel,
                        userId: widget.data!.data![inde].userId,
                        idPelanggan: widget.data!.data![inde].idPelanggan,
                        tanggal: widget.data!.data![inde].tanggal,
                        jam: widget.data!.data![inde].jam,
                        idPipelineMainLog: widget.data!.data![inde].idPipelineMainLog
                      ),
                      widget.data!.data![inde].status!.value, false]).then((val){
                      // if(val == true){
                      //   widget.dataCallback!(val);
                      // }
                    });
                  },
                  child: Container(
                    margin: EdgeInsets.only(bottom: 7),
                    width: MediaQuery.of(context).size.width,
                    decoration: BoxDecoration(
                        border: Border.all(color: Colors.grey.shade300),
                        borderRadius: BorderRadius.circular(13)
                    ),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          padding: EdgeInsets.fromLTRB(9, 9, 17, 9),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Expanded(
                                child: Row(
                                  children: [
                                    Icon( Icons.calendar_month_outlined, color: Colors.grey),
                                    SizedBox(width: 9),
                                    Expanded(
                                      child: Column(
                                        crossAxisAlignment: CrossAxisAlignment.start,
                                        children: [
                                          Text(widget.data!.data![inde].waktu!, style: TextStyle(fontSize: 12, color: Colors.grey.shade600, fontWeight: FontWeight.w400)),
                                          SizedBox(height: 3),
                                          Text(widget.data!.data![inde].jam!.substring(0,5), style: TextStyle(fontSize: 12, color: Colors.grey.shade600, fontWeight: FontWeight.w400)),
                                        ],
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              widget.data!.data![inde].showStatus!
                                  ? Container(
                                      margin: EdgeInsets.only(left: 13),
                                      decoration: BoxDecoration(
                                        color: Color(int.parse(widget.data!.data![inde].status!.labelColor!)),
                                        borderRadius: BorderRadius.circular(9),
                                      ),
                                      padding: EdgeInsets.symmetric(vertical: 5, horizontal: 13),
                                      child: Text(widget.data!.data![inde].status!.status!, style: TextStyle(color: Color(int.parse(widget.data!.data![inde].status!.labelFontColor!)), fontWeight: FontWeight.w400, fontSize: 12),),
                                    )
                                  : Container()
                            ],
                          ),
                        ),
                        Divider(thickness: 1, height: 1),
                        Container(
                          padding: EdgeInsets.symmetric(vertical: 9, horizontal: 17),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(widget.data!.data![inde].keterangan!),
                              SizedBox(height: 3),
                              Text("Dibuat oleh ${widget.data!.data![inde].userInput}", style: TextStyle(fontSize: 12, color: Colors.grey, fontWeight: FontWeight.w400)),
                            ],
                          ),
                        )
                      ],
                    ),
                  ),
                );
              }
          ),
        ],
      ),
    );

  }
}
