import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/ApproverBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataLayananDetailBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DetailKanbanSalesBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TahapanBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TotalDataLayananDetailBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataKanban.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mMasterTahapan.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/komponenDataAktivitas.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/komponenDataPelanggan.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/komponenDataProdukLayanan.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/templeteCRUDLayanan.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateConfirmationDialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

class HalamanDetailKanbanBoardActivity extends StatefulWidget {
  var data; // 0 = id_pipeline_main, 1 = id_pipeline_main_log
  // String idPipelineMainLog;

  HalamanDetailKanbanBoardActivity(this.data);

  @override
  State<HalamanDetailKanbanBoardActivity> createState() => _HalamanDetailKanbanBoardActivityState();
}

class _HalamanDetailKanbanBoardActivityState extends State<HalamanDetailKanbanBoardActivity> {
  String selected = 'Data Pelanggan';
  List<String> chipData= ['Data Pelanggan', 'Produk/Layanan', 'Aktivitas'];
  ScrollController _controller = ScrollController(initialScrollOffset: 0);
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  String refresh = "";
  
  @override
  void initState() {
    super.initState();
    BlocProvider.of<DetailKanbanSalesBloc>(context).add(getDataDetailKanbanSalesEvent(context, widget.data[0], widget.data[1]));
    // selected = widget.data[1];
    // if(widget.data[2] != null){
    //   if(widget.data[2] == 'refresh'){
    //     refresh = 'refresh';
    //   }
    // }
    // BlocProvider.of<TahapanBloc>(context).add(GetTahapanEvent(context, ModelFilter(monthYear: DateTime(int.parse(widget.data[0].tglInput!.split("-")[2]), int.parse(widget.data[0].tglInput!.split("-")[1])))));
  }
  Future<bool> keluar2() async {
    // BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
    // Navigator.pop(context, [refresh, widget.data[3]]);
    Navigator.pop(context, refresh);
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar2,
      child: Scaffold(
        backgroundColor: Colors.white,
        key: scaffoldKey,
          appBar: AppBar(
              centerTitle: true,
              flexibleSpace: Image(
                image: AssetImage(ValueImage.headerBiruDashboard),
                fit: BoxFit.cover,
              ),
              backgroundColor: Colors.transparent,
              title: Text('Detail', style: TextStyle(fontSize: CustomStyle.fontSizeTitle)),
          ),
        body: BlocBuilder<DetailKanbanSalesBloc, DetailKanbanSalesState>(
                builder: (context, stateDetail) {
                  if(stateDetail is getDetailKanbanSalesSuccessState){
                    return Stack(
                      children: [
                        Container(
                          margin: EdgeInsets.only(bottom: stateDetail.data!.button!.buttonApprove! ? 65 : 0),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Container(
                                margin: EdgeInsets.fromLTRB(27, 13, 27, 13),
                                child: Row(
                                  children: [
                                    stateDetail.data!.pipelineLog!.tahapanSebelum == null ? Container() :
                                    Container(
                                      padding: EdgeInsets.only(left: 13, right: 13, top: 7, bottom: 7),
                                      decoration: BoxDecoration(
                                        color: Color(int.parse(stateDetail.data!.pipelineLog!.tahapanSebelum!.warna!)),
                                        borderRadius: BorderRadius.only(
                                            topLeft: Radius.circular(7),
                                            bottomLeft: Radius.circular(7),
                                            bottomRight: Radius.circular(7),
                                            topRight: Radius.circular(7)
                                        ),
                                      ),
                                      child: Text(stateDetail.data!.pipelineLog!.tahapanSebelum!.nama!, style: TextStyle(fontSize: 12, fontWeight: FontWeight.w700, color: Color(int.parse(stateDetail.data!.pipelineLog!.tahapanSebelum!.warnaText!)))),
                                    ),
                                    stateDetail.data!.pipelineLog!.tahapanSebelum == null ? Container() :
                                    SizedBox(width: 5),
                                    stateDetail.data!.pipelineLog!.tahapanSebelum == null ? Container() :
                                    Icon(Icons.arrow_right_alt),
                                    stateDetail.data!.pipelineLog!.tahapanSebelum == null ? Container() :
                                    SizedBox(width: 5),
                                    Container(
                                      padding: EdgeInsets.only(left: 13, right: 13, top: 7, bottom: 7),
                                      decoration: BoxDecoration(
                                        color: Color(int.parse(stateDetail.data!.pipelineLog!.tahapanSesudah!.warna!)),
                                        borderRadius: BorderRadius.only(
                                            topLeft: Radius.circular(7),
                                            bottomLeft: Radius.circular(7),
                                            bottomRight: Radius.circular(7),
                                            topRight: Radius.circular(7)
                                        ),
                                      ),
                                      child: Text(stateDetail.data!.pipelineLog!.tahapanSesudah!.nama!, style: TextStyle(fontSize: 12, fontWeight: FontWeight.w700, color: Color(int.parse(stateDetail.data!.pipelineLog!.tahapanSesudah!.warnaText!)))),
                                    ),
                                    stateDetail.data!.pipelineLog!.tahapanSebelum == null ? SizedBox(width: 110) :
                                    SizedBox(width: 47),
                                    Icon(
                                      Icons.calendar_month_outlined,
                                      size: 21,
                                      color: Colors.grey.shade600,
                                    ),
                                    SizedBox(
                                      width: 10,
                                    ),
                                    Expanded(
                                      child: Text(
                                        stateDetail.data!.pipelineMain!.tglPengajuan!,
                                        style: TextStyle(fontSize: 12),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              Divider(thickness: 1, height: 1),
                              Container(
                                height: 50,
                                width: MediaQuery.of(context).size.width * 1.5,
                                padding: EdgeInsets.only(left: 5.0, top: 5),
                                child: ListView.builder(
                                    itemCount: chipData.length,
                                    scrollDirection: Axis.horizontal,
                                    controller: _controller,
                                    itemBuilder: (BuildContext context, index) {
                                      return Row(
                                        children: [
                                          SizedBox(width: 2),
                                          ChoiceChip(
                                            shape: RoundedRectangleBorder(
                                                borderRadius: BorderRadius.only(
                                                    topRight: Radius.circular(21),
                                                    bottomRight: Radius.circular(21),
                                                    topLeft: Radius.circular(21),
                                                    bottomLeft: Radius.circular(21))),
                                            backgroundColor: Colors.grey.shade200,
                                            labelPadding: EdgeInsets.only(left: 17, right: 17, top: 1.5, bottom: 1.5),
                                            selectedColor: CustomStyle.color1,
                                            selected: selected == chipData[index],
                                            label: Text(chipData[index] ?? ''),
                                            labelStyle: TextStyle(
                                                color: selected == chipData[index]
                                                    ? Colors.white
                                                    : CustomStyle.color1, fontSize: 13),
                                            elevation: 1,
                                            onSelected: (_) {
                                              setState(() {
                                                selected = chipData[index];
                                              });
                                            },
                                          ),
                                          SizedBox(width: 11)
                                        ],
                                      );
                                    }
                                ),
                              ),
                              selected == 'Data Pelanggan'
                                  ? Expanded(
                                      child: KomponenDataPelanggan(stateDetail.data!.pipelineMain!.idPelanggan!, stateDetail.data!.pipelineMain!.idPipelineMain!))
                                  : selected == 'Produk/Layanan'
                                    ? Expanded(
                                        child: komponenDataProdukLayanan(DataKanban(idPipelineMain: stateDetail.data!.pipelineMain!.idPipelineMain), stateDetail.data!.pipelineMain!.idTahapanM!, scaffoldKey, actionEdit: false))
                                    : Expanded(child: KomponenDataAktivitas(stateDetail.data!.pipelineMain!.idPelanggan!, stateDetail.data!.pipelineMain!.namaPerusahaan!, DataKanban(idPipelineMain: stateDetail.data!.pipelineMain!.idPipelineMain), scaffoldKey))
                            ],
                          ),
                        ),
                        BlocListener<ApproverBloc, ApproverState>(
                          listener: (context, stateApproval) {
                            if (stateApproval is TolakSuccessState) {
                              refresh = 'refresh';
                            }else if(stateApproval is SetujuiSuccessState){
                              refresh = 'refresh';
                            }
                          },
                          child: Positioned(
                            bottom: 0,
                            child:
                            stateDetail.data!.button!.buttonApprove!
                                ? Container(
                                    padding: EdgeInsets.only(left: 22, right: 22),
                                    decoration: BoxDecoration(
                                        boxShadow: [
                                          BoxShadow(
                                            color: Colors.grey.withOpacity(0.4),
                                            spreadRadius: 2,
                                            blurRadius: 7,
                                            offset: Offset(
                                                0, 1), // changes position of shadow
                                          ),
                                        ],
                                        color: Colors.white,
                                        borderRadius: new BorderRadius.only(
                                            topLeft: Radius.circular(CustomStyle.boxRadius + 4),
                                            topRight: Radius.circular(CustomStyle.boxRadius + 4))),
                                    height: 62,
                                    width: MediaQuery.of(context).size.width,
                                    child: Row(
                                      children: <Widget>[
                                        Expanded(
                                          child: TemplateButton(
                                            onClick: () =>
                                                TemplateConfirmationDialog(
                                                    marginHeight: 13,
                                                    stateDetail.data!.pipelineLog!.kategori=="move"
                                                      ? 'Apakah Anda yakin akan menolak pengajuan pindah bulan?'
                                                      : stateDetail.data!.pipelineLog!.tahapanSebelum == null
                                                          ? 'Apakah Anda yakin akan menolak pengajuan ${stateDetail.data!.pipelineLog!.tahapanSesudah!.nama} ini?'
                                                          : 'Apakah Anda yakin akan menolak pengajuan ubah tahapan ${stateDetail.data!.pipelineLog!.tahapanSebelum!.nama} ke ${stateDetail.data!.pipelineLog!.tahapanSesudah!.nama}?',
                                                        () {
                                                      BlocProvider.of<ApproverBloc>(context)
                                                          .add(TolakKanbanFromDailyEvent(
                                                          context,
                                                          selected,
                                                          stateDetail.data!.pipelineMain!.idPipelineMain!,
                                                          stateDetail.data!.pipelineLog!.idPipelineMainLog!,
                                                          stateDetail.data!.pipelineMain!.idTahapanM!,
                                                          stateDetail.data!.pipelineLog!.tahapanSesudah!.jenis!,
                                                          'detail'));
                                                    },
                                                    context),
                                            label: "Tolak",
                                            color: Colors.grey[500],
                                            heightButton: 28,
                                            radius: CustomStyle.boxRadius + 4,
                                            icon: Icons.close,
                                            bold: true,
                                            fontSize: CustomStyle.fontSizeSmall - 1,
                                            iconSize: 16,
                                            paddingTopBottom: 0,
                                          ),
                                        ),
                                        SizedBox(
                                          width: 12,
                                        ),
                                        Expanded(
                                          child: TemplateButton(
                                            onClick: () {
                                              TemplateConfirmationDialog(
                                                  marginHeight: 13,
                                                  stateDetail.data!.pipelineLog!.kategori=="move"
                                                      ? 'Apakah Anda yakin akan menyetujui pengajuan pindah bulan?'
                                                      : stateDetail.data!.pipelineLog!.tahapanSebelum == null
                                                        ? 'Apakah Anda yakin akan menyetujui pengajuan ${stateDetail.data!.pipelineLog!.tahapanSesudah!.nama} ini?'
                                                        : 'Apakah Anda yakin akan menyetujui pengajuan ubah tahapan ${stateDetail.data!.pipelineLog!.tahapanSebelum!.nama} ke ${stateDetail.data!.pipelineLog!.tahapanSesudah!.nama}?',
                                                  // 'Apakah anda yakin akan menolak pengajuan kanban ini?',
                                                  () {
                                                    BlocProvider.of<ApproverBloc>(context)
                                                        .add(SetujuiKanbanFromDailyEvent(
                                                        context,
                                                        // selected,
                                                        stateDetail.data!.pipelineMain!.idPipelineMain!,
                                                        stateDetail.data!.pipelineLog!.idPipelineMainLog!,
                                                        stateDetail.data!.pipelineMain!.idTahapanM!,
                                                        'detail'));
                                                  },
                                                  context);
                                            },
                                            label: "Setujui",
                                            color: CustomStyle.color1,
                                            heightButton: 28,
                                            radius: CustomStyle.boxRadius + 4,
                                            icon: Icons.check,
                                            bold: true,
                                            fontSize: CustomStyle.fontSizeSmall - 1,
                                            iconSize: 16,
                                            paddingTopBottom: 0,
                                          ),
                                        ),
                                        SizedBox(
                                          width: 16,
                                        ),
                                        GestureDetector(
                                            onTap: () =>
                                                BlocProvider.of<NavigatorBloc>(context)
                                                    .add(NavigatePop(context)),
                                            child: Icon(
                                              Icons.chevron_left,
                                              size: 34,
                                              color: CustomStyle.fontColorGrey,
                                            ))
                                      ],
                                    ),
                                  )
                                : Container(),
                          ),
                        )
                      ],
                    );
                  }else{
                    return Center(
                      child: CircularProgressIndicator(strokeWidth: 8),
                    );
                  }
                }),
      ),
    );
  }
}