import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataDailyAktivitasSalesBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/DailyActivity/KomponenDailyActivity.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/UI/templateDateRangePicker.dart';
import 'package:absenkuv3/UI/Template/FilterBottomKanbanSheet.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class DailyActivityPage extends StatefulWidget {

  @override
  State<DailyActivityPage> createState() => _DailyActivityPageState();
}

class DataChip {
  String? key;
  String? value;

  DataChip({this.key, this.value});
}

class _DailyActivityPageState extends State<DailyActivityPage> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  ScrollController _scrollController = new ScrollController();
  ScrollController __scrollController = new ScrollController();
  ModelFilter? modelFilter = ModelFilter(dateRange: [DateTime.now(),DateTime.now()]);

  DataChip selected = DataChip(key: "pengajuan", value: "Pengajuan");
  List<DataChip> chipData= [DataChip(key: "pengajuan", value: "Pengajuan"),
                            DataChip(key: "approve", value: "Diterima"),
                            DataChip(key: "tolak", value: "Ditolak")];

  @override
  void initState() {
    super.initState();

    BlocProvider.of<FilterBottomSheetBloc>(context).add(setFilterBottomSheet(modelFilter));
    // BlocProvider.of<DataDailyAktivitasSalesBloc>(context).add(getListDataDailyAktivitasSalesEvent(context, selected.key, null));
    _scrollController.addListener(()=>BlocProvider.of<DataDailyAktivitasSalesBloc>(context).add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      backgroundColor: CustomStyle.backgroundColor,
      appBar: AppBar(
        centerTitle: true,
        flexibleSpace: Image(
          image: AssetImage(ValueImage.headerBiruDashboard),
          fit: BoxFit.cover,
        ),
        backgroundColor: Colors.transparent,
        title: Text(
          'Daily Activity',
          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
        ),
      ),
      body: BlocBuilder<AuthBloc, LoginRespon>(
          builder: (context, stateLogin) {
            return Stack(
              children: [
                Column(
                  children: [
                    Container(
                      height: 50,
                      width: MediaQuery.of(context).size.width * 1.5,
                      padding: EdgeInsets.only(left: 5.0, top: 5),
                      child: ListView.builder(
                        itemCount: chipData.length,
                        scrollDirection: Axis.horizontal,
                        controller: __scrollController,
                        itemBuilder: (BuildContext context, index){
                          return Row(
                            children: [
                              SizedBox(width: 2),
                              ChoiceChip(
                                shape: RoundedRectangleBorder(
                                    borderRadius: BorderRadius.only(
                                        topRight: Radius.circular(21),
                                        bottomRight: Radius.circular(21),
                                        topLeft: Radius.circular(21),
                                        bottomLeft: Radius.circular(21))),
                                backgroundColor: Colors.grey.shade200,
                                labelPadding: EdgeInsets.only(left: 17, right: 17, top: 1.5, bottom: 1.5),
                                selectedColor: CustomStyle.color1,
                                selected: selected.key == chipData[index].key,
                                label: Text(chipData[index].value ?? ''),
                                labelStyle: TextStyle(
                                    color: selected.key == chipData[index].key
                                        ? Colors.white
                                        : CustomStyle.color1, fontSize: 13),
                                elevation: 1,
                                onSelected: (_) {
                                  setState(() {
                                    selected = chipData[index];
                                    BlocProvider.of<DataDailyAktivitasSalesBloc>(context).add(getListDataDailyAktivitasSalesEvent(context, selected.key, modelFilter));
                                  });
                                },
                              ),
                              SizedBox(width: 11)
                            ],
                          );;
                        },
                      ),
                    ),
                    Expanded(
                      child: BlocBuilder<DataDailyAktivitasSalesBloc, DataDailyAktivitasSalesState>(
                          builder: (context, state) {
                            if(state is getListDataDailyAktivitasSalesSuccessState || state is LoadMoreProgressState){
                              return Stack(
                                children: [
                                  state.data!.length > 0
                                      ? ListView.builder(
                                      itemCount: state.data!.length,
                                      controller: _scrollController,
                                      itemBuilder: (context, index){
                                        return CardDailyActivity(
                                          state.data![index],
                                          selected.key!,
                                          scaffoldKey,
                                          dailyPegawai: stateLogin.dataLogin!.adminAtasan!?true:false,
                                          dataCallback: (values){
                                            if(values == true){
                                              setState(() {
                                                state.data!.remove(state.data![index]);
                                              });
                                            }
                                          },
                                        );
                                      }
                                  )
                                      : Center(child: Image.asset(ValueImage.noData, height: 250)),
                                  state is LoadMoreProgressState? Positioned(
                                      bottom :16,
                                      child: Container(
                                          width: MediaQuery.of(context).size.width,
                                          child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                                ],
                              );
                            }else if(state is DataDailyAktivitasSalesEmptyState){
                              return Center(child: Image.asset(ValueImage.noData, height: 250));
                            }
                            else{
                              return Center(child: CircularProgressIndicator(strokeWidth: 8));
                            }
                          }
                      ),
                    ),
                  ],
                ),
                Positioned(
                    bottom: 20,
                    right: 10,
                    child: BlocListener<FilterBottomSheetBloc, FilterBottomSheetState>(
                        listener: (BuildContext context, FilterBottomSheetState state) {
                          if (state is setFilterSuccess) {
                            modelFilter = state.modelFilter;
                            if(state != null){
                              modelFilter = state.modelFilter;
                              BlocProvider.of<DataDailyAktivitasSalesBloc>(context).add(
                                  getListDataDailyAktivitasSalesEvent(context, selected.key,
                                      modelFilter));
                            }
                          }
                        },
                        child: FilterBottomSheetKanban(modelFilter!.monthYear, modelFilter!.dateRange, adaFilterTanggal: false))
                  // BlocListener<MonthPickerRekapBloc, MonthPickerRekapState>(
                  // listener: (BuildContext context, MonthPickerRekapState state) {
                  //   if(state.dateTime != null){
                  //     BlocProvider.of<TahapanBloc>(context).add(GetTahapanEvent(context, ModelFilter(monthYear: state.dateTime)));
                  //   }
                  // },
                  // child: TemplateMonthPickerRekap(backgroundColor: CustomStyle.color1))
                )
                // Positioned(
                //   bottom: 16,
                //   right: 14,
                //   child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
                //     listener: (BuildContext context, DateRangePickerState dateRangePickerState){
                //       if(dateRangePickerState is DateAvailable) {
                //         modelFilter = ModelFilter(dateRange: dateRangePickerState.date);
                //         BlocProvider.of<DataDailyAktivitasSalesBloc>(context).add(
                //             getListDataDailyAktivitasSalesEvent(context, selected.key,
                //                 ModelFilter(dateRange: dateRangePickerState.date)));
                //       }
                //     },
                //     child: TemplateDateRangePicker(),
                //   ),
                // ),
              ],
            );
          }
      ),
    );
  }
}
