import 'package:absenkuv3/Repository/Model/SalesActivity/mDailyActivity.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';

typedef void DataCallbackCardDailyActivity(val);

class CardDailyActivity extends StatefulWidget {
  final DataDailyAktivitasSales data;
  final String status;
  final GlobalKey<ScaffoldState> scaffoldKey;
  final bool? dailyPegawai;
  DataCallbackCardDailyActivity? dataCallback;

  CardDailyActivity(this.data, this.status, this.scaffoldKey, {this.dailyPegawai = false, this.dataCallback});

  @override
  _CardDailyActivityState createState() => _CardDailyActivityState();
}

class _CardDailyActivityState extends State<CardDailyActivity> {

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () {
        // BlocProvider.of<NavigatorBloc>(context).add(
        // NavigateToDetailDailySalesActivityPage(context,
        //     [widget.data, widget.status, widget.dailyPegawai])),
        if(widget.data.tabel == "activity"){
          Navigator.pushNamed(context, '/detail_daily_sales_activity',arguments: [widget.data, widget.status, widget.dailyPegawai]).then((val){
            if(val == true){
              widget.dataCallback!(val);
            }
          });
        }else{
          Navigator.pushNamed(context, '/detail_kanban_activity', arguments: [widget.data.idPipelineMain, widget.data.idPipelineMainLog]).then((val){
            print("detail pindah tahapan : $val");
            if(val == 'refresh'){
              widget.dataCallback!(true);
            }
          });
        }

      },
      child: Column(
        children: [
          Container(
            decoration: CustomStyle.boxDecoration,
            padding: EdgeInsets.all(16),
            margin: EdgeInsets.all(8),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                    children: [
                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 8),
                        child: Row(
                          children: [
                            Column(
                              children: [
                                Text(
                                  widget.data.waktu!.split(" ")[0].substring(0,3).toUpperCase(),
                                  style: TextStyle(
                                      fontSize: 12,
                                      fontWeight: FontWeight.w400,
                                      color: CustomStyle.fontColorGrey),
                                ),
                                SizedBox(height: 3),
                                Text(
                                  widget.data.waktu!.split(" ")[1].toUpperCase(),
                                  style: TextStyle(
                                      fontSize: 16,
                                      fontWeight: FontWeight.w600),
                                ),
                                SizedBox(height: 3),
                                Text(
                                  widget.data.waktu!.split(" ")[2].substring(0,3).toUpperCase(),
                                  style: TextStyle(
                                      fontSize: 12,
                                      fontWeight: FontWeight.w400,
                                      color: CustomStyle.fontColorGrey),
                                )
                              ],
                            ),
                            VDivider(),
                          ],
                        ),
                      ),

                      Expanded(
                        child: Row(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Expanded(
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Text(
                                    widget.data.aktivitas!,
                                    style: TextStyle(
                                        fontSize: 13, fontWeight: FontWeight.w600),
                                  ),
                                  SizedBox(
                                    height: 4,
                                  ),
                                  Row(
                                    children: [
                                      Text(
                                       widget.data.jam!.substring(0,5),
                                        style: TextStyle(
                                            fontSize: 12,
                                            fontWeight: FontWeight.w400),
                                      ),
                                      SizedBox(
                                        width: 8,
                                      ),
                                      Text("-"),
                                      SizedBox(
                                        width: 8,
                                      ),
                                      Text(
                                        widget.data.status!.status!,
                                        style: TextStyle(
                                            fontSize: 12,
                                            fontWeight: FontWeight.w400,
                                            // color: Color(int.parse(widget.data.warnaStatus!))
                                        ),
                                      )
                                    ],
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),

                      // Text(wi)
                    ]),
                Divider(
                  thickness: 2,
                ),
                SizedBox(
                  height: 8,
                ),


                // Row(
                //   children: [
                //     // Text(
                //     //   "Customer : ",
                //     //   style: TextStyle(
                //     //       fontSize: 12,
                //     //       color: CustomStyle.fontColorGrey,
                //     //       fontWeight: FontWeight.w400),
                //     // ),
                //     Text(
                //       "${widget.data.namaPelanggan!} sodlfnm;onsaf oisjdmfoim[o a;of[oim ;aefln[oin akfmoin ;efno[in[o ea;ofn[oin",
                //       style: TextStyle(fontSize: 12, fontWeight: FontWeight.w600),
                //     ),
                //
                //   ],
                // ),
                Text(
                  "${widget.data.namaPelanggan!}",
                  style: TextStyle(fontSize: 12, fontWeight: FontWeight.w600),
                ),
                SizedBox(
                  height: 5,
                ),
                widget.dailyPegawai! ? Column(
                  children: [
                    Row(
                      children: [
                        Text('Sales : ', style: TextStyle(fontSize: 13, color: Colors.grey.shade500)),
                        Expanded(
                          child: Text(
                            widget.data.userInput!,
                            style: TextStyle(
                                fontSize: 13,
                                fontWeight: FontWeight.w600),
                          ),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: 8,
                    ),
                  ],
                ) : Container(),
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      "Keterangan : ",
                      style: TextStyle(
                          fontSize: 12,
                          color: CustomStyle.fontColorGrey,
                          fontWeight: FontWeight.w400),
                    ),
                    Expanded(
                      child: Text(
                        widget.data.keterangan!.length > 90
                            ? "${widget.data.keterangan!.substring(0,90)} ..."
                            : widget.data.keterangan!,
                        style: TextStyle(fontSize: 12, fontWeight: FontWeight.w600),
                      ),
                    ),

                  ],
                )
              ],
            ),
          ),
        ],
      ),
    );
  }

}

class VDivider extends StatelessWidget {
  const VDivider({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 60,
      margin: EdgeInsets.symmetric(horizontal: 12),
      decoration: BoxDecoration(
        border: Border(
          right: BorderSide(
            color: Theme.of(context).dividerColor,
            width: 2,
          ),
        ),
      ),
    );
  }
}
