import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/CardItemBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementDetailBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mReimbursementPage.dart';
import 'package:absenkuv3/Repository/Model/mReimbursement.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateConfirmationDialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'komponenReimbursement.dart';

class HalamanDetailReimbursement extends StatefulWidget {
  final data; //[0]:id;[1]:konteks;
  HalamanDetailReimbursement(this.data);
  @override
  _HalamanDetailReimbursementState createState() =>
      _HalamanDetailReimbursementState();
}

class _HalamanDetailReimbursementState
    extends State<HalamanDetailReimbursement> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  DataReimbursement? dataReimbursement;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<ReimbursementDetailBloc>(context)
        .add(GetDetailReimbursementEvent(context, widget.data![0]));
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageReimbursementModel>(
        future: PengaturanBahasa().reimbursement(),
        builder: (context, snapshot){
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
              key: scaffoldKey,
              appBar: AppBar(
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
                centerTitle: true,
                title: Text(
                  snapshot.data!.menuReimbursement!.detailTitle!,
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                ),
              ),
              body: BlocConsumer<ReimbursementDetailBloc, ReimbursementDetailState>(
                  listener: (BuildContext context, ReimbursementDetailState state) {
                    if (state is GetListReimbursementSuccessState) {
                      dataReimbursement = state.dataReimbursement;
                    }
                  }, builder: (BuildContext context, ReimbursementDetailState state) {
                if (state is GetListReimbursementSuccessState)
                  return Stack(
                    children: [
                      Column(
                        children: [
                          HeaderDetailReimbursement(state.dataReimbursement),
                          Expanded(
                            child: ListView.builder(
                                physics: AlwaysScrollableScrollPhysics(),
                                controller: _scrollController,
                                itemCount: state.dataReimbursement!.listItemPengajuan!
                                    .dataItem!.length,
                                itemBuilder: (BuildContext context, index) {
                                  return BlocProvider<CardItemReimbursementBloc>(
                                    create: (BuildContext context) {
                                      return CardItemReimbursementBloc(
                                          GantiStatusSuccess(state
                                              .dataReimbursement!
                                              .listItemPengajuan!
                                              .dataItem![index]
                                              .tombolAksiRevisi!
                                              ? snapshot.data!.menuReimbursement!.button!.lakukanRevisi
                                              : snapshot.data!.menuReimbursement!.button!.onprogess));
                                    },
                                    child: CardItemReimbursement(
                                        state.dataReimbursement!.listItemPengajuan!
                                            .dataItem![index],
                                        state.dataReimbursement!.idPengajuan, snapshot.data!),
                                  );
                                }),
                          )
                        ],
                      ),
                      state.aksiFooterLocal
                          ? Positioned(
                        bottom: 0,
                        child: Container(
                          padding: EdgeInsets.fromLTRB(14, 18, 14, 12),
                          width: MediaQuery.of(context).size.width,
                          decoration: BoxDecoration(
                              boxShadow: [
                                BoxShadow(
                                  color: Colors.grey.withOpacity(0.2),
                                  spreadRadius: 1.6,
                                  blurRadius: 4,
                                  offset:
                                  Offset(0, 1), // changes position of shadow
                                ),
                              ],
                              color: Colors.white,
                              borderRadius: new BorderRadius.only(
                                topLeft: Radius.circular(24),
                                topRight: Radius.circular(24),
                              )),
                          child: Column(
                            children: [
                              Row(
                                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                children: [
                                  Text(
                                    snapshot.data!.menuReimbursement!.data!.totalPengajuan!,
                                    style: TextStyle(
                                        fontSize: CustomStyle.fontSizeNormal,
                                        color: CustomStyle.fontColorBlack,
                                        fontWeight: FontWeight.w600),
                                  ),
                                  Expanded(
                                      child: Text(
                                        CurrencyFormatter.IDR(int.parse(
                                            dataReimbursement!.totalPengajuan!)),
                                        style: TextStyle(
                                            fontSize: CustomStyle.fontSizeNormal,
                                            color: CustomStyle.fontColorBlack,
                                            fontWeight: FontWeight.w700),
                                        textAlign: TextAlign.right,
                                      )),
                                ],
                              ),
                              dataReimbursement!.totalPengajuanDisetujui != '0'
                                  ? Column(
                                children: [
                                  SizedBox(
                                    height: 6,
                                  ),
                                  Row(
                                    mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                    children: [
                                      Text(
                                        snapshot.data!.menuReimbursement!.data!.totalDisetujui!,
                                        style: TextStyle(
                                            fontSize:
                                            CustomStyle.fontSizeNormal,
                                            color:
                                            CustomStyle.fontColorBlack,
                                            fontWeight: FontWeight.w600),
                                      ),
                                      Expanded(
                                          child: Text(
                                            CurrencyFormatter.IDR(int.parse(
                                                dataReimbursement!
                                                    .totalPengajuanDisetujui!)),
                                            style: TextStyle(
                                                fontSize:
                                                CustomStyle.fontSizeNormal,
                                                color: CustomStyle.colorGreen,
                                                fontWeight: FontWeight.w700),
                                            textAlign: TextAlign.right,
                                          )),
                                    ],
                                  ),
                                ],
                              )
                                  : Container(),
                              SizedBox(
                                height: 12,
                              ),
                              Row(
                                children: [
                                  Expanded(
                                      child: TemplateButton(
                                        onClick: () =>
                                            BlocProvider.of<NavigatorBloc>(context)
                                                .add(NavigatePop(context)),
                                        label: snapshot.data!.menuReimbursement!.button!.btnBatalkan,
                                        color: Colors.grey[500],
                                        expand: true,
                                        icon: Icons.chevron_left,
                                        radius: 14,
                                        iconSize: 18,
                                        paddingTopBottom: 8,
                                      )),
                                  SizedBox(
                                    width: 6,
                                  ),
                                  Expanded(
                                      child: TemplateButton(
                                        onClick: () => TemplateConfirmationDialog(
                                            snapshot.data!.menuReimbursement!.message!.konfirmasi!,
                                                () {
                                              BlocProvider.of<NavigatorBloc>(context)
                                                  .add(NavigatePop(context));
                                              if (widget.data![1] ==
                                                  'reimbursementKaryawan') //submit approval
                                                BlocProvider.of<ReimbursementDetailBloc>(
                                                    context)
                                                    .add(SubmitApprovalReimbursementEvent(
                                                    context, scaffoldKey));
                                              else //submit revisi
                                                BlocProvider.of<ReimbursementDetailBloc>(
                                                    context)
                                                    .add(SubmitRevisiReimbursementEvent(
                                                    context, scaffoldKey));
                                            }, context),
                                        label: snapshot.data!.menuReimbursement!.button!.btnSubmit,
                                        color: CustomStyle.color1,
                                        expand: true,
                                        icon: Icons.chevron_right,
                                        radius: 14,
                                        iconSize: 18,
                                        paddingTopBottom: 8,
                                      )),
                                ],
                              )
                            ],
                          ),
                        ),
                      )
                          : Container()
                    ],
                  );
                else
                  return Center(
                    child: CircularProgressIndicator(
                      strokeWidth: 8,
                    ),
                  );
              }),
            );
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );
  }
}
