import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mDataNotif.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

typedef void DataCallbackCardNotif(List val);

class CardNotif extends StatefulWidget {
  final Data data;
  final String konteks;
  final GlobalKey<ScaffoldState> scaffoldKey;
  DataCallbackCardNotif? dataCallback;

  CardNotif(this.data, this.konteks, this.scaffoldKey, {this.dataCallback});

  @override
  _CardNotifState createState() => _CardNotifState();
}

class _CardNotifState extends State<CardNotif> {
  @override
  Widget build(BuildContext context) {
    List<String> arrayKpi = widget.data.idRef!.split(',');
    final utcTime =
        DateTime.fromMillisecondsSinceEpoch(widget.data.tglNotif!, isUtc: true);
    final localTime = utcTime.toLocal();
    String formatted = DateFormat('dd-MM-yyyy HH:mm').format(localTime);
    return GestureDetector(
      onTap: () {
        if (widget.data.rute == 'detail_izin_pegawai') {
          // BlocProvider.of<NavigatorBloc>(context).add(NavigateToDetailIzin(
          //     context, [widget.data.idRef, 'izinPegawai','notif']));
          Navigator.pushNamed(context, '/detail_izin',
                  arguments: [widget.data.idRef, 'izinPegawai', 'notif'])
              .then((value) => {
                    widget.dataCallback!([value, widget.data.idNotif])
                  });
        } else if (widget.data.rute == 'detail_izin_saya') {
          Navigator.pushNamed(context, '/detail_izin',
                  arguments: [widget.data.idRef, 'izinSaya', 'notif'])
              .then((value) => {
                    widget.dataCallback!([value, widget.data.idNotif])
                  });
        } else if (widget.data.rute == 'detail_lembur_pegawai') {
          Navigator.pushNamed(context, '/detail_lembur',
                  arguments: [widget.data.idRef, 'lemburPegawai', 'notif'])
              .then((value) => {
                    widget.dataCallback!([value, widget.data.idNotif])
                  });
        } else if (widget.data.rute == 'detail_lembur_saya') {
          Navigator.pushNamed(context, '/detail_lembur',
                  arguments: [widget.data.idRef, 'lemburSaya', 'notif'])
              .then((value) => {
                    widget.dataCallback!([value, widget.data.idNotif])
                  });
        } else if (widget.data.rute == 'detail_berita') {
          Navigator.pushNamed(context, '/detail_berita', arguments: [
            widget.data.idRef,
            'notif'
          ]).then((value) => {
            // print(value),
                widget.dataCallback!([value, widget.data.idNotif])
              });
        } else if (widget.data.rute == 'detail_pengumuman') {
          Navigator.pushNamed(context, '/detail_pengumuman', arguments: [
            widget.data.idRef,
            'notif'
          ]).then((value) => {
                widget.dataCallback!([value, widget.data.idNotif])
              });
        } else if (widget.data.rute == 'detail_shift') {
          Navigator.pushNamed(context, '/detail_tukar_shift', arguments: [
            widget.data.idRef,
            '/pengajuan_tukar_shift',
            'notif'
          ]).then((value) => {
                widget.dataCallback!([value, widget.data.idNotif])
              });
        } else if (widget.data.rute == 'slip_gaji') {
          Navigator.pushNamed(context, '/slip_gaji', arguments: [
            'notif',
            widget.data.idRef
          ]).then((value) => {
                widget.dataCallback!([value, widget.data.idNotif])
              });
        } else if (widget.data.rute == 'detail_pengajuan_kpi_saya') {
          widget.data.ignore == true
              ? showSnackBarDelayed(
                  widget.scaffoldKey, 'Data Sudah Tidak Ada', context)
              : Navigator.pushNamed(context, '/halaman_pengajuan_kpi_saya',
                  arguments: [
                      arrayKpi[0],
                      arrayKpi[1],
                      int.parse(arrayKpi[2]),
                      int.parse(arrayKpi[3]),
                      arrayKpi[4],
                      'notif'
                    ]).then((value) => {
                    print(value),
                    widget.dataCallback!([value, widget.data.idNotif])
                  });
        }else if (widget.data.rute == 'pengajuan_kpi_approval_team') {
          widget.data.ignore == true
              ? showSnackBarDelayed(
                  widget.scaffoldKey, 'Data Sudah Tidak Ada', context)
              : Navigator.pushNamed(context, '/halaman_pengajuan_kpi_approval_team',
                  arguments: [
                      arrayKpi[0],
                      arrayKpi[1],
                      int.parse(arrayKpi[2]),
                      int.parse(arrayKpi[3]),
                      arrayKpi[4],
                      'notif'
                    ]).then((value) => {
                    print(value),
                    widget.dataCallback!([value, widget.data.idNotif])
                  });
        }else if (widget.data.rute == 'detail_approval_kpi_saya') {
          widget.data.ignore == true
              ? showSnackBarDelayed(
                  widget.scaffoldKey, 'Data Sudah Tidak Ada', context)
              : Navigator.pushNamed(context, '/halaman_detail_approval_kpi_saya',
                  arguments: [
                      arrayKpi[0],
                      arrayKpi[1],
                      int.parse(arrayKpi[2]),
                      int.parse(arrayKpi[3]),
                      arrayKpi[4],
                      'notif'
                    ]).then((value) => {
                    print(value),
                    widget.dataCallback!([value, widget.data.idNotif])
                  });
        }else if (widget.data.rute == 'detail_kpi_approval_diterima_team') {
          widget.data.ignore == true
              ? showSnackBarDelayed(
                  widget.scaffoldKey, 'Data Sudah Tidak Ada', context)
              : Navigator.pushNamed(context, '/halaman_detail_approval_kpi',
                  arguments: [
                      arrayKpi[0],
                      arrayKpi[1],
                      int.parse(arrayKpi[2]),
                      int.parse(arrayKpi[3]),
                      arrayKpi[4],
                      'notif'
                    ]).then((value) => {
                    print(value),
                    widget.dataCallback!([value, widget.data.idNotif])
                  });
              // BlocProvider.of<NavigatorBloc>(context)
              //     .add(NavigateToHalamanDetailApprovedKpi(context, [
              //     arrayKpi[0],
              //     arrayKpi[1],
              //     int.parse(arrayKpi[2]),
              //     int.parse(arrayKpi[3]),
              //     arrayKpi[4],
              //     'notif'
              //   ]));
        }
        // else if (widget.data.rute == 'detail_izin_saya')
        //   BlocProvider.of<NavigatorBloc>(context).add(
        //       NavigateToDetailIzin(context, [widget.data.idRef, 'izinSaya','notif']));
        // else if (widget.data.rute == 'detail_lembur_pegawai')
        // BlocProvider.of<NavigatorBloc>(context).add(NavigateToDetailLembur(
        //       context, [widget.data.idRef, 'lemburPegawai','notif']));
        // else if (widget.data.rute == 'detail_lembur_saya')
        //   BlocProvider.of<NavigatorBloc>(context).add(NavigateToDetailLembur(
        //       context, [widget.data.idRef, 'lemburSaya','notif']));
        // else if (widget.data.rute == 'detail_berita')
        //   BlocProvider.of<NavigatorBloc>(context).add(
        //                   NavigateToDetailBerita(
        //                       context, [widget.data.idRef,'notif']));
        // else if (widget.data.rute == 'detail_pengumuman')
        // BlocProvider.of<NavigatorBloc>(context).add(
        //                   NavigateToDetailPengumuman(
        //                       context, [widget.data.idRef,'notif']));
        // else if (widget.data.rute == 'detail_shift')
        //   BlocProvider.of<NavigatorBloc>(context).add(
        //       NavigateToDetailTukarShift(
        //           context, [widget.data.idRef, '/pengajuan_tukar_shift', 'notif']));
        // else if (widget.data.rute == 'slip_gaji')
        //   BlocProvider.of<NavigatorBloc>(context)
        //         .add(NavigateToSlipGaji(context));
      },
      child: Container(
        padding: EdgeInsets.all(15),
        margin: EdgeInsets.fromLTRB(0, 0, 0, 0),
        color:
            widget.data.flagBaca == '0' ? Colors.grey.shade300 : Colors.white,
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
              Container(
                padding: EdgeInsets.symmetric(horizontal: 8),
                child: Row(
                  children: [
                    Image.asset(ValueImage.iconNotif,
                        width: 20,
                        height: 20,
                        color: widget.data.flagBaca == '1'
                            ? Colors.grey.shade500
                            : CustomStyle.color1),
                    SizedBox(width: 10),
                  ],
                ),
              ),
              Expanded(
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Expanded(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            widget.data.ketNotif.toString(),
                            style: TextStyle(
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                fontWeight: FontWeight.w600),
                          ),
                          SizedBox(height: 5),
                          Text(
                            formatted,
                            style: TextStyle(
                              fontSize: CustomStyle.fontSizeNormal - 2,
                            ),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            ]),
            SizedBox(
              height: 8,
            ),
          ],
        ),
      ),
    );
  }
}

class VDivider extends StatelessWidget {
  const VDivider({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 60,
      margin: EdgeInsets.symmetric(horizontal: 12),
      decoration: BoxDecoration(
        border: Border(
          right: BorderSide(
            color: Theme.of(context).dividerColor,
            width: 2,
          ),
        ),
      ),
    );
  }
}
