import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/MonitorAbsensi/BadgeMonitorAbsenBloc.dart';
import 'package:absenkuv3/Bloc/MonitorAbsensi/MonitorAbsenBloc.dart';
import 'package:absenkuv3/Bloc/MonitorAbsensi/SelectedBadgeMonitor.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/MonitorAbsensi/KomponenMonitorAbsen/KomponenMonitorAbsen.dart';
import 'package:absenkuv3/UI/Modul/MonitorAbsensi/KomponenMonitorAbsen/KomponenMonitorIzinAbsen.dart';
import 'package:absenkuv3/UI/Template/style.dart';

class MonitorAbsensiDashboard extends StatefulWidget {
  const MonitorAbsensiDashboard({Key? key}) : super(key: key);

  @override
  _MonitorAbsensiDashboardState createState() =>
      _MonitorAbsensiDashboardState();
}

class _MonitorAbsensiDashboardState extends State<MonitorAbsensiDashboard> {
  late Future<dynamic> _languageData;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<BadgeMonitorAbsenBloc>(context)
        .add(GetBadgeMonitorAbsen(context));
    context.read<SelectedBadgeMonitor>().changeSelectedId('A');
    _triggerMonitorAbsenEvent('A');
    _languageData = PengaturanBahasa().monitorAbsen();
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<AuthBloc, LoginRespon>(
      builder: (context, loginRespon) {
        return FutureBuilder(
          future: _languageData,
          builder: (context, snapshot) {
            if (snapshot.connectionState == ConnectionState.done) {
              return Column(
                children: [
                  _buildTabSelector(context, snapshot.data!),
                  _buildContent(context, snapshot.data!),
                ],
              );
            } else {
              return Container(height: 300);
            }
          },
        );
      },
    );
  }

  Widget _buildTabSelector(BuildContext context, dynamic languageData) {
    return Container(
      height: 50,
      width: MediaQuery.of(context).size.width,
      child: Padding(
        padding: const EdgeInsets.only(top: 5),
        child: BlocBuilder<BadgeMonitorAbsenBloc, BadgeMonitorAbsenState>(
          builder: (context, state) {
            if (state is GetSuccessBadgeMonitor) {
              return BlocBuilder<SelectedBadgeMonitor, String>(
                builder: (context, idSelected) {
                  if (state.dataColumn!.data!.isNotEmpty &&
                      !state.dataColumn!.data!
                          .any((item) => item.key == idSelected)) {
                    final firstId = state.dataColumn!.data![0].key!;
                    WidgetsBinding.instance.addPostFrameCallback((_) {
                      context
                          .read<SelectedBadgeMonitor>()
                          .changeSelectedId(firstId);
                      _triggerMonitorAbsenEvent(firstId);
                    });
                  }
                  return ListView.builder(
                      itemCount: state.dataColumn!.data!.length,
                      scrollDirection: Axis.horizontal,
                      itemBuilder: (BuildContext context, index) {
                        final item = state.dataColumn!.data![index];
                        return Row(
                          children: [
                            Row(
                              children: [
                                Stack(
                                  children: [
                                    Row(
                                      children: [
                                        SizedBox(
                                          width: 4,
                                        ),
                                        ChoiceChip(
                                          padding: EdgeInsets.symmetric(
                                              horizontal: 5),
                                          shape: RoundedRectangleBorder(
                                              side: BorderSide(
                                                  color: CustomStyle.color1,
                                                  strokeAlign: 1),
                                              borderRadius: BorderRadius.only(
                                                  topRight: Radius.circular(12),
                                                  bottomRight:
                                                      Radius.circular(12),
                                                  topLeft: Radius.circular(12),
                                                  bottomLeft:
                                                      Radius.circular(12))),
                                          backgroundColor: Colors.transparent,
                                          labelPadding: EdgeInsets.only(
                                              left: 10, right: 10),
                                          selectedColor: CustomStyle.color1,
                                          selected: state.dataColumn!
                                                  .data![index].key ==
                                              idSelected,
                                          // label: Text(state.dataColumn!
                                          //         .data![index].nama ??
                                          //     ''),
                                          label: Container(
                                            child: Row(
                                              children: [
                                                Text(state.dataColumn!
                                                        .data![index].nama ??
                                                    ''),
                                                state.dataColumn!.data![index]
                                                            .jumlah !=
                                                        0
                                                    ? Row(
                                                        children: [
                                                          SizedBox(
                                                            width: 5,
                                                          ),
                                                          Container(
                                                            child: Center(
                                                              child: Text(
                                                                state
                                                                    .dataColumn!
                                                                    .data![
                                                                        index]
                                                                    .jumlah
                                                                    .toString(),
                                                                style: TextStyle(
                                                                    color: Colors
                                                                        .white),
                                                              ),
                                                            ),
                                                            decoration:
                                                                new BoxDecoration(
                                                              color: Colors.red,
                                                              shape: BoxShape
                                                                  .circle,
                                                            ),
                                                            height: MediaQuery.of(
                                                                        context)
                                                                    .size
                                                                    .width *
                                                                0.05,
                                                            width: MediaQuery.of(
                                                                        context)
                                                                    .size
                                                                    .width *
                                                                0.05,
                                                          )
                                                        ],
                                                      )
                                                    : Text('')
                                              ],
                                            ),
                                          ),
                                          labelStyle: TextStyle(
                                              color: state.dataColumn!
                                                          .data![index].key ==
                                                      idSelected
                                                  ? Colors.white
                                                  : CustomStyle.color1),
                                          elevation: 1,
                                          onSelected: (_) {
                                            context
                                                .read<SelectedBadgeMonitor>()
                                                .changeSelectedId(item.key!);
                                            _triggerMonitorAbsenEvent(
                                                item.key!);
                                          },
                                        ),
                                      ],
                                    ),
                                  ],
                                )
                              ],
                            )
                          ],
                        );
                      });
                },
              );
            } else if (state is GetBadgeMonitorProgress) {
              return _buildShimmerLoading();
            } else {
              return Container();
            }
          },
        ),
      ),
    );
  }

  Widget _buildContent(BuildContext context, dynamic languageData) {
    return BlocBuilder<SelectedBadgeMonitor, String>(
      builder: (context, idSelected) {
        return BlocBuilder<MonitorAbsenBloc, MonitorAbsenState>(
          builder: (context, state) {
            if (state is SuccessMonitorAbsenState) {
              return Stack(
                children: [
                  Column(
                    children: [
                      ListView.builder(
                        shrinkWrap: true,
                        physics: NeverScrollableScrollPhysics(),
                        itemCount: state.dataMonitorAbsen!.length,
                        itemBuilder: (context, index) {
                          return idSelected == 'A' ||
                                  idSelected == 'T' ||
                                  idSelected == null
                              ? state.dataMonitorAbsen![index] != null
                                  ? CardMonitorAbsen(
                                      state.dataMonitorAbsen![index],
                                      languageData,
                                      state.jenis_data,
                                    )
                                  : Container() // or some placeholder widget
                              : state.dataMonitorAbsen![index] != null
                                  ? CardMonitorIzinAbsen(
                                      state.dataMonitorAbsen![index],
                                      languageData,
                                    )
                                  : Container();
                        },
                      ),
                      GestureDetector(
                          onTap: () async {
                            BlocProvider.of<NavigatorBloc>(context).add(
                                NavigateToHalamanListMonitorAbsen(
                                    context, [idSelected, languageData]));
                          },
                          child: Container(
                            padding: EdgeInsets.all(10),
                            child: Text(
                              languageData
                                  .menuMonitorAbsensi!.data!.buttonLihatSemua
                                  .toString(),
                              style: TextStyle(
                                  fontSize: 12,
                                  color: Color(0XFF1C77D4),
                                  fontWeight: FontWeight.bold),
                            ),
                          ))
                    ],
                  ),
                ],
              );
            } else if (state is ProgressMonitorAbsenState) {
              return ShimerMonitorAbsensi();
            } else {
              return Center(
                child: Image.asset(
                  ValueImage.noData,
                  height: 250,
                ),
              );
            }
          },
        );
      },
    );
  }

  Widget _buildShimmerLoading() {
    return ListView.builder(
      itemCount: 3,
      scrollDirection: Axis.horizontal,
      itemBuilder: (context, index) {
        return Shimmer.fromColors(
          baseColor: Colors.grey[200]!,
          highlightColor: Colors.white,
          child: Container(
            height: 30,
            width: 70,
            child: Card(),
          ),
        );
      },
    );
  }

  void _triggerMonitorAbsenEvent(String idSelected) {
    BlocProvider.of<MonitorAbsenBloc>(context).add(
      GetMonitorAbsenEvent(context, idSelected, '5'),
    );
  }
}
