// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/MonitorAbsen/mMonitorAbsen.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mMonitorAbsenPage.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

class CardMonitorAbsen extends StatefulWidget {
  DataMonitorAbsen dataMonitorAbsen;
  PageMonitorAbsenModel redaksional;
  String? jenis_data;

  CardMonitorAbsen(this.dataMonitorAbsen, this.redaksional,this.jenis_data);
  @override
  State<CardMonitorAbsen> createState() => _CardMonitorAbsenState();
}

class _CardMonitorAbsenState extends State<CardMonitorAbsen> {
  @override
  Widget build(BuildContext context) {
    final menu = widget.redaksional.menuMonitorAbsensi!.data;
    String idKaryawan = widget.dataMonitorAbsen.idKaryawan ?? 'Unknown';
    String tgl = widget.dataMonitorAbsen.tglAbsensi ?? 'N/A';

    return GestureDetector(
        onTap: () {
          // tgl != ''
          //     ? BlocProvider.of<NavigatorBloc>(context).add(
          //         NavigateToDetailListRekapAbsensi(context, [idKaryawan, tgl]))
          //     : null;
          widget.jenis_data =='terlambat' ?
              BlocProvider.of<NavigatorBloc>(context).add(
                  NavigateToDetailListRekapAbsensi(context, [idKaryawan,tgl]))
              : null ;
        },
        child: Container(
          decoration: CustomStyle.boxDecoration2,
          margin: EdgeInsets.all(5),
          child: Padding(
              padding: EdgeInsets.all(10),
              child: Container(
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Flexible(child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                        Container(
                          child: Row(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Expanded(
                                  child:
                                  Row(
                                    children: [

                                          Flexible(
                                            child: Text(
                                        widget.dataMonitorAbsen.namaKaryawan.toString(),
                                        maxLines: 2,
                                        style: TextStyle(
                                            fontWeight: FontWeight.bold,
                                        ),
                                      ),
                                          ),
                                      SizedBox(
                                        width: 8,
                                      ),
                                    ],
                                  )
                              ),
                            ],
                          ),
                        ),
                                Text(widget.dataMonitorAbsen.jabatan.toString()),
                      ],
                    )
                    ),
                    SizedBox(
                      width: 8,
                    ),
                    widget.jenis_data != 'terlambat' ?
                    Row(
                      children: [
                        Column(
                          children: [
                            Row(
                              children: [
                                Container(
                                  margin: EdgeInsets.only(right: 4),
                                  width: 5,
                                  height: 5,
                                ),
                                Text(menu!.jamKerja.toString(),
                                    style: TextStyle(
                                        fontSize: 12,
                                        fontWeight: FontWeight.w500)),
                              ],
                            ),
                            SizedBox(height: 5,),
                            Row(
                              children: [
                                TemplateButton(
                                  label: widget.dataMonitorAbsen.jenisJamKerja! ?? '-',
                                  color: Color(int.parse(
                                      widget.dataMonitorAbsen.bgColor!)),
                                  contentColor: Color(int.parse(
                                      widget.dataMonitorAbsen.fontColor!)),
                                  fontSize: 10,
                                  radius: 7,
                                  paddingTopBottom: 4,
                                  heightButton: 30,
                                  bold: true,
                                  paddingLeftRight: 4,
                                  borderColor: Color(int.parse(widget.dataMonitorAbsen.fontColor!)),
                                ),
                                VDividerV2(),
                                Text(
                                  widget.dataMonitorAbsen.jamKerja!,
                                  style: TextStyle(
                                      color: Colors.blue,
                                      fontSize: 19,
                                      fontWeight: FontWeight.w500),
                                ),
                              ],
                            )
                          ],
                        ),
                      ],
                    ):
                        Row(
                          children: [
                            Column(
                              children: [
                                Row(
                                  children: [
                                    Container(
                                      margin: EdgeInsets.only(right: 4),
                                      width: 5,
                                      height: 5,
                                      decoration: BoxDecoration(
                                          color: CustomStyle.color1,
                                          borderRadius: BorderRadius.circular(10)),
                                    ),
                                    Text(menu!.jamKerja.toString(),
                                        style: TextStyle(
                                            fontSize: 12,
                                            fontWeight: FontWeight.w500)),
                                  ],
                                ),
                                Text(
                                  widget.dataMonitorAbsen.jamKerja!,
                                  style: TextStyle(
                                      color: Colors.blue,
                                      fontSize: 19,
                                      fontWeight: FontWeight.w500),
                                ),
                              ],
                            ),
                            VDivider(),
                            Column(
                              children: [
                                Row(
                                  children: [
                                    Container(
                                      margin: EdgeInsets.only(right: 4),
                                      width: 5,
                                      height: 5,
                                      decoration: BoxDecoration(
                                          color: CustomStyle.colorGreen,
                                          borderRadius: BorderRadius.circular(10)),
                                    ),
                                    Text(menu!.masuk.toString(),
                                        style: TextStyle(
                                            fontSize: 12,
                                            fontWeight: FontWeight.w500)),
                                  ],
                                ),
                                Text(
                                  widget.dataMonitorAbsen.absenMasuk!,
                                  style: TextStyle(
                                      color: CustomStyle.colorGreen,
                                      fontSize: 19,
                                      fontWeight: FontWeight.w500),
                                ),
                              ],
                            )
                          ],
                        )
                  ],
                ),
              )
              ),
        ));
  }
}

class VDivider extends StatelessWidget {
  const VDivider({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 50,
      margin: EdgeInsets.symmetric(horizontal: 12),
      decoration: BoxDecoration(
        border: Border(
          right: BorderSide(
            color: Theme.of(context).dividerColor,
            width: 2,
          ),
        ),
      ),
    );
  }
}
class VDividerV2 extends StatelessWidget {
  const VDividerV2({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 30,
      margin: EdgeInsets.symmetric(horizontal: 12),
      decoration: BoxDecoration(
        border: Border(
          right: BorderSide(
            color: Theme.of(context).dividerColor,
            width: 2,
          ),
        ),
      ),
    );
  }
}

class ShimerMonitorAbsensi extends StatelessWidget {
  const ShimerMonitorAbsensi({super.key});

  @override
  Widget build(BuildContext context) {
    return Column(
        children: [card(context), card(context), card(context), card(context)]);
  }

  Widget card(BuildContext context) {
    return Container(
      height: 70,
      width: MediaQuery.of(context).size.width,
      child: Shimmer.fromColors(
        baseColor: Colors.grey[200]!,
        highlightColor: Colors.white,
        period: Duration(seconds: 4),
        child: Card(),
      ),
    );
  }
}

