import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLoginPage.dart';
import 'package:absenkuv3/Repository/Model/mUsernameLupaPassword.dart';
import 'package:absenkuv3/Repository/Service/authApi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Login_SplashScreen/halamanLogin.dart';
import 'package:absenkuv3/UI/Modul/LupaPassword/HalamanLupaPasswordSuccess.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateForm.dart';
import 'package:flutter/material.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

class HalamanEmail extends StatefulWidget {
  final String idKaryawan;
  final String idCompany;
  final PageLoginModel redaksional;

  HalamanEmail(this.idKaryawan, this.idCompany, this.redaksional);

  @override
  State<HalamanEmail> createState() => _HalamanEmailState();
}

class _HalamanEmailState extends State<HalamanEmail> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  TextEditingController email = TextEditingController();
  Color col = Colors.grey;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        flexibleSpace: Image(
          image: AssetImage(ValueImage.headerBiruDashboard),
          fit: BoxFit.cover,
        ),
        backgroundColor: Colors.transparent,
        title: Text(
          widget.redaksional.menuEmailLupaPassword!.title!,
          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
        ),
      ),
      body: SingleChildScrollView(
        child: Container(
          margin: EdgeInsets.fromLTRB(13, 27, 13, 13),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              Container(
                  width: MediaQuery.of(context).size.width,
                  child: Image.asset(ValueImage.iconEmailLP, height: 150)),
              SizedBox(height: 17),
              Text(widget.redaksional.menuEmailLupaPassword!.header!, style: TextStyle(fontWeight: FontWeight.w700, fontSize: 18)),
              SizedBox(height: 3),
              Text(widget.redaksional.menuEmailLupaPassword!.subHeader!, style: TextStyle(fontSize: 13),),
              SizedBox(height: 43),
              TemplateForm(
                  formHeight: 42,
                  titleText: widget.redaksional.menuEmailLupaPassword!.email,
                  hintText: "${widget.redaksional.menuEmailLupaPassword!.subHeader} ...",
                  controller: email,
                  fontSize: 13,
                  color: col,
                  radius: 24,
                onChange: (p) {
                    if(email.text != "" && col == Colors.grey){
                      setState(() {
                        col = Colors.black;
                      });
                    }else if(email.text == "" && col == Colors.black){
                      setState(() {
                        col = Colors.grey;
                      });
                    }
                }),

              Container(
                margin: EdgeInsets.only(top: MediaQuery.of(context).size.height/3.5),
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.end,
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Text('${widget.redaksional.menuEmailLupaPassword!.labelIngatPassword}?  ', style: TextStyle(color: Colors.grey, fontSize: 13, fontWeight: FontWeight.w500)),
                        GestureDetector(
                            onTap: ()=> Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => HalamanLogin())),
                            child: Text('Login', style: TextStyle(color: CustomStyle.color1, fontSize: 13, fontWeight: FontWeight.w500))),
                      ],
                    ),
                    SizedBox(height: 41),
                    TemplateButton(
                      onClick: () async {
                        if(email.text.trim() == ""){
                          openDialog(true, widget.redaksional.message!.peringatan!, widget.redaksional.message!.emailEmpty!);
                        }else{
                          ProgressDialog pd = ProgressDialog(context: context);
                          ProgressDialogDelayed.show(pd, isDismissible: false);
                          UsernameLupaPasswordRespon data = await AuthApi().cekEmail(widget.idKaryawan, widget.idCompany, email.text);
                          ProgressDialogDelayed.hide(pd);
                          if (data.success!) {
                            Navigator.pushReplacement(context, MaterialPageRoute(builder: (_) => HalamanLupaPasswordSuccess(widget.redaksional)));
                          }else{
                            openDialog(false, widget.redaksional.message!.tidakDitemukan!, data.message!);
                          }
                        }
                      },
                      label: widget.redaksional.menuEmailLupaPassword!.btnNext,
                      color: CustomStyle.color1,
                      fontSize: CustomStyle.fontSizeNormal,
                      paddingTopBottom: 8,
                      expand: true,
                      borderColor: Colors.white,
                      radius: 24,
                      heightButton: 42,
                    ),
                  ],
                ),
              )
            ],
          ),
        ),
      ),
    );
  }

  openDialog(bool peringatan, String title, String deskripsi){
    return showDialog(
        context: context,
        builder: (c){
          return AlertDialog(
            shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(13)
            ),
            title: Container(
              margin: EdgeInsets.only(top: 37),
              child: Center(
                  child: peringatan
                          ? Icon(Icons.info_outline, size: 75, color: Colors.orange,)
                          : Image.asset(ValueImage.iconErrorLP, height: 65)),
            ),
            titlePadding: EdgeInsets.all(0),
            contentPadding: EdgeInsets.only(top: 5, left: 27, right: 27, bottom: 37),
            content: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisSize: MainAxisSize.min,
              children: [
                SizedBox(height: 9),
                Text(title, style: TextStyle(fontWeight: FontWeight.w700, fontSize: 17)),
                SizedBox(height: peringatan ? 9 : 3),
                Text(deskripsi, style: TextStyle(color: Colors.grey, fontSize: 13), textAlign: TextAlign.center),
              ],
            ),

          );
        }
    );
  }
}
