import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLemburPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Lembur/HalamanListRekapLemburPegawai.dart';
import 'package:absenkuv3/UI/Modul/Lembur/HalamanListRekapLemburSaya.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class ParentTabRekapLembur extends StatelessWidget {
  final int tabLength = 2;
  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageLemburModel>(
        future: PengaturanBahasa().lembur(),
        builder: (context, snapshot){
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<AuthBloc, LoginRespon>(
                builder: (BuildContext context, LoginRespon loginRespon){
                  return DefaultTabController(
                    length: tabLength,
                    child: Scaffold(
                      appBar: AppBar(
                        centerTitle: true,
                        flexibleSpace: Image(
                          image: AssetImage(ValueImage.headerBiruDashboard),
                          fit: BoxFit.cover,
                        ),
                        backgroundColor: Colors.transparent,
                        title: Text(snapshot.data!.menuLembur!.titleRekap!, style: TextStyle(fontSize: CustomStyle.fontSizeTitle),),
                        bottom: loginRespon.dataLogin!.level!=3?TabBar(
                          labelPadding: EdgeInsets.all(0),
                          indicatorSize: TabBarIndicatorSize.tab,
                          indicatorWeight: 4,
                          isScrollable: true,
                          tabs: [
                            Container(
                              width: MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: snapshot.data!.menuLembur!.tabSaya,
                              ),
                            ),
                            Container(
                              width: MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: snapshot.data!.menuLembur!.tabKaryawan,
                              ),
                            ),
                          ],
                        ):null,
                      ),
                      body: TabBarView(
                        physics: NeverScrollableScrollPhysics(),
                        children: [
                          HalamanListRekapLemburSaya(snapshot.data!),
                          HalamanListRekapLemburPegawai(snapshot.data!),
                        ],
                      ),
                    ),
                  );
                });
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );
  }
}


