import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLemburPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'HalamanListLemburSaya.dart';
import 'HalamanListLemburKaryawan.dart';

class ParentTabLembur extends StatefulWidget {
  @override
  State<ParentTabLembur> createState() => _ParentTabLemburState();
}

class _ParentTabLemburState extends State<ParentTabLembur> {
  final int tabLength = 2;

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateRemoveToDashboard(context));
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageLemburModel>(
        future: PengaturanBahasa().lembur(),
        builder: (context, snapshot){
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<AuthBloc, LoginRespon>(
                builder: (BuildContext context, LoginRespon loginRespon){
                  return WillPopScope(
                    onWillPop: keluar,
                    child: DefaultTabController(
                      length: tabLength,
                      child: Scaffold(
                        appBar: AppBar(
                          centerTitle: true,
                          flexibleSpace: Image(
                            image: AssetImage(ValueImage.headerBiruDashboard),
                            fit: BoxFit.cover,
                          ),
                          backgroundColor: Colors.transparent,
                          title: Text(snapshot.data!.menuLembur!.title!, style: TextStyle(fontSize: CustomStyle.fontSizeTitle),),
                          bottom: loginRespon.dataLogin!.level!=3?TabBar(
                            labelPadding: EdgeInsets.all(0),
                            indicatorSize: TabBarIndicatorSize.tab,
                            indicatorWeight: 4,
                            isScrollable: true,
                            tabs: [
                              Container(
                                width: MediaQuery.of(context).size.width / tabLength,
                                child: Tab(
                                  text: snapshot.data!.menuLembur!.tabSaya,
                                ),
                              ),
                              Container(
                                width: MediaQuery.of(context).size.width / tabLength,
                                child: Tab(
                                  text: snapshot.data!.menuLembur!.tabKaryawan,
                                ),
                              ),
                            ],
                          ):null,
                          actions: [
                            GestureDetector(
                              onTap: ()=>BlocProvider.of<NavigatorBloc>(context)
                                  .add(NavigateToPengajuanLembur(context)),
                              child: Container(
                                  margin: EdgeInsets.only(right: 14),
                                  child: Icon(Icons.add, size: 26,)),
                            ),
                          ],
                        ),
                        body: TabBarView(
                          physics: NeverScrollableScrollPhysics(),
                          children: [
                            HalamanListLemburSaya(snapshot.data!),
                            HalamanListLemburKaryawan(snapshot.data!),
                          ],
                        ),
                      ),
                    ),
                  );
                });
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );
  }
}


