import 'package:absenkuv3/Bloc/Lembur/LemburBloc.dart';
import 'package:absenkuv3/Bloc/Lembur/LemburPegawaiBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLemburPage.dart';
import 'package:absenkuv3/Repository/Model/mLembur.dart';
import 'package:absenkuv3/UI/Template/halamanDetailMap.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

class CardLembur extends StatefulWidget {
  final DataLembur dataLembur;
  final String konteks;
  final GlobalKey<ScaffoldState> scaffoldKey;
  final PageLemburModel redaksional;
  CardLembur(this.dataLembur, this.konteks, this.scaffoldKey, this.redaksional);

  @override
  _CardLemburState createState() => _CardLemburState();
}

class _CardLemburState extends State<CardLembur> {
  @override
  Widget build(BuildContext context) {
    String tgl = widget.dataLembur.tglAbsenMasuk!;
    DateTime dateTime = DateTime.parse(tgl);
    String hariSingkat = DateFormat('EE', widget.redaksional.menuLembur!.locale).format(dateTime);
    String hariFull = DateFormat('EEEE', widget.redaksional.menuLembur!.locale).format(dateTime);
    return GestureDetector(
      onTap: () => BlocProvider.of<NavigatorBloc>(context)
          .add(NavigateToDetailLembur(context, [
        widget.konteks == 'rekapSaya' || widget.konteks == 'rekapPegawai'
            ? widget.dataLembur.idLembur!
            : widget.dataLembur.idLemmulai!,
        widget.konteks,
        'komponen'
      ])),
      child: Container(
        decoration: BoxDecoration(
            color: Color(int.parse(widget.dataLembur.warna!)),
            borderRadius:
            BorderRadius.all(Radius.circular(CustomStyle.cardRadius))),
        margin: EdgeInsets.only(top: 12, left: 12, right: 12),
        padding: EdgeInsets.only(left: 5),
        child: Column(
          children: [
            Container(
              decoration: CustomStyle.boxDecoration2,
              child: Column(
                children: [
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      const SizedBox(
                        width: 12,
                      ),
                      widget.konteks == "lemburPegawai"  || widget.konteks == "rekapPegawai"? Expanded(
                        flex: 1,
                        child:  Container(
                          // margin: EdgeInsets.symmetric(vertical: 12),
                          padding: EdgeInsets.symmetric(vertical: 12),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              Text(
                                hariSingkat,
                                style: TextStyle(
                                    fontSize:12,
                                    color: CustomStyle.fontColorGrey,
                                    fontWeight: FontWeight.w400),
                              ),
                              SizedBox(
                                height: 6,
                              ),
                              Text(
                                  DateFormat('dd').format(dateTime),
                                  style: TextStyle(
                                      fontSize: 16,
                                      fontWeight: FontWeight.w600)),
                              SizedBox(
                                height: 6,
                              ),
                              Text(
                                DateFormat.MMM(widget.redaksional.menuLembur!.locale).format(dateTime),
                                style: TextStyle(
                                    fontSize:12,
                                    color: CustomStyle.fontColorGrey,
                                    fontWeight: FontWeight.w400),
                              ),
                            ],
                          ),
                        ) ,
                      ) :Container(),
                      widget.konteks == "lemburSaya" || widget.konteks =="rekapSaya" ? Expanded(
                        flex: 1,
                        child:  Column(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            Text(
                              DateFormat.MMM(widget.redaksional.menuLembur!.locale).format(dateTime),
                              style: TextStyle(
                                  fontSize: 14,
                                  color: CustomStyle.fontColorGrey,
                                  fontWeight: FontWeight.w400),
                            ),
                            SizedBox(
                              height: 6,
                            ),
                            Text(DateFormat('dd').format(dateTime),
                                // "01",
                                style: TextStyle(
                                    fontSize: 16,
                                    fontWeight: FontWeight.w600)),
                          ],
                        ) ,
                      ) :Container(),
                      VDivider(),
                      Expanded(
                        flex: 8,
                        child: Container(
                          width: MediaQuery.of(context).size.width,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Expanded(
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    widget.konteks == "lemburPegawai" || widget.konteks== "rekapPegawai"?Text(widget.dataLembur.nama!,
                                        style: TextStyle(
                                            fontSize: 14,
                                            fontWeight: FontWeight.w600)):Container(),
                                    widget.konteks == "lemburSaya" || widget.konteks =="rekapSaya"?Text(hariFull,
                                        style: TextStyle(
                                            fontSize: 14,
                                            fontWeight: FontWeight.w600)):Container(),
                                    SizedBox(
                                      height: 4,
                                    ),
                                    widget.dataLembur.status != null ? Text(widget.dataLembur.status!,
                                        style: TextStyle( fontSize: 12, fontWeight: FontWeight.w400, color: Color(int.parse(widget.dataLembur.warna!)))):Container(),
                                  ],
                                ),
                              ),
                              Row(
                                children: [
                                  Column(
                                    children: [
                                      Row(
                                        children: [
                                          Container(
                                            margin: EdgeInsets.only(right: 4),
                                            width: 5,
                                            height: 5,
                                            decoration: BoxDecoration(
                                                color: Colors.green,
                                                borderRadius:
                                                BorderRadius.circular(10)),
                                          ),
                                          Text(widget.redaksional.menuLembur!.data!.jamMulai!,
                                              style: TextStyle(
                                                  fontSize:
                                                  12,
                                                  fontWeight: FontWeight.w500)),
                                        ],
                                      ),
                                      SizedBox(
                                        height: 4,
                                      ),
                                      Text(
                                        widget.dataLembur.jamMasuk!,
                                        style: TextStyle(
                                            color: Colors.blue,
                                            fontSize: 19,
                                            fontWeight: FontWeight.w500),
                                      ),
                                    ],
                                  ),
                                  VDivider(),
                                  Column(
                                    children: [
                                      Row(
                                        children: [
                                          Container(
                                            margin: EdgeInsets.only(right: 4),
                                            width: 5,
                                            height: 5,
                                            decoration: BoxDecoration(
                                                color: Colors.red,
                                                borderRadius:
                                                BorderRadius.circular(10)),
                                          ),
                                          Text(widget.redaksional.menuLembur!.data!.jamSelesai!,
                                              style: TextStyle(
                                                  fontSize:
                                                  12,
                                                  fontWeight: FontWeight.w500)),
                                        ],
                                      ),
                                      SizedBox(
                                        height: 4,
                                      ),
                                      Text(
                                        widget.dataLembur.jamPulang!,
                                        style: TextStyle(
                                            color: Colors.blue,
                                            fontSize: 19,
                                            fontWeight: FontWeight.w500),
                                      ),
                                    ],
                                  ),
                                  SizedBox(
                                    width: 8,
                                  ),
                                ],
                              )
                            ],
                          ),
                        ),
                      ),
                    ],
                  ),
                  widget.konteks == "lemburPegawai"  || widget.konteks == "rekapPegawai"? Container(
                    padding: EdgeInsets.symmetric(horizontal:12),
                    child: Column(
                      children: [
                        Divider(thickness: 2,),
                        Container(
                          padding: EdgeInsets.symmetric(vertical:8),
                          child: Row(
                            children: [
                              Text(
                                "${widget.redaksional.menuLembur!.data!.totalLembur} : ",
                                style: TextStyle(
                                    fontSize: 12,
                                    color: CustomStyle.fontColorGrey,
                                    fontWeight: FontWeight.w400),
                              ),
                              Text(
                                widget.dataLembur.totalJamLembur!,
                                style: TextStyle(fontSize: 12, fontWeight: FontWeight.w600),
                              ),
                            ],
                          ),
                        ),

                      ],
                    ),
                  ) : Container()
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  // openConfirmationDialog(title, action, context, String locale) {
  //   showDialog(
  //       context: context,
  //       builder: (BuildContext context) {
  //         return AlertDialog(
  //           shape: RoundedRectangleBorder(
  //               borderRadius:
  //               BorderRadius.all(Radius.circular(CustomStyle.boxRadius))),
  //           content: Column(
  //             mainAxisSize: MainAxisSize.min,
  //             children: [
  //               Center(
  //                 child: Text(
  //                   title,
  //                   style: TextStyle(
  //                       fontSize: CustomStyle.fontSizeNormal,
  //                       fontWeight: FontWeight.w600),
  //                 ),
  //               ),
  //               Row(
  //                 mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                 children: [
  //                   TemplateButton(
  //                     onClick: () => BlocProvider.of<NavigatorBloc>(context)
  //                         .add(NavigatePop(context)),
  //                     label: "Tidak",
  //                     color: Colors.transparent,
  //                     contentColor: CustomStyle.color1,
  //                     fontSize: CustomStyle.fontSizeNormal,
  //                     bold: true,
  //                   ),
  //                   TemplateButton(
  //                     onClick: action,
  //                     label: "Ya",
  //                     color: Colors.transparent,
  //                     contentColor: CustomStyle.color1,
  //                     fontSize: CustomStyle.fontSizeNormal,
  //                     bold: true,
  //                   )
  //                 ],
  //               )
  //             ],
  //           ),
  //         );
  //       });
  // }

  // actionMenu() {
  //   List<String> buttonAksi;
  //   if (widget.konteks == 'lemburSaya' && widget.dataLembur.aksiBatalkan!)
  //     buttonAksi = ['Detail', 'Batalkan'];
  //   else if (widget.konteks == 'lemburPegawai' &&
  //       widget.dataLembur.aksi! &&
  //       !widget.dataLembur.buttonApprovalHrd!)
  //     buttonAksi = ['Detail', 'Setujui', 'Tolak'];
  //   else if (widget.konteks == 'lemburPegawai' &&
  //       widget.dataLembur.aksi! &&
  //       widget.dataLembur.buttonApprovalHrd!)
  //     buttonAksi = ['Detail', 'Setujui Semua', 'Tolak Semua'];
  //   else
  //     buttonAksi = ['Detail'];
  //   return buttonAksi.map((String choice) {
  //     return PopupMenuItem<String>(
  //       value: choice,
  //       child: Text(choice),
  //     );
  //   }).toList();
  // }

  // void doAction(BuildContext context, String value) {
  //   if (value == 'Batalkan')
  //     openConfirmationDialog(
  //         'Apakah anda yakin akan membatalkan pengajuan lembur ini?',
  //             () => BlocProvider.of<LemburBloc>(context).add(batalkanLembur(
  //             widget.dataLembur.idLemmulai, context, widget.scaffoldKey)),
  //         context);
  //   else if (value == 'Setujui')
  //     openConfirmationDialog(
  //         'Apakah anda yakin akan menyetujui pengajuan lembur ini?',
  //             () => BlocProvider.of<LemburPegawaiBloc>(context).add(setujuiLembur(
  //             widget.dataLembur.idLemmulai,
  //             context,
  //             widget.scaffoldKey,
  //             'listLemburPegawai')),
  //         context);
  //   else if (value == 'Setujui Semua')
  //     openConfirmationDialog(
  //         'Apakah anda yakin akan mewakili pihak sebelumnya dalam persetujuan lembur ini?',
  //             () => BlocProvider.of<LemburPegawaiBloc>(context).add(
  //             MewakiliSetujuiLembur(widget.dataLembur.idLemmulai, context,
  //                 widget.scaffoldKey, 'listLemburPegawai')),
  //         context);
  //   else if (value == 'Tolak')
  //     openConfirmationDialog(
  //         'Apakah anda yakin akan menolak pengajuan lembur ini?',
  //             () => BlocProvider.of<LemburPegawaiBloc>(context).add(tolakLembur(
  //             widget.dataLembur.idLemmulai,
  //             context,
  //             widget.scaffoldKey,
  //             'listLemburPegawai')),
  //         context);
  //   else if (value == 'Tolak Semua')
  //     openConfirmationDialog(
  //         'Apakah anda yakin akan mewakili pihak sebelumnya dalam penolakan lembur ini?',
  //             () => BlocProvider.of<LemburPegawaiBloc>(context).add(
  //             MewakiliTolakLembur(widget.dataLembur.idLemmulai, context,
  //                 widget.scaffoldKey, 'listLemburPegawai')),
  //         context);
  //   else if (value == 'Detail')
  //     BlocProvider.of<NavigatorBloc>(context).add(NavigateToDetailLembur(
  //         context, [widget.dataLembur.idLemmulai, widget.konteks]));
  // }
}

class TemplateRow extends StatelessWidget {
  final String title;
  final String? subTitle;
  final Color? color;
  final String? imageUrl;
  final String? lat;
  final String? long;

  TemplateRow(this.title, this.subTitle, this.imageUrl, this.color,
      {this.lat = '-', this.long = '-'});

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        Expanded(
          flex: 5,
          child: Text(
            title,
            style: TextStyle(
                fontWeight: FontWeight.w600,
                color: color,
                fontSize: CustomStyle.fontSizeSmall - 1),
          ),
        ),
        SizedBox(
          width: 12,
        ),
        Expanded(
          flex: 7,
          child: Text(
            subTitle!,
            style: TextStyle(
                color: CustomStyle.fontColorBlack,
                fontSize: CustomStyle.fontSizeSmall - 1),
          ),
        ),
        SizedBox(
          width: 8,
        ),
        Expanded(
          flex: 1,
          child: imageUrl != null
              ? GestureDetector(
              onTap: () => BlocProvider.of<NavigatorBloc>(context)
                  .add(NavigateToDetailImageClicked(context, imageUrl)),
              child: Icon(
                Icons.image,
                color: Colors.grey[500],
                size: 22,
              ))
              : Container(),
        ),
        SizedBox(
          width: 8,
        ),
        Expanded(
          flex: 1,
          child: lat != '-' && lat != null
              ? GestureDetector(
              onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
                  NavigateToDetailMap(
                      context,
                      ModelDetailMap("Lokasi Absen $title",
                          double.parse(lat!), double.parse(long!)))),
              child: Icon(
                Icons.pin_drop_rounded,
                color: Colors.redAccent,
                size: 21,
              ))
              : Container(),
        ),
      ],
    );
  }
}

class VDivider extends StatelessWidget {
  const VDivider({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 60,
      margin: EdgeInsets.symmetric(horizontal: 12),
      decoration: BoxDecoration(
        border: Border(
          right: BorderSide(
            color: Theme.of(context).dividerColor,
            width: 2,
          ),
        ),
      ),
    );
  }
}
