import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mListKpiTeam.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class CardListKpiPlanning extends StatefulWidget {
  DataKpiTeam data;
  String jenis;

  CardListKpiPlanning(this.data, this.jenis);

  @override
  State<CardListKpiPlanning> createState() => _CardListKpiPlanningState();
}

class _CardListKpiPlanningState extends State<CardListKpiPlanning> {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
        onTap: () {
          print(widget.jenis);
          if (widget.jenis == 'planning') {
            BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToHalamanPengajuanKpiSaya(context, [
              widget.data.idKaryawan,
              widget.data.idCompany,
              widget.data.bulan,
              widget.data.tahun,
              widget.data.namaLengkap
            ]));
          } else if (widget.jenis == 'pengajuan') {
            BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToHalamanDetailPengajuanKpiSaya(context, [
              widget.data.idKaryawan,
              widget.data.idCompany,
              widget.data.bulan,
              widget.data.tahun,
              widget.data.namaLengkap
            ]));
          } else if (widget.jenis == 'approval') {
            BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToHalamanDetailApprovalKpiSaya(context, [
              widget.data.idKaryawan,
              widget.data.idCompany,
              widget.data.bulan,
              widget.data.tahun,
              widget.data.namaLengkap
            ]));
          } else if (widget.jenis == 'diterima') {
            BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToHalamanDetailDiterimaKpiSaya(context, [
              widget.data.idKaryawan,
              widget.data.idCompany,
              widget.data.bulan,
              widget.data.tahun,
              widget.data.namaLengkap
            ]));
          }
        },
        child: Container(
          decoration: BoxDecoration(
              // color: Color(int.parse(widget.dataLembur.warna!)),
              color: Colors.blue,
              borderRadius:
                  BorderRadius.all(Radius.circular(CustomStyle.cardRadius))),
          margin: EdgeInsets.only(top: 12, left: 12, right: 12),
          padding: EdgeInsets.only(left: 5),
          child: Column(
            children: [
              Container(
                decoration: CustomStyle.boxDecoration2,
                child: Column(
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        const SizedBox(
                          width: 12,
                        ),
                        Expanded(
                          flex: 2,
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              Text(widget.data.tahun.toString(),
                                  style: TextStyle(
                                      fontSize: 14,
                                      color: CustomStyle.fontColorGrey,
                                      fontWeight: FontWeight.w400)),
                              SizedBox(
                                height: 6,
                              ),
                              Text(
                                '${getMonthNames(widget.data.bulan!)}',
                                style: TextStyle(
                                    fontSize: 16, fontWeight: FontWeight.w600),
                              ),
                            ],
                          ),
                        ),
                        VDivider(),
                        Expanded(
                          flex: 8,
                          child: Container(
                            width: MediaQuery.of(context).size.width,
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Expanded(
                                    child: Container(
                                  child:
                                      Text(widget.data.namaLengkap.toString()),
                                )),
                              ],
                            ),
                          ),
                        ),
                        Container(
                          decoration: BoxDecoration(
                            color: Color(int.parse(widget.data.jenisColor!))
                                .withOpacity(0.2),
                            borderRadius: BorderRadius.all(
                                Radius.circular(CustomStyle.cardRadius)),
                          ),
                          margin: EdgeInsets.all(10),
                          padding: EdgeInsets.all(
                              5), // Ganti padding menjadi all untuk menjaga keseimbangan
                          child: Center(
                            // Center sudah benar
                            child: Text(
                              widget.data.jenis.toString(),
                              textAlign: TextAlign
                                  .center, // Tambahkan ini untuk memastikan teks di pusat
                              style: TextStyle(
                                color:
                                    Color(int.parse(widget.data.jenisColor!)),
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
              ),
            ],
          ),
        ));
  }
}

class VDivider extends StatelessWidget {
  const VDivider({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 60,
      margin: EdgeInsets.symmetric(horizontal: 12),
      decoration: BoxDecoration(
        border: Border(
          right: BorderSide(
            color: Theme.of(context).dividerColor,
            width: 2,
          ),
        ),
      ),
    );
  }
}

String getMonthName(int monthNumber) {
  const List<String> monthNames = [
    'Januari',
    'Februari',
    'Maret',
    'April',
    'Mei',
    'Juni',
    'Juli',
    'Agustus',
    'September',
    'Oktober',
    'November',
    'Desember'
  ];

  if (monthNumber < 1 || monthNumber > 12) {
    return 'Bulan tidak valid';
  }

  return monthNames[monthNumber - 1];
}

String getMonthNames(int monthNumber) {
  const List<String> monthNames = [
    'Jan',
    'Feb',
    'Mar',
    'Apr',
    'May',
    'Jun',
    'Jul',
    'Aug',
    'Sep',
    'Oct',
    'Nov',
    'Dec'
  ];

  if (monthNumber < 1 || monthNumber > 12) {
    return 'Bulan tidak valid';
  }

  return monthNames[monthNumber - 1];
}
