// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/HalamanListApprovalKpiSaya.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/HalamanListDiterimaKpiSaya.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/HalamanListPengajuanKpiSaya.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/HalamanListPlaningKpiSaya.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';

class ParentTabKpiSaya extends StatefulWidget {
  var data;
  ParentTabKpiSaya(this.data);

  @override
  State<ParentTabKpiSaya> createState() => _ParentTabKpiSayaState();
}

class _ParentTabKpiSayaState extends State<ParentTabKpiSaya> {
  @override
  Widget build(BuildContext context) {
    return DefaultTabController(
        length: 4,
        initialIndex: widget.data[0],
        child: Scaffold(
          appBar: AppBar(
            flexibleSpace: Image(
              image: AssetImage(ValueImage.headerBiruDashboard),
              fit: BoxFit.cover,
            ),
            backgroundColor: Colors.transparent,
            centerTitle: true,
            title: Text(
              'KPI',
              style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
            ),
          ),
          body: Padding(
            padding: const EdgeInsets.only(top: 10),
            child: Column(
              children: [
                Material(
                  child: Container(
                    height: 40,
                    child: TabBar(
                      padding: EdgeInsets.symmetric(horizontal: 2),
                        unselectedLabelColor: CustomStyle.color1,
                        labelPadding: EdgeInsets.symmetric(vertical: 0, horizontal: 3),
                        labelColor: Colors.white,
                        indicatorSize: TabBarIndicatorSize.tab,
                        indicator: BoxDecoration(
                          borderRadius: BorderRadius.circular(8),
                          color: CustomStyle.color1,
                        ),
                      tabs: [
                        _buildTab("Aktual"),
                        _buildTab("Pengajuan"),
                        _buildTab("Approve"),
                        _buildTab("Diterima"),
                        // Tab(
                        //   child: Container(
                        //     height: 50,
                        //     padding: EdgeInsets.symmetric(
                        //         horizontal: 10, vertical: 5),
                        //     decoration: BoxDecoration(
                        //         borderRadius: BorderRadius.circular(10),
                        //         border:
                        //             Border.all(color: CustomStyle.color1, width: 1)),
                        //     child: Align(
                        //       alignment: Alignment.center,
                        //       child: Text("Aktual"),
                        //     ),
                        //   ),
                        // ),
                        // Tab(
                        //   child: Container(
                        //     height: 50,
                        //     padding: EdgeInsets.symmetric(
                        //         horizontal: 10, vertical: 5),
                        //     decoration: BoxDecoration(
                        //         borderRadius: BorderRadius.circular(10),
                        //         border:
                        //             Border.all(color: CustomStyle.color1, width: 1)),
                        //     child: Align(
                        //       alignment: Alignment.center,
                        //       child: Text("Pengajuan"),
                        //     ),
                        //   ),
                        // ),
                        // Tab(
                        //   child: Container(
                        //     height: 50,
                        //     padding: EdgeInsets.symmetric(
                        //         horizontal: 10, vertical: 5),
                        //     decoration: BoxDecoration(
                        //         borderRadius: BorderRadius.circular(10),
                        //         border:
                        //             Border.all(color: CustomStyle.color1, width: 1)),
                        //     child: Align(
                        //       alignment: Alignment.center,
                        //       child: Text("Approve"),
                        //     ),
                        //   ),
                        // ),
                        // Tab(
                        //   child: Container(
                        //     padding: EdgeInsets.symmetric(
                        //         horizontal: 10, vertical: 5),
                        //     height: 50,
                        //     decoration: BoxDecoration(
                        //         borderRadius: BorderRadius.circular(10),
                        //         border:
                        //             Border.all(color: CustomStyle.color1, width: 1)),
                        //     child: Align(
                        //       alignment: Alignment.center,
                        //       child: Text("Diterima"),
                        //     ),
                        //   ),
                        // )
                      
                      ],
                    ),
                  ),
                ),
                Expanded(
                  child: TabBarView(
                    children: [
                      HalamanListPlaningKpiSaya(),
                      HalamanListPengajuanKpiSaya(),
                      HalamanListApprovalKpiSaya(),
                      HalamanListDiterimaKpiSaya(),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ));
  }
    Widget _buildTab(String label) {
    return Container(
      height: 35,
      padding: EdgeInsets.symmetric(horizontal: 8, vertical: 3),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        border: Border.all(color: CustomStyle.color1, width: 0.8),
      ),
      child: Align(
        alignment: Alignment.center,
        child: Text(
          label,
          style: TextStyle(
            fontSize: MediaQuery.of(context).size.width > 600 ? 14 : 12,
          ),
        ),
      ),
    );
  }

}
