import 'package:absenkuv3/Bloc/Kpi/KpiSaya/SimpanDraftPengajuanKpiSayaBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiApproval/mDataAspekKepribadian.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class KomponenFinalAspekKepribadian extends StatefulWidget {
  List<DataAspekKepribadian> data;
  ParsingModelKaryawan parsingKaryawan;
  KomponenFinalAspekKepribadian(this.data, this.parsingKaryawan);

  @override
  State<KomponenFinalAspekKepribadian> createState() =>
      _KomponenFinalAspekKepribadianState();
}

class _KomponenFinalAspekKepribadianState
    extends State<KomponenFinalAspekKepribadian> {
  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        SingleChildScrollView(
          child: Column(
            children: [
              ListView.builder(
                  shrinkWrap: true,
                  physics: NeverScrollableScrollPhysics(),
                  itemCount: widget.data.length,
                  itemBuilder: (context, index) {
                    var item = widget.data[index];
                    return Container(
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15),
                          // color: Color(0xffF2f2f7),
                          border:
                              Border.all(color: Color(0xffF2f2f7), width: 2.0)),
                      margin:
                          EdgeInsets.symmetric(vertical: 10, horizontal: 15),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Container(
                            padding: EdgeInsets.all(11),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(item.personalAspek.toString(),
                                    style: TextStyle(
                                        fontWeight: FontWeight.bold,
                                        fontSize: 18)),
                                Row(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Expanded(
                                        child: Text(item.keterangan.toString(),
                                            textAlign: TextAlign.justify,
                                            style:
                                                TextStyle(color: Colors.grey))),
                                    Container(
                                      decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(10),
                                        color: Colors.amber,
                                      ),
                                      margin: EdgeInsets.only(left: 5),
                                      padding: EdgeInsets.symmetric(
                                          horizontal: 10, vertical: 10),
                                      child: Column(
                                        children: [
                                          Text("Bobot"),
                                          Text(
                                            '${item.bobot.toString()}%',
                                            style: TextStyle(
                                                fontWeight: FontWeight.bold,
                                                fontSize: 18),
                                          ),
                                        ],
                                      ),
                                    )
                                  ],
                                )
                              ],
                            ),
                          ),
                          Column(
                            children: [
                              SizedBox(
                                height: 11,
                              ),
                              CustomTextContainer(
                                text: item.poin1.toString(),
                                no: '1',
                              ),
                              CustomTextContainer(
                                text: item.poin2.toString(),
                                no: '2',
                              ),
                              CustomTextContainer(
                                text: item.poin3.toString(),
                                no: '3',
                              ),
                              CustomTextContainer(
                                text: item.poin4.toString(),
                                no: '4',
                              ),
                              CustomTextContainer(
                                text: item.poin5.toString(),
                                no: '5',
                              ),
                            ],
                          ),
                          Container(
                            height: 10,
                            color: Colors.blue.shade50,
                            width: MediaQuery.of(context).size.width,
                          ),
                          Container(
                            // padding: EdgeInsets.only(left: 11, right: 11),
                            padding: EdgeInsets.only(bottom: 11, top: 11),
                            color: Colors.blue.shade50,
                            width: MediaQuery.of(context).size.width,
                            child: Center(
                              child: Text("ACTUAL",
                                  style: TextStyle(
                                      fontSize: 15,
                                      fontWeight: FontWeight.w500)),
                            ),
                          ),
                          Container(
                            // padding: EdgeInsets.only(left: 11, right: 11),
                            padding: EdgeInsets.only(bottom: 11),
                            color: Colors.blue.shade50,
                            width: MediaQuery.of(context).size.width,
                            child: Center(
                              child: Text(item.actualPoinApproval.toString(),
                                  style: TextStyle(
                                      fontSize: 15,
                                      fontWeight: FontWeight.w500)),
                            ),
                          ),
                          Container(
                            width: MediaQuery.of(context).size.width,
                            height: 10,
                            decoration: BoxDecoration(
                                color: Colors.blue.shade50,
                                borderRadius: BorderRadius.only(
                                    bottomLeft: Radius.circular(20),
                                    bottomRight: Radius.circular(20))),
                          )
                        ],
                      ),
                    );
                  }),
            ],
          ),
        ),
      ],
    );
  }
}

class CustomTextContainer extends StatelessWidget {
  final String text;
  final String no;

  const CustomTextContainer({Key? key, required this.text, required this.no})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      color: Colors.blue.shade50,
      child: Container(
        padding: EdgeInsets.only(top: 11, right: 11, left: 11),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              // crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text('${no}'),
                SizedBox(
                  width: 10,
                ),
                Expanded(
                  child: RichText(
                      textAlign: TextAlign.justify,
                      text: TextSpan(children: [
                        TextSpan(
                            text: text, style: TextStyle(color: Colors.black))
                      ])),
                ),
              ],
            ),
            Container(
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(20),
                color: Colors.white,
              ),
              margin: EdgeInsets.only(top: 11),
              height: 1,
            ),
          ],
        ),
      ),
    );
  }
}
