import 'package:absenkuv3/Bloc/Kpi/KpiSaya/SimpanDraftPengajuanKpiSayaBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiApproval/mDataAspekKepribadian.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class KomponenPengajuanAspekKepribadian extends StatefulWidget {
  List<DataAspekKepribadian> data;
  ParsingModelKaryawan parsingKaryawan;
  KomponenPengajuanAspekKepribadian(this.data, this.parsingKaryawan);

  @override
  State<KomponenPengajuanAspekKepribadian> createState() =>
      _KomponenPengajuanAspekKepribadianState();
}

class _KomponenPengajuanAspekKepribadianState
    extends State<KomponenPengajuanAspekKepribadian> {
  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        SingleChildScrollView(
          child: Column(
            children: [
              ListView.builder(
                  shrinkWrap: true,
                  physics: NeverScrollableScrollPhysics(),
                  itemCount: widget.data.length,
                  itemBuilder: (context, index) {
                    var item = widget.data[index];
                    return Container(
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15),
                          // color: Color(0xffF2f2f7),
                          border:
                              Border.all(color: Color(0xffF2f2f7), width: 2.0)),
                      margin:
                          EdgeInsets.symmetric(vertical: 10, horizontal: 15),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Container(
                            padding: EdgeInsets.all(11),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(item.personalAspek.toString(),
                                    style: TextStyle(
                                        fontWeight: FontWeight.bold,
                                        fontSize: 18)),
                                Row(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Expanded(
                                        child: Text(item.keterangan.toString(),
                                            textAlign: TextAlign.justify,
                                            style:
                                                TextStyle(color: Colors.grey))),
                                    Container(
                                      decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(10),
                                        color: Colors.amber,
                                      ),
                                      margin: EdgeInsets.only(left: 5),
                                      padding: EdgeInsets.symmetric(
                                          horizontal: 10, vertical: 10),
                                      child: Column(
                                        children: [
                                          Text("Bobot"),
                                          Text(
                                            '${item.bobot.toString()}%',
                                            style: TextStyle(
                                                fontWeight: FontWeight.bold,
                                                fontSize: 18),
                                          ),
                                        ],
                                      ),
                                    )
                                  ],
                                )
                              ],
                            ),
                          ),
                          Column(
                            children: [
                              SizedBox(
                                height: 11,
                              ),
                              CustomTextContainer(
                                text: item.poin1.toString(),
                                no: '1',
                              ),
                              CustomTextContainer(
                                text: item.poin2.toString(),
                                no: '2',
                              ),
                              CustomTextContainer(
                                text: item.poin3.toString(),
                                no: '3',
                              ),
                              CustomTextContainer(
                                text: item.poin4.toString(),
                                no: '4',
                              ),
                              CustomTextContainer(
                                text: item.poin5.toString(),
                                no: '5',
                              ),
                            ],
                          ),
                          Container(
                            height: 10,
                            color: Colors.blue.shade50,
                            width: MediaQuery.of(context).size.width,
                          ),
                          Container(
                            // padding: EdgeInsets.only(left: 11, right: 11),
                            padding: EdgeInsets.only(bottom: 11, top: 11),
                            color: Colors.blue.shade50,
                            width: MediaQuery.of(context).size.width,
                            child: Center(
                              child: Text("AKTUAL",
                                  style: TextStyle(
                                      fontSize: 15,
                                      fontWeight: FontWeight.w500)),
                            ),
                          ),
                          Container(
                            color: Colors.blue.shade50,
                            child: Container(
                              decoration: BoxDecoration(
                                borderRadius:
                                    BorderRadius.all(Radius.circular(10)),
                                color: Colors.white,
                              ),
                              margin: EdgeInsets.only(left: 11, right: 11),
                              child: Center(
                                child: Wrap(
                                  spacing: 8.0,
                                  children: List<Widget>.generate(5, (i) {
                                    int radioValue = i + 1;
                                    return Row(
                                      mainAxisSize: MainAxisSize.min,
                                      children: [
                                        Radio<int>(
                                          value: radioValue,
                                          groupValue:
                                              item.actualPoinApproval == 0
                                                  ? null
                                                  : item.actualPoinApproval,
                                          onChanged: (value) {
                                            setState(() {
                                              item.actualPoinApproval = value!;
                                            });
                                          },
                                        ),
                                        Text(radioValue.toString()),
                                      ],
                                    );
                                  }),
                                ),
                              ),
                            ),
                          ),
                          Container(
                            width: MediaQuery.of(context).size.width,
                            height: 10,
                            decoration: BoxDecoration(
                                color: Colors.blue.shade50,
                                borderRadius: BorderRadius.only(
                                    bottomLeft: Radius.circular(20),
                                    bottomRight: Radius.circular(20))),
                          )
                        ],
                      ),
                    );
                  }),
              Container(
                width: MediaQuery.of(context).size.width,
                margin: EdgeInsets.symmetric(vertical: 5, horizontal: 5),
                child: ElevatedButton(
                  style: ElevatedButton.styleFrom(
                    backgroundColor: CustomStyle.color1,
                    foregroundColor: Colors.white,
                    shape: RoundedRectangleBorder(
                      borderRadius: BorderRadius.circular(
                          20), // Adjust this value to change the roundness
                    ),
                  ),
                  onPressed: () {
                    List<Map<String, dynamic>> newData = [];
                    int index = 0;
                    for (var obj in widget.data) {
                      newData.add({
                        "id_karyawan": obj.idKaryawan,
                        "id_company": obj.idCompany,
                        "tahun": obj.tahun,
                        "bulan": obj.bulan,
                        "id_aspek_kepribadian": obj.idAspekKepribadian,
                        "id_aspek_kepribadian_m": obj.idAspekKepribadianM,
                        "personal_aspek": obj.personalAspek,
                        "keterangan": obj.keterangan,
                        "bobot": obj.bobot,
                        "level_user": obj.levelUser,
                        "poin_1": obj.poin1,
                        "poin_2": obj.poin2,
                        "poin_3": obj.poin3,
                        "poin_4": obj.poin4,
                        "poin_5": obj.poin5,
                        "no_urut": obj.noUrut,
                        "actual_poin_approval": obj.actualPoinApproval,
                      });
                      index++;
                    }
                    // print(newData);
                    BlocProvider.of<SimpanDraftPengajuanKpiSayaBloc>(context)
                        .add(SimpanDraftPengajuanAspekKepribadian(
                            newData, widget.parsingKaryawan, context));
                  },
                  child: const Text("Simpan"),
                ),
              ),
            ],
          ),
        ),
      ],
    );
  }
}

class CustomTextContainer extends StatelessWidget {
  final String text;
  final String no;

  const CustomTextContainer({Key? key, required this.text, required this.no})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      color: Colors.blue.shade50,
      child: Container(
        padding: EdgeInsets.only(top: 11, right: 11, left: 11),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              // crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text('${no}'),
                SizedBox(
                  width: 10,
                ),
                Expanded(
                  child: RichText(
                      textAlign: TextAlign.justify,
                      text: TextSpan(children: [
                        TextSpan(
                            text: text, style: TextStyle(color: Colors.black))
                      ])),
                ),
              ],
            ),
            Container(
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(20),
                color: Colors.white,
              ),
              margin: EdgeInsets.only(top: 11),
              height: 1,
            ),
          ],
        ),
      ),
    );
  }
}
