// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiFinal/FinalAspekKedisipinan/FinalAspekKedisiplinan.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiFinal/FinalAspekKepribadian/FinalAspekKepribadian.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiFinal/FinalNilaiIndividu/FinalNilaiIndividu.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiFinal/FinalPerfomanceIndicator/FinalPerfomanceIndicator.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/komponen/Komponenplaning.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanApprovedKpiteam extends StatefulWidget {
  final data;
  HalamanApprovedKpiteam(this.data);

  @override
  State<HalamanApprovedKpiteam> createState() => _HalamanApprovedKpiteamState();
}

class _HalamanApprovedKpiteamState extends State<HalamanApprovedKpiteam> {
  bool refresh = false;
  @override
  void initState() {
    BlocProvider.of<NotifBloc>(context).add(BacaNotifNotifKpi(
      widget.data[0],
      widget.data[1],
      widget.data[2],
      widget.data[3],
      '9',
    ));
    super.initState();
  }

  Future<bool> keluar2() async {
    // Ensure there are sufficient elements
    if (widget.data.length > 5) {
      print("Data at index 5: ${widget.data[5]}");
      if (widget.data[5] == 'notif') {
        Navigator.pop(context, refresh);
      } else {
        BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
      }
    } else {
      BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
    }
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
        onWillPop: keluar2,
        child: BlocListener<NotifBloc, NotifState>(
          listener: (context, stateNotifBloc) {
            if (stateNotifBloc is SuccessBacaNotifState) {
              refresh = true;
            }
          },
          child: DefaultTabController(
            length: 4,
            child: Scaffold(
              appBar: AppBar(
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
                centerTitle: true,
                title: Text(
                  widget.data[5] == '9' ? 'Diterima Team' : 'Approved',
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                ),
              ),
              body: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    padding: EdgeInsets.symmetric(vertical: 15, horizontal: 15),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text("Periode KPI"),
                            SizedBox(
                              height: 3,
                            ),
                            Container(
                              child: Text(
                                "${getMonthName(widget.data[2])} ${widget.data[3]}",
                                style: TextStyle(fontWeight: FontWeight.bold,fontSize: 16),
                              ),
                            ),
                          ],
                        ),
                        SizedBox(
                          height: 10,
                        ),
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text("Nama Karyawan"),
                            SizedBox(
                              height: 3,
                            ),
                            Text(widget.data[4],
                                style: TextStyle(fontWeight: FontWeight.bold,fontSize: 16)),
                          ],
                        )
                      ],
                    ),
                  ),
                  
                  Divider(
                    thickness: 15,
                  ),
                  SizedBox(
                    height: 10,
                  ),
                  Material(
                    child: Container(
                      height: 40,
                      child: TabBar(
                        physics: const ClampingScrollPhysics(),
                        isScrollable: true,
                        padding: EdgeInsets.only(
                            top: 0, left: 5, right: 5, bottom: 0),
                        labelPadding:
                            EdgeInsets.symmetric(vertical: 0, horizontal: 4),
                        unselectedLabelColor: CustomStyle.color1,
                        labelColor: Colors.white,
                        indicatorSize: TabBarIndicatorSize.label,
                        indicator: BoxDecoration(
                            borderRadius: BorderRadius.circular(10),
                            color: CustomStyle.color1),
                        tabs: [
                          Tab(
                            child: Container(
                              height: 50,
                              padding: EdgeInsets.symmetric(
                                  horizontal: 10, vertical: 5),
                              decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(10),
                                  border: Border.all(
                                      color: CustomStyle.color1, width: 1)),
                              child: Align(
                                alignment: Alignment.center,
                                child: Text("Aspek Kinerja"),
                              ),
                            ),
                          ),
                          Tab(
                            child: Container(
                              padding: EdgeInsets.symmetric(
                                  horizontal: 10, vertical: 5),
                              height: 50,
                              decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(10),
                                  border: Border.all(
                                      color: CustomStyle.color1, width: 1)),
                              child: Align(
                                alignment: Alignment.center,
                                child: Text("Kompetensi"),
                              ),
                            ),
                          ),
                          Tab(
                            child: Container(
                              padding: EdgeInsets.symmetric(
                                  horizontal: 10, vertical: 5),
                              height: 50,
                              decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(10),
                                  border: Border.all(
                                      color: CustomStyle.color1, width: 1)),
                              child: Align(
                                alignment: Alignment.center,
                                child: Text("Aspek Kedisiplinan"),
                              ),
                            ),
                          ),
                          Tab(
                            child: Container(
                              padding: EdgeInsets.symmetric(
                                  horizontal: 10, vertical: 5),
                              height: 50,
                              decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(10),
                                  border: Border.all(
                                      color: CustomStyle.color1, width: 1)),
                              child: Align(
                                alignment: Alignment.center,
                                child: Text("Nilai Individu"),
                              ),
                            ),
                          )
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    child: TabBarView(
                      // physics: NeverScrollableScrollPhysics(),
                      children: [
                        FinalPerfomanceIndicator([
                          widget.data![0],
                          widget.data![1],
                          widget.data![2],
                          widget.data![3]
                        ]),
                        FinalAspekKepribadian([
                          widget.data![0],
                          widget.data![1],
                          widget.data![2],
                          widget.data![3]
                        ]),
                        FinalAspekKedisiplinan([
                          widget.data![0],
                          widget.data![1],
                          widget.data![2],
                          widget.data![3]
                        ]),
                        FinalNilaiIndividu([
                          widget.data![0],
                          widget.data![1],
                          widget.data![2],
                          widget.data![3]
                        ]),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          ),
        ));
  }
}
