// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

import 'package:absenkuv3/Bloc/Kpi/Core/GetKomponenAtasanBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/komponen/KomponenKpi.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanKpi extends StatefulWidget {
  const HalamanKpi({Key? key}) : super(key: key);

  @override
  State<HalamanKpi> createState() => _HalamanKpiState();
}

class _HalamanKpiState extends State<HalamanKpi> {
  @override
  void initState() {
    BlocProvider.of<GetKomponenAtasanBloc>(context)
        .add(GetDataKomponenAtasan());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          flexibleSpace: Image(
            image: AssetImage(ValueImage.headerBiruDashboard),
            fit: BoxFit.cover,
          ),
          backgroundColor: Colors.transparent,
          centerTitle: true,
          title: Text(
            'KPI',
            style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
          ),
        ),
        body: BlocBuilder<GetKomponenAtasanBloc, DataKomponenAtasanState>(
          builder: (BuildContext context, DataKomponenAtasanState state) {
            if (state is DataKomponenAtasanSuccess) {
              if (state.respon.data == false) {
                WidgetsBinding.instance.addPostFrameCallback((_) {
                  BlocProvider.of<NavigatorBloc>(context)
                      .add(NavigateToParentTabKpiSaya(context, [0]));
                  Navigator.pop(context);
                });
                return Container();
              } else {
                return Column(
                  children: [
                    SizedBox(
                      height: 10,
                    ),
                      Column(
                          children: [
                            KPIItem(
                              title: 'KPI Saya',
                              subtitle: 'Actual KPI Saya',
                              icon: ValueImage.iconKpiSaya,
                              badge: 0,
                              onTap: () {
                                BlocProvider.of<NavigatorBloc>(context).add(
                                    NavigateToParentTabKpiSaya(context, [0]));
                              },
                            ),
                            KPIItem(
                              title: 'KPI Team',
                              subtitle: 'Planning KPI untuk Team',
                              icon: ValueImage.iconKpiTim,
                              badge: 0,
                              onTap: () {
                                BlocProvider.of<NavigatorBloc>(context)
                                    .add(NavigateToParentTabKpiTeam(context));
                              },
                            ),
                            KPIItem(
                              title: 'Approval KPI Team',
                              subtitle: 'Pengajuan KPI dari Team',
                              icon: ValueImage.iconKpiApprovalTim,
                              badge: 0,
                              onTap: () {
                                BlocProvider.of<NavigatorBloc>(context).add(
                                    NavigateToParentTabKpiApprovalTeam(
                                        context));
                              },
                            )
                          ],
                        )
                  
                  ],
                );
              }
            } else if (state is DataKomponenAtasanProgress) {
              return Container(
                  height: MediaQuery.of(context).size.height,
                  width: MediaQuery.of(context).size.width,
                  child: Center(
                      child: CircularProgressIndicator(
                    strokeWidth: 8,
                  )));
            } else {
              return Container();
            }
          },
        ));
  }

}
