import 'package:absenkuv3/Bloc/FilterHeaderBloc.dart';
import 'package:absenkuv3/Bloc/Izin/IzinPegawaiBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mIzinPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Izin/KomponenIzin.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/UI/templateDateRangePicker.dart';
import 'package:absenkuv3/UI/Template/FilterToggle/UI/templateFilterTogle.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class HalamanListIzinPegawai extends StatefulWidget {
  PageIzinModel? redaksional;
  HalamanListIzinPegawai(this.redaksional);

  @override
  _HalamanListIzinPegawaiState createState() => _HalamanListIzinPegawaiState();
}

class _HalamanListIzinPegawaiState extends State<HalamanListIzinPegawai> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  String? idSelected;
  List<DateTime>? dateRange;
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    // BlocProvider.of<IzinPegawaiBloc>(context)
    //     .add(getListIzinPegawaiEvent(context, null));
    _scrollController.addListener(() =>
        BlocProvider.of<IzinPegawaiBloc>(context)
            .add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          Column(
            children: [
              Container(
                height: 50,
                width: MediaQuery.of(context).size.width * 1.5,
                child: BlocBuilder<FilterHeaderBloc, FilterHeaderState>(
                    builder: (context, state2) {
                  if (state2 is GetSuccessPerColumn) {
                    if (idSelected == null) {
                      idSelected = state2.dataFilter!.data![0].value!;
                      // BlocProvider.of<IzinBloc>(context).add(getListIzinEvent(
                      //     context, ModelFilter(status: idSelected)));
                      BlocProvider.of<IzinPegawaiBloc>(context).add(
                          getListIzinPegawaiEvent(
                              context, ModelFilter(status: idSelected)));
                    }
                    return ListView.builder(
                        itemCount: state2.dataFilter!.data!.length,
                        scrollDirection: Axis.horizontal,
                        itemBuilder: (BuildContext context, index) {
                          return Row(
                            children: [
                              Row(
                                children: [
                                  Stack(
                                    children: [
                                      Row(
                                        children: [
                                          SizedBox(
                                            width: 5,
                                          ),
                                          BlocListener<DateRangePickerBloc,
                                              DateRangePickerState>(
                                            listener: (BuildContext context,
                                                DateRangePickerState
                                                    dateRangePickerState) {
                                              if (dateRangePickerState
                                                  is DateAvailable) {
                                                dateRange =
                                                    dateRangePickerState.date;
                                              }
                                            },
                                            child: ChoiceChip(
                                              padding: EdgeInsets.symmetric(
                                                  horizontal: 5),
                                              shape: RoundedRectangleBorder(
                                                  borderRadius:
                                                      BorderRadius.only(
                                                          topRight:
                                                              Radius.circular(
                                                                  10),
                                                          bottomRight:
                                                              Radius.circular(
                                                                  10),
                                                          topLeft:
                                                              Radius.circular(
                                                                  10),
                                                          bottomLeft:
                                                              Radius.circular(
                                                                  10))),
                                              backgroundColor:
                                                  Colors.grey.shade200,
                                              labelPadding: EdgeInsets.only(
                                                  left: 5, right: 5),
                                              selectedColor: CustomStyle.color1,
                                              selected: idSelected ==
                                                  state2.dataFilter!
                                                      .data![index].value,
                                              label: Text(state2.dataFilter!
                                                      .data![index].nama ??
                                                  ''),
                                              labelStyle: TextStyle(
                                                  color: idSelected ==
                                                          state2
                                                              .dataFilter!
                                                              .data![index]
                                                              .value
                                                      ? Colors.white
                                                      : CustomStyle.color1,
                                                  fontWeight:
                                                      FontWeight.normal),
                                              elevation: 1,
                                              onSelected: (_) {
                                                setState(() {
                                                  idSelected = state2
                                                      .dataFilter!
                                                      .data![index]
                                                      .value!;
                                                  BlocProvider.of<
                                                              IzinPegawaiBloc>(
                                                          context)
                                                      .add(getListIzinPegawaiEvent(
                                                          context,
                                                          ModelFilter(
                                                              status:
                                                                  idSelected,
                                                              dateRange:
                                                                  dateRange)));
                                                });
                                              },
                                            ),
                                          ),
                                        ],
                                      ),
                                    ],
                                  )
                                ],
                              ),
                              SizedBox(
                                width: 3,
                              )
                            ],
                          );
                        });
                  } else
                    return Container();
                }),
              ),
            ],
          ),
          Padding(
            padding: const EdgeInsets.only(top: 55.0),
            child: BlocBuilder<IzinPegawaiBloc, IzinPegawaiState>(
                builder: (BuildContext context, IzinPegawaiState state) {
              if (state is getListIzinKaryawanSuccessState ||
                  state is LoadMoreProgressState)
                return Stack(
                  children: <Widget>[
                    ListView.builder(
                        physics: AlwaysScrollableScrollPhysics(),
                        controller: _scrollController,
                        itemCount: state.data!.length,
                        itemBuilder: (BuildContext context, index) {
                          return CardIzin(
                            state.data![index],
                            'izinPegawai',
                            scaffoldKey,
                            widget.redaksional!,
                            izinPegawai: true,
                          );
                        }),
                    state is LoadMoreProgressState
                        ? Positioned(
                            bottom: 16,
                            child: Container(
                                width: MediaQuery.of(context).size.width,
                                child: Center(
                                    child: CircularProgressIndicator(
                                  strokeWidth: 8,
                                ))))
                        : Container(),
                  ],
                );
              else if (state is IzinPegawaiProgressState)
                return Center(
                  child: CircularProgressIndicator(
                    strokeWidth: 8,
                  ),
                );
              else
                return Center(
                  child: Image.asset(
                    ValueImage.noData,
                    height: 250,
                  ),
                );
            }),
          ),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
              listener: (BuildContext context,
                  DateRangePickerState dateRangePickerState) {
                if (dateRangePickerState is DateAvailable)
                  BlocProvider.of<IzinPegawaiBloc>(context).add(
                      getListIzinPegawaiEvent(context,
                          ModelFilter(dateRange: dateRangePickerState.date,status: idSelected)));
              },
              child: TemplateFilterToggle(),
            ),
          ),
        
        ],
      ),
    );
  }
}
