import 'package:absenkuv3/Bloc/Dropdown/DropdownJenisAktivitasBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

// ignore: must_be_immutable
class DropdownJenisAktivitas extends StatefulWidget {
  String title;
  var color;
  double fontSize;
  String? initialData;
  double? formHeight;
  double marginHorizontal;
  DropdownJenisAktivitas(this.title, {this.initialData, this.color = Colors.grey, this.fontSize = 14, this.formHeight, this.marginHorizontal = 0});

  @override
  _DropdownJenisAktivitasState createState() => _DropdownJenisAktivitasState();
}

class _DropdownJenisAktivitasState extends State<DropdownJenisAktivitas> {
  TextEditingController _controller = TextEditingController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DropdownJenisAktivitasBloc>(context).add(GetDataDropdownJenisAktivitas());
    if(widget.initialData != null){
      _controller.text = widget.initialData!;
    }
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(bottom: 12, top: 0, right: widget.marginHorizontal, left: widget.marginHorizontal),
      child: BlocBuilder<DropdownJenisAktivitasBloc, DropdownJenisAktivitasState>(
        builder: (BuildContext context, DropdownJenisAktivitasState state){
          if(state is DropdownJenisAktivitasSuccessState) return Container(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                SizedBox(height: 7),
                state.selectedValue == null ? Container() :
                Row(
                  children: [
                    Text("Jenis Aktivitas", style: TextStyle(fontSize: 11, color: Colors.grey.shade600)),
                    SizedBox(width: 5),
                    Text("*", style: TextStyle(fontSize: 11, color: Colors.red)),
                  ],
                ),
                DropdownButton(
                  items: state.dropdownRespon.data!.map((item) {
                    return DropdownMenuItem(
                      value: item,
                      child: Container(
                          margin: EdgeInsets.only(bottom: 13),
                          child: Text(item.nama!, style: TextStyle(fontSize: 14),)),
                    );
                  }).toList(), onChanged: (value) {
                  BlocProvider.of<DropdownJenisAktivitasBloc>(context).add(SelectDataDropdownJenisAktivitas(value!));
                },
                  dropdownColor: Colors.white,
                  autofocus: true,
                  focusColor: Colors.white,
                  value: state.selectedValue,
                  style: TextStyle(fontSize: 13, color: Colors.black),
                  hint: Container(
                      margin: EdgeInsets.only(bottom: 21),
                      child: Row(
                        children: [
                          Text(widget.title, style: TextStyle(fontSize: 14),),
                          SizedBox(width: 5),
                          Text("*", style: TextStyle(fontSize: 15, color: Colors.red)),
                        ],
                      )),
                  // isDense: true,
                  isExpanded: true,
                  icon: Container(
                    margin: EdgeInsets.only(bottom: 21, right: 6),
                    child: Icon(Icons.arrow_drop_down_outlined, color: Colors.grey.shade600),
                  ),
                  // dropdownMenuEntries: state.dropdownRespon.data!.map((item) {
                  //   return DropdownMenuEntry(
                  //       value: item,
                  //       label: item.nama!
                  //   );
                  // }).toList(),
                  // inputDecorationTheme: InputDecorationTheme(
                  //   contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                  //   enabledBorder: UnderlineInputBorder(borderSide: BorderSide(color: CustomStyle.colorLineFormDropdown)),
                  // ),
                  // controller: _controller,
                  // onSelected: (value)=>BlocProvider.of<DropdownJenisAktivitasBloc>(context).add(SelectDataDropdownJenisAktivitas(value!)),
                  // label: Row(
                  //   children: [
                  //     Text(widget.title, style: TextStyle( fontSize: widget.fontSize, fontWeight: FontWeight.w400)),
                  //     SizedBox(width: 7),
                  //     Text('*', style: TextStyle(color: Colors.red, fontSize: widget.fontSize)),
                  //   ],
                  // ),
                  // textStyle: TextStyle(fontSize: 13),
                  // requestFocusOnTap: true,
                  // width: MediaQuery.of(context).size.width-50,
                ),
              ],
            ),
          );
          else return Container(
            height: widget.formHeight??CustomStyle.formHeight,
            width: MediaQuery.of(context).size.width,
            child: Shimmer.fromColors(
              baseColor: Colors.grey[200]!,
              highlightColor: Colors.white,
              period: Duration(seconds: 4),
              child: Card(),
            ),
          );
        },
      ),
    );
  }
}
