import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownPendidikanBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

// ignore: must_be_immutable
class DropdownPendidikan extends StatefulWidget {
  String title;
  var color;
  double fontSize;
  String? initialData;
  double? formHeight;
  double marginHorizontal;
  DropdownPendidikan(this.title, {this.initialData, this.color = Colors.grey, this.fontSize = 14, this.formHeight, this.marginHorizontal = 0});

  @override
  _DropdownPendidikanState createState() => _DropdownPendidikanState();
}

class _DropdownPendidikanState extends State<DropdownPendidikan> {
  TextEditingController _controller = TextEditingController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DropdownPendidikanBloc>(context).add(GetDataDropdownPendidikan());
    if(widget.initialData != null){
      _controller.text = widget.initialData!;
    }
  }

  @override
  Widget build(BuildContext context) {
    return

      Container(
      margin: EdgeInsets.only(bottom: 12, top: 11, left: widget.marginHorizontal, right: widget.marginHorizontal),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          BlocBuilder<DropdownPendidikanBloc, DropdownPendidikanState>(
            builder: (BuildContext context, DropdownPendidikanState state){
              if(state is DropdownPendidikanSuccessState) return Container(
                child: DropdownMenu(
                  dropdownMenuEntries: state.dropdownRespon.data!.map((item) {
                    return DropdownMenuEntry(
                      value: item,
                      label: item.nama!
                    );
                  }).toList(),
                  inputDecorationTheme: InputDecorationTheme(
                    contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                    enabledBorder: UnderlineInputBorder(borderSide: BorderSide(color: CustomStyle.colorLineFormDropdown)),
                  ),
                  controller: _controller,
                  onSelected: (value)=>BlocProvider.of<DropdownPendidikanBloc>(context).add(SelectDataDropdownPendidikan(value!)),
                  label: Row(
                    children: [
                      Text(widget.title, style: TextStyle( fontSize: widget.fontSize, fontWeight: FontWeight.w400)),
                      SizedBox(width: 7),
                      Text('*', style: TextStyle(color: Colors.red, fontSize: widget.fontSize)),
                    ],
                  ),
                  textStyle: TextStyle(fontSize: 13),
                  requestFocusOnTap: true,
                  width: MediaQuery.of(context).size.width-50,
                ),
              );
              else return Container(
                height: widget.formHeight??CustomStyle.formHeight,
                width: MediaQuery.of(context).size.width,
                child: Shimmer.fromColors(
                  baseColor: Colors.grey[200]!,
                  highlightColor: Colors.white,
                  period: Duration(seconds: 4),
                  child: Card(),
                ),
              );
            },
          ),
        ],
      ),
    );
  }
}







/*
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownPendidikanBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

// ignore: must_be_immutable
class DropdownPendidikan extends StatefulWidget {
  var color;
  double fontSize;
  String? initialData;
  double? formHeight;
  DropdownPendidikan({this.initialData, this.color = Colors.grey, this.fontSize = 14, this.formHeight});

  @override
  _DropdownPendidikanState createState() => _DropdownPendidikanState();
}

class _DropdownPendidikanState extends State<DropdownPendidikan> {

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DropdownPendidikanBloc>(context).add(GetDataDropdownPendidikan());
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(bottom: 12),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: const EdgeInsets.only(bottom: 8),
            child: Row(
              children: [
                Text(
                  'Pendidikan Terakhir',
                  style: TextStyle(color: widget.color, fontWeight: FontWeight.bold, fontSize: widget.fontSize),
                ),
                SizedBox(width: 7),
                Text(
                  '*',
                  style: TextStyle(color: Colors.red, fontSize: widget.fontSize),
                ),
              ],
            ),
          ),
          BlocBuilder<DropdownPendidikanBloc, DropdownPendidikanState>(
            builder: (BuildContext context, DropdownPendidikanState state){
              if(state is DropdownPendidikanSuccessState) return Container(
                height: widget.formHeight??CustomStyle.formHeight,
                padding: EdgeInsets.only(right: 12),
                decoration: BoxDecoration(
                    border: Border.all(
                        width: 0.8, //
                        color: CustomStyle.fontColorBlack!
                    ),
                    borderRadius: new BorderRadius.all(Radius.circular(6))
                ),
                child: DropdownButton(
                  isExpanded: true,
                  underline: Container(),
                  elevation: 2,
                  style: TextStyle(color: widget.color, fontSize: 13, fontWeight: FontWeight.normal),
                  icon: Icon(Icons.keyboard_arrow_down),
                  hint: Container(
                      padding: EdgeInsets.only(left: 12),
                      child: Text(widget.initialData!=null?widget.initialData!:'Pilih Pendidikan Terakhir', style: TextStyle(color: widget.color, fontWeight: FontWeight.normal),)),
                  value: state.selectedValue,
                  items: state.dropdownRespon.data!.map((item) {
                    return DropdownMenuItem(
                      child: Container(
                          padding: EdgeInsets.only(left: 12),
                          child: Text(item.nama!,)),
                      value: item,
                    );
                  }).toList(),
                  onChanged: (value)=>BlocProvider.of<DropdownPendidikanBloc>(context).add(SelectDataDropdownPendidikan(value!)),
                ),
              );
              else return Container(
                height: widget.formHeight??CustomStyle.formHeight,
                width: MediaQuery.of(context).size.width,
                child: Shimmer.fromColors(
                  baseColor: Colors.grey[200]!,
                  highlightColor: Colors.white,
                  period: Duration(seconds: 4),
                  child: Card(),
                ),
              );
            },
          ),
        ],
      ),
    );
  }
}
*/