import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenisKelaminBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';


// ignore: must_be_immutable
class DropdownJenisKelamin extends StatefulWidget {
  String title;
  var color;
  double fontSize;
  String? initialData;
  double? formHeight;
  double marginHorizontal;
  DropdownJenisKelamin(this.title, {this.initialData, this.color = Colors.grey, this.fontSize = 14, this.formHeight, this.marginHorizontal = 0});

  @override
  _DropdownJenisKelaminState createState() => _DropdownJenisKelaminState();
}

class _DropdownJenisKelaminState extends State<DropdownJenisKelamin> {
  TextEditingController _controller = TextEditingController();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DropdownJenisKelaminBloc>(context).add(GetDataDropdownJenisKelamin());
    if(widget.initialData != null){
      _controller.text = widget.initialData!;
    }
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(bottom: 12, top: 11, left: widget.marginHorizontal, right: widget.marginHorizontal),
      child: BlocBuilder<DropdownJenisKelaminBloc, DropdownJenisKelaminState>(
        builder: (BuildContext context, DropdownJenisKelaminState state){
          if(state is DropdownJenisKelaminSuccessState) return Container(
            child: DropdownMenu(
              dropdownMenuEntries: state.dropdownRespon.data!.map((item) {
                return DropdownMenuEntry(
                    value: item,
                    label: item.nama!
                );
              }).toList(),
              inputDecorationTheme: InputDecorationTheme(
                  contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                enabledBorder: UnderlineInputBorder(borderSide: BorderSide(color: CustomStyle.colorLineFormDropdown)),
              ),
              // initialSelection: widget.initialData,
              controller: _controller,
              onSelected: (value)=>BlocProvider.of<DropdownJenisKelaminBloc>(context).add(SelectDataDropdownJenisKelamin(value!)),
              label: Row(
                children: [
                  Text(widget.title, style: TextStyle( fontSize: widget.fontSize, fontWeight: FontWeight.w400)),
                  SizedBox(width: 7),
                  Text('*', style: TextStyle(color: Colors.red, fontSize: widget.fontSize)),
                ],
              ),
              textStyle: TextStyle(fontSize: 13),
              requestFocusOnTap: true,
              width: MediaQuery.of(context).size.width-50,
            ),
          );
          else return Container(
            height: widget.formHeight??CustomStyle.formHeight,
            width: MediaQuery.of(context).size.width,
            child: Shimmer.fromColors(
              baseColor: Colors.grey[200]!,
              highlightColor: Colors.white,
              period: Duration(seconds: 4),
              child: Card(),
            ),
          );
        },
      ),
    );
  }
}





/*
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenisKelaminBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';


// ignore: must_be_immutable
class DropdownJenisKelamin extends StatefulWidget {
  var color;
  double fontSize;
  String? initialData;
  double? formHeight;
  DropdownJenisKelamin({this.initialData, this.color = Colors.grey, this.fontSize = 14, this.formHeight});

  @override
  _DropdownJenisKelaminState createState() => _DropdownJenisKelaminState();
}

class _DropdownJenisKelaminState extends State<DropdownJenisKelamin> {

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DropdownJenisKelaminBloc>(context).add(GetDataDropdownJenisKelamin());
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(bottom: 12),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: const EdgeInsets.only(bottom: 8),
            child: Row(
              children: [
                Text(
                  'Jenis Kelamin',
                  style: TextStyle(color: widget.color, fontWeight: FontWeight.bold, fontSize: widget.fontSize),
                ),
                SizedBox(width: 7),
                Text(
                  '*',
                  style: TextStyle(color: Colors.red, fontSize: widget.fontSize),
                ),
              ],
            ),
          ),
          BlocBuilder<DropdownJenisKelaminBloc, DropdownJenisKelaminState>(
            builder: (BuildContext context, DropdownJenisKelaminState state){
              if(state is DropdownJenisKelaminSuccessState) return Container(
                height: widget.formHeight??CustomStyle.formHeight,
                padding: EdgeInsets.only(right: 12),
                decoration: BoxDecoration(
                    border: Border.all(
                        width: 0.8,
                        color: CustomStyle.fontColorBlack!
                    ),
                    borderRadius: new BorderRadius.all(Radius.circular(6))
                ),
                child: DropdownButton(
                  isExpanded: true,
                  underline: Container(),
                  elevation: 2,
                  focusColor: Colors.white,
                  style: TextStyle(color: widget.color, fontSize: 13, fontWeight: FontWeight.normal),
                  icon: Icon(Icons.keyboard_arrow_down),
                  hint: Container(
                      padding: EdgeInsets.only(left: 12),
                      child: Text(widget.initialData != null
                                    ? widget.initialData!
                                    : 'Pilih Jenis Kelamin',
                        style: TextStyle(color: widget.color, fontWeight: FontWeight.normal))),
                  value: state.selectedValue,
                  items: state.dropdownRespon.data!.map((item) {
                    return DropdownMenuItem(
                      child: Container(
                          padding: EdgeInsets.only(left: 12),
                          child: Text(item.nama!,)),
                      value: item,
                    );
                  }).toList(),
                  onChanged: (value)=>BlocProvider.of<DropdownJenisKelaminBloc>(context).add(SelectDataDropdownJenisKelamin(value!)),
                ),
              );
              else return Container(
                height: widget.formHeight??CustomStyle.formHeight,
                width: MediaQuery.of(context).size.width,
                child: Shimmer.fromColors(
                  baseColor: Colors.grey[200]!,
                  highlightColor: Colors.white,
                  period: Duration(seconds: 4),
                  child: Card(),
                ),
              );
            },
          ),
        ],
      ),
    );
  }
}
*/