import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:percent_indicator/linear_percent_indicator.dart';
import 'package:shimmer/shimmer.dart';

class templateKehadiran extends StatelessWidget {
  final String title;
  final String value;
  final double percent;
  final Color? color;
  final double? titleFontSize;
  final double? valueFontSize;
  final bool lineIndicator;
  final bool action;
  var onClick;
  bool _isElevated = false;
  templateKehadiran(this.title, this.value, this.percent, this.color,
      {this.titleFontSize,
      this.valueFontSize,
      this.lineIndicator = true,
      this.action = false,
      this.onClick});
  @override
  Widget build(BuildContext context) {
    return 
    Expanded(
        child: GestureDetector(
      onTap: action ? onClick : null,
      child: Container(
        color: Colors.transparent,
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: <Widget>[
                Expanded(
                    child: Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Expanded(
                      child: Text(
                        title,
                        style: TextStyle(
                            fontSize: titleFontSize ?? CustomStyle.fontSizeSmall,
                            fontWeight: FontWeight.bold,
                            color: CustomStyle.fontColorBlack),
                      ),
                    ),
                    action
                        ? Row(
                          mainAxisAlignment: MainAxisAlignment.end,
                          children: [
                            Container(
                              decoration:BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(50),
                                boxShadow:
                                [
                                  BoxShadow(
                                      color: Colors.white,
                                      offset: const Offset(4, 4),
                                      blurRadius: 15,
                                      spreadRadius: 1
                                  ),
                                   BoxShadow(
                                       color: Colors.green.shade200,
                                       offset: Offset(-1, -0),
                                      blurRadius: 0.5,
                                      spreadRadius: 0.5
                                  )
                                ]
                              ),
                              child:
                              Icon(
                                Icons.arrow_circle_right_outlined,
                                color: Colors.green,
                                size: 20.0,
                              ),
                            ),
                            // SizedBox(width: 10),
                          ],
                        )
                        : Container()
                  ],
                )),
              ],
            ),
            SizedBox(
              height: 3,
            ),
            Text(
              value,
              style: TextStyle(
                  fontSize: valueFontSize ?? CustomStyle.fontSizeNormal,
                  color: color),
            ),
            lineIndicator
                ? Column(
                    children: [
                      SizedBox(
                        height: 4,
                      ),
                      LinearPercentIndicator(
                        padding: EdgeInsets.only(left: 3, right: 3),
                        lineHeight: 7,
                        percent: percent,
                        progressColor: color,
                      ),
                    ],
                  )
                : Container()
          ],
        ),
      ),
    ));
  }

}

class templateShimmerDashboard extends StatelessWidget {
  const templateShimmerDashboard({super.key});

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: Container(
        width: MediaQuery.of(context).size.width / 3.7,
        child: Container(
            height: 50,
            width: MediaQuery.of(context).size.width / 3.7,
            child: Container(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    height: 20,
                    width: MediaQuery.of(context).size.width / 10,
                    // width: 40,
                    child: // Shimmer
                        Shimmer.fromColors(
                            baseColor: Colors.grey[300]!,
                            highlightColor: Colors.white,
                            period: Duration(seconds: 2),
                            child: Card()),
                  ),
                  Container(
                    height: 20,
                    width: MediaQuery.of(context).size.width,
                    child: // Shimmer
                        Shimmer.fromColors(
                            baseColor: Colors.grey[300]!,
                            highlightColor: Colors.white,
                            period: Duration(seconds: 2),
                            child: Card()),
                  ),
                ],
              ),
            )),
      ),
    );
  }
}
