import 'package:absenkuv3/Bloc/Cuti/HistoryCutiBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mCutiPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Cuti/komponen/KomponenCuti.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListHistoryCuti extends StatefulWidget {
  var data;
  HalamanListHistoryCuti(this.data);
  @override
  State<HalamanListHistoryCuti> createState() => _HalamanListHistoryCutiState();
}

class _HalamanListHistoryCutiState extends State<HalamanListHistoryCuti> {
  @override
  void initState() {
    super.initState();
    BlocProvider.of<HistoryCutiBloc>(context)
        .add(getListHistoryCutiEvent(context, widget.data[0],widget.data[1],widget.data[2]));
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageCutiModel>(
      future: PengaturanBahasa().cuti(),
      builder: (BuildContext context, snapshot) {
        if (snapshot.connectionState == ConnectionState.done) {
          return Scaffold(
            appBar: AppBar(
              flexibleSpace: Image(
                image: AssetImage(ValueImage.headerBiruDashboard),
                fit: BoxFit.cover,
              ),
              backgroundColor: Colors.transparent,
              centerTitle: true,
              title: Text(widget.data[0]=='kurang'?snapshot.data!.menuCuti!.data!.sudahDigunakan.toString():snapshot.data!.menuCuti!.data!.diTambahkan.toString(),
                style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
              ),
            ),
            body: BlocBuilder<HistoryCutiBloc, HistoryCutiState>(
                builder: (BuildContext context, HistoryCutiState state) {
              if (state is getListHistoryCutiSuccessState) {
                return Stack(
                  children: [
                    CustomScrollView(
                      physics: AlwaysScrollableScrollPhysics(),
                      // controller: _scrollController,
                      slivers: [
                        SliverToBoxAdapter(
                          child: SizedBox(
                              height:
                                  16.0), // Menambahkan SizedBox di atas ListView
                        ),
                        SliverList(
                          delegate: SliverChildBuilderDelegate(
                            (BuildContext context, int index) {
                              return ListHistoryCuti(
                                  state.data![index], widget.data[0]=='kurang'?true:false);
                            },
                            childCount: state.data!.length,
                          ),
                        ),
                      ],
                    ),
                    
                  ],
                );
              } else if (state is HistoryCutiProgressState) {
                return Center(
                  child: CircularProgressIndicator(
                    strokeWidth: 8,
                  ),
                );
              } else {
                return Center(
                  child: Image.asset(
                    ValueImage.noData,
                    height: 250,
                  ),
                );
              }
            }),
          );
        } else {
          return Container();
        }
      },
    );
  }
}
