import 'package:absenkuv3/Bloc/Akun/StatusPengajuanDataBloc.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataPengalamanKerjaPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/PengalamanKerja/HalamanDataPengalamanKerjaPengajuan.dart';
import 'package:absenkuv3/UI/Modul/Akun/PengalamanKerja/HalamanDataPengalamanKerjaTerverifikasi.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class ParentTabDataPengalamanKerja extends StatefulWidget {
  var initialIndex;

  ParentTabDataPengalamanKerja(this.initialIndex);

  @override
  _ParentTabDataPengalamanKerjaState createState() => _ParentTabDataPengalamanKerjaState();
}

class _ParentTabDataPengalamanKerjaState extends State<ParentTabDataPengalamanKerja> {
  int tabLength = 2;
  StatusPengajuanDataRespon? dataStatusPengajuan;

  Future<bool> keluar() async {
    Navigator.pop(context);
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateToRepaceHalamanAkun(context));
    return false;
  }

  @override
  void initState() {
    super.initState();
    BlocProvider.of<StatusPengajuanDataBloc>(context).add(getStatusPengajuanDataEvent(context));
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataPengalamanKerjaModel>(
        future: PengaturanBahasa().dataPengalamanKerja(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<StatusPengajuanDataBloc, StatusPengajuanDataState>(
                builder: (BuildContext context, StatusPengajuanDataState state) {
                  if(state is getStatusPengajuanDataSuccessState){
                    dataStatusPengajuan = state.listStatusPengajuanData;
                    if(dataStatusPengajuan!.statusPengalamanKerja == false){
                      widget.initialIndex = 0;
                    }
                  }
                  return BlocBuilder<AuthBloc, LoginRespon>(
                  builder: (context, stateLogin) {
                    return DefaultTabController(
                      length: tabLength,
                      initialIndex: widget.initialIndex,
                      child: Scaffold(
                        appBar: AppBar(
                          centerTitle: true,
                          iconTheme: IconThemeData(color: CustomStyle.color15),
                          flexibleSpace: Image(
                            image: AssetImage(ValueImage.headerBiruDashboard),
                            fit: BoxFit.cover,
                          ),
                          backgroundColor: Colors.transparent,
                          title: Text(snapshot.data!.menuDataPengalamanKerja!.title!, style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15)),
                          bottom: dataStatusPengajuan == null ? null : dataStatusPengajuan!.statusPengalamanKerja == false ? null : TabBar(
                            labelPadding: EdgeInsets.all(0),
                            indicatorSize: TabBarIndicatorSize.tab,
                            labelColor: CustomStyle.color15,
                            indicatorColor: Colors.white,
                            indicatorWeight: 4,
                            isScrollable: true,
                            tabs: [
                              Container(
                                  width: MediaQuery.of(context).size.width / tabLength,
                                  child: Tab(text: snapshot.data!.menuDataPengalamanKerja!.terverifikasi)),
                              Container(
                                  width: MediaQuery.of(context).size.width / tabLength,
                                  child: Tab(text: snapshot.data!.menuDataPengalamanKerja!.pengajuan)),
                            ],
                          ),
                          actions: stateLogin.dataLogin!.komponenMobile![9] == '0' ? null : [
                            GestureDetector(
                              onTap: () => BlocProvider.of<NavigatorBloc>(context)
                                  .add(NavigateToHalamanAddDataPengalamanKerja(context)),
                              child: Container(
                                  margin: EdgeInsets.only(right: 14),
                                  child: Icon(
                                    Icons.add,
                                    size: 26,
                                  )),
                            ),
                          ],
                        ),
                        body: TabBarView(
                          physics: NeverScrollableScrollPhysics(),
                          children: [
                            HalamanDataPengalamanKerjaTerverifikasi(snapshot.data!),
                            HalamanDataPengalamanKerjaPengajuan(snapshot.data!),
                          ],
                        ),
                      ),
                    );
                  });
                }
            );
          }else{
            return Container();
          }
        }
      ),
    );
  }
}
