import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Bloc/Summary/SummaryBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/UI/Template/FilterBottomKontak/Bloc/FilterBottomKontakKaryawanBloc.dart';
import 'package:absenkuv3/UI/Template/FilterBottomKontak/UI/FilterKontakSheet.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:absenkuv3/Bloc/Akun/KontakSemuaPegawai/KontakPegawaiBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKontakPegawaiPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/KontakSemuaPegawai/KomponenListKontakPegawai/KomponenListKontakPegwai.dart';

class HalamanListKontakPegawai extends StatefulWidget {
  const HalamanListKontakPegawai({Key? key}) : super(key: key);

  @override
  State<HalamanListKontakPegawai> createState() =>
      _HalamanListKontakPegawaiState();
}

class _HalamanListKontakPegawaiState extends State<HalamanListKontakPegawai> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  final TextEditingController _searchController = TextEditingController();
  ScrollController _scrollController = new ScrollController();
  ModelFilter? modelFilterDataAbsensi;

  @override
  void initState() {
    BlocProvider.of<KontakPegawaiBloc>(context).add(getListKontakPegawai(
        context, modelFilterDataAbsensi, 'dataKaryawan', ''));

    _scrollController.addListener(() =>
        BlocProvider.of<KontakPegawaiBloc>(context).add(loadMoreEvent(
            context, scaffoldKey, _scrollController, 'dataKaryawan', '')));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageKontakPegawaiModel>(
      future: PengaturanBahasa().kontakPegawai(),
      builder: (BuildContext context, snapshot) {
        if (snapshot.connectionState == ConnectionState.done) {
          return Scaffold(
              appBar: AppBar(
                title: Text("${snapshot.data!.menuDataKontakPegawai!.title}",style: TextStyle(fontSize: CustomStyle.fontSizeTitle),),
                centerTitle: true,
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                actions: const [],
              ),
              key: scaffoldKey,
              body: Stack(
                children: [
                  CustomScrollView(
                    controller: _scrollController,
                    slivers: [
                      SliverAppBar(
                        floating: true,
                        automaticallyImplyLeading: false,
                        forceMaterialTransparency: true,
                        title: Container(
                            height:50,
                            margin: EdgeInsets.only(top: 10),
                            color: Colors.transparent,
                            child: Column(
                              children: [
                                Row(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Expanded(
                                      child: TextFormField(
                                        controller: _searchController,
                                        decoration: InputDecoration(
                                          contentPadding: EdgeInsets.symmetric(
                                              vertical: 10.0, horizontal: 10.0),
                                          border: OutlineInputBorder(
                                              borderRadius:
                                                  BorderRadius.circular(10),
                                              borderSide: BorderSide(
                                                  color: Colors.red,
                                                  width: 0.5)),
                                          hintText:
                                              '${snapshot.data!.menuDataKontakPegawai!.data!.hint_search}',
                                          fillColor: Colors
                                              .white, // Warna latar belakang
                                          filled: true,
                                          enabledBorder: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(10.0),
                                            borderSide: BorderSide(
                                              color: const Color(0XFFF1F6F9),
                                              width: 2.0,
                                            ),
                                          ),
                                        ),
                                        onEditingComplete: () {
                                          String keyword =
                                              _searchController.text;
                                          BlocProvider.of<KontakPegawaiBloc>(
                                                  context)
                                              .add(getListKontakPegawai(
                                                  context,
                                                  modelFilterDataAbsensi,
                                                  'cari',
                                                  keyword));
                                        },
                                      ),
                                    ),
                                    SizedBox(
                                      width: 10,
                                    ),
                                    GestureDetector(
                                      onTap: () {
                                        String keyword = _searchController.text;
                                        BlocProvider.of<KontakPegawaiBloc>(
                                                context)
                                            .add(getListKontakPegawai(
                                                context,
                                                modelFilterDataAbsensi,
                                                'cari',
                                                keyword));
                                      },
                                      child: Container(
                                        width: 45,
                                        height: 45,
                                        decoration: BoxDecoration(
                                          borderRadius: BorderRadius.circular(
                                              50), // Membuat sudut bulat
                                          color: Colors
                                              .blue, // Warna latar belakang container
                                        ),
                                        child: Center(
                                          child: Icon(Icons.search,
                                              color: Colors.white,
                                              size:
                                                  20), // Icon search di tengah container
                                        ),
                                      ),
                                    )
                                  ],
                                ),
                                Expanded(child: Container(
                                  width: double.infinity,
                                  height: 10,
                                  color: Colors.amber,
                                ))
                              ],
                            )),
                      ),
                      BlocBuilder<KontakPegawaiBloc, KontakPegawaiState>(
                        builder:
                            (BuildContext context, KontakPegawaiState state) {
                          if (state is getListKontakPegawaiState ||
                              state is LoadMoreProgressDataKontakState) {
                            return SliverList.separated(
                              separatorBuilder:
                                  (BuildContext context, int index) => Divider(
                                height: 0.5,
                              ),
                              itemCount: state.data!
                                  .length, // Ganti dengan jumlah item yang sesuai
                              itemBuilder: (BuildContext context, int index) {
                                return ListCard(state.data![index], scaffoldKey,
                                    snapshot.data!.menuDataKontakPegawai);
                              },
                            );
                          } else if (state is KontakPegawaiProgressState) {
                            return SliverFillRemaining(
                              child: Center(
                                child: CircularProgressIndicator(
                                  strokeWidth: 8,
                                ),
                              ),
                            );
                          } else {
                            return SliverFillRemaining(
                              child: Center(
                                child: Image.asset(
                                  ValueImage.noData,
                                  height: 250,
                                ),
                              ),
                            );
                          }
                        },
                      ),
                    ],
                  ),
                  Positioned(
                    bottom: 16,
                    right: 14,
                    child: BlocListener<FilterBottomKontakKaryawanBloc,
                            FilterBottomKontakState>(
                        listener: (BuildContext context,
                            FilterBottomKontakState state) {
                          if (state is setFilterKontakSuccess) {
                            modelFilterDataAbsensi = state.modelFilter;
                            BlocProvider.of<KontakPegawaiBloc>(context).add(
                                getListKontakPegawai(
                                    context,
                                    modelFilterDataAbsensi,
                                    'dataKaryawan',
                                    ''));
                          }
                        },
                        child: FilterKontakSheet(
                            )),
                  )
                ],
              ));
        } else {
          return Container();
        }
      },
    );
  }
}

class SearchHeaderDelegate extends SliverPersistentHeaderDelegate {
  final Widget child;

  SearchHeaderDelegate({required this.child});

  @override
  Widget build(
      BuildContext context, double shrinkOffset, bool overlapsContent) {
    return child;
  }

  @override
  double get maxExtent => 56.0;

  @override
  double get minExtent => 56.0;

  @override
  bool shouldRebuild(SliverPersistentHeaderDelegate oldDelegate) {
    return false;
  }
}
