import 'package:absenkuv3/Bloc/Akun/KelengkapanFile/DataKelengkapanFileBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/KelengkapanFile/mKelengkapanFile.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKelengkapanFilePage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePickerBloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/templateMultiImagePicker.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class HalamanEditDataKelengkapanFile extends StatefulWidget {
  var idKelengkapanFile;
  HalamanEditDataKelengkapanFile(this.idKelengkapanFile);

  @override
  _HalamanEditDataKelengkapanFileState createState() => _HalamanEditDataKelengkapanFileState();
}

class _HalamanEditDataKelengkapanFileState extends State<HalamanEditDataKelengkapanFile> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  String? idKelengkapanFile;
  TextEditingController jurusan = new TextEditingController();
  TextEditingController namaDokumen = new TextEditingController();
  List<MultiImagePickerModel>? listImageFile;


  @override
  void initState() {
    super.initState();
    BlocProvider.of<KelengkapanFileBloc>(context).add(getKelengkapanFilePengajuanByIdEvent(context,widget.idKelengkapanFile, 'data'));
  }

  Future<bool> keluar() async {
    Navigator.pop(context);
    return false;
  }

  void setDataKelengkapanFile(DataDatakelengkapanfile state){
    idKelengkapanFile     = state.idKelengkapanFile!;
    namaDokumen.text      = state.namaDokumen!;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataKelengkapanFileModel>(
        future: PengaturanBahasa().dataKelengkapanFile(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
              key: scaffoldKey,
              appBar: AppBar(centerTitle: true,
                iconTheme: IconThemeData(color: CustomStyle.color15),
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
                title: Text(
                  snapshot.data!.menuDataKelengkapanFile!.editTitle!,
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15),
                ),
              ),
              body: BlocBuilder<KelengkapanFileBloc, KelengkapanFileState>(
                  builder: (BuildContext context, KelengkapanFileState state){
                    if(state is getKelengkapanFileSuccessState) {
                      setDataKelengkapanFile(state.data![0]);
                      return SingleChildScrollView(
                        child: Container(
                          margin: EdgeInsets.all(10),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              TemplateTextFormAkun(
                                adaValidasi: true,
                                controller: namaDokumen,
                                color: Colors.grey[600],
                                fontSize: 13,
                                titleText: snapshot.data!.menuDataKelengkapanFile!.dataKelengkapanFile!.namaDokumen,
                                radius: CustomStyle.formRadius,
                                hintText: snapshot.data!.menuDataKelengkapanFile!.dataKelengkapanFile!.namaDokumen,
                              ),

                              Container(
                                  margin: EdgeInsets.only(bottom: 9),
                                  child: Row(
                                    children: [
                                      Text(snapshot.data!.menuDataKelengkapanFile!.dataKelengkapanFile!.lampiran!,style: TextStyle(color: Colors.grey[600],fontWeight: FontWeight.bold),),
                                      Container(
                                        margin: EdgeInsets.only(left: 5),
                                        child: Text(
                                          '*',
                                          style: TextStyle(color: Colors.red, fontWeight: FontWeight.bold, fontSize: 13),
                                        ),
                                      ),
                                    ],
                                  )),
                              BlocListener<MultiImagePickerBloc, MultiImagePickerState>(
                                listener: (BuildContext context, MultiImagePickerState st) {
                                  if (st is MultiImageSuccessState){
                                    if(st.listData.length == 0) {
                                      if(state.data![0].file != null) state.data![0].file = "";
                                      listImageFile = null;
                                    }else{
                                      listImageFile = st.listData;
                                    }
                                  }
                                },
                                child: TemplateMultiImagePicker(multiImage: false,initialData: state.data![0].file == "" ? null : [state.data![0].file]),
                              ),

                              Container(
                                margin: EdgeInsets.only(top: 15),
                                width: double.infinity,
                                height: 41,
                                child: MaterialButton(onPressed: () {
                                  if(namaDokumen.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKelengkapanFile!.message!.namaDokumenEmpty, context);
                                  else if(listImageFile == null && state.data![0].file == "") showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKelengkapanFile!.message!.lampiranFileEmpty, context);
                                  else
                                    BlocProvider.of<KelengkapanFileBloc>(context).add(
                                        EditKelengkapanFileEvent(
                                            context,
                                            scaffoldKey,
                                            DataDatakelengkapanfile(
                                              idKelengkapanFile: idKelengkapanFile,
                                              namaDokumen: namaDokumen.text,
                                              file: state.data![0].file,
                                            ),
                                            listImageFile
                                        ));
                                },
                                  shape: RoundedRectangleBorder(
                                      borderRadius: BorderRadius.circular(15)
                                  ),
                                  color: CustomStyle.color1,
                                  textColor: Colors.white,
                                  child: Text(snapshot.data!.menuDataKelengkapanFile!.button!.ajukanPerubahanData!),
                                ),
                              )
                            ],
                          ),
                        ),
                      );
                    }
                    else if(state is KelengkapanFileProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                    else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                  }
              ),
            );
          }else{
            return Container();
          }
        }
      ),
    );
  }
}
