import 'package:absenkuv3/Bloc/Akun/DataPendidikan/DataPendidikanBloc.dart';
import 'package:absenkuv3/Bloc/Akun/KelengkapanFile/DataKelengkapanFileBloc.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Repository/Model/Akun/KelengkapanFile/mKelengkapanFile.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKelengkapanFilePage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePickerBloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/templateMultiImagePicker.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class HalamanAddDataKelengkapanFile extends StatefulWidget {
  var idKelengkapanFile;
  HalamanAddDataKelengkapanFile(this.idKelengkapanFile);

  @override
  _HalamanAddDataKelengkapanFileState createState() => _HalamanAddDataKelengkapanFileState();
}

class _HalamanAddDataKelengkapanFileState extends State<HalamanAddDataKelengkapanFile> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  TextEditingController namaDokumen = new TextEditingController();
  List<MultiImagePickerModel>? dokumenFile;


  Future<bool> keluar() async {
    Navigator.pop(context);
    return false;
  }



  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataKelengkapanFileModel>(
        future: PengaturanBahasa().dataKelengkapanFile(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
                key: scaffoldKey,
                appBar: AppBar(centerTitle: true,
                  iconTheme: IconThemeData(color: CustomStyle.color15),
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  title: Text(snapshot.data!.menuDataKelengkapanFile!.addTitle!,
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle, color: CustomStyle.color15),
                  ),
                ),
                body: SingleChildScrollView(
                  child: Container(
                    margin: EdgeInsets.all(10),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        TemplateTextFormAkun(
                          adaValidasi: true,
                          controller: namaDokumen,
                          color: Colors.grey[600],
                          fontSize: 13,
                          titleText: snapshot.data!.menuDataKelengkapanFile!.dataKelengkapanFile!.namaDokumen,
                          radius: CustomStyle.formRadius,
                          hintText: snapshot.data!.menuDataKelengkapanFile!.dataKelengkapanFile!.namaDokumen,
                        ),
                        Container(
                            margin: EdgeInsets.only(bottom: 9),
                            child: Row(
                              children: [
                                Text(snapshot.data!.menuDataKelengkapanFile!.dataKelengkapanFile!.lampiran!,style: TextStyle(color: Colors.grey[600],fontWeight: FontWeight.bold),),
                                Container(
                                  margin: EdgeInsets.only(left: 5),
                                  child: Text(
                                    '*',
                                    style: TextStyle(color: Colors.red, fontWeight: FontWeight.bold, fontSize: 13),
                                  ),
                                ),
                              ],
                            )),
                        BlocListener<MultiImagePickerBloc, MultiImagePickerState>(
                          listener: (BuildContext context, MultiImagePickerState state) {
                            if (state is MultiImageSuccessState)
                              dokumenFile = state.listData;
                          },
                          child: TemplateMultiImagePicker(multiImage: false),
                        ),
                        Container(
                          margin: EdgeInsets.only(top: 15),
                          width: double.infinity,
                          height: 41,
                          child: MaterialButton(onPressed: () {
                            if(namaDokumen.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKelengkapanFile!.message!.namaDokumenEmpty, context);
                            else if(dokumenFile == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKelengkapanFile!.message!.lampiranFileEmpty, context);
                            else
                              BlocProvider.of<KelengkapanFileBloc>(context).add(
                                  PengajuanTambahKelengkapanFileEvent(
                                      context,
                                      scaffoldKey,
                                      DataDatakelengkapanfile(namaDokumen: namaDokumen.text),
                                      dokumenFile
                                  ));
                          },
                            shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(15)
                            ),
                            color: CustomStyle.color1,
                            textColor: Colors.white,
                            child: Text(snapshot.data!.menuDataKelengkapanFile!.button!.ajukanData!),
                          ),
                        )
                      ],
                    ),
                  ),
                )
            );
          }else{
            return Container();
          }
        }
      )
    );
  }
}
