import 'package:aad_oauth/aad_oauth.dart';
import 'package:absenkuv3/Bloc/Akun/NotifikasiAkunBloc.dart';
import 'package:absenkuv3/Bloc/Akun/StatusPengajuanDataBloc.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/CustomBloc.dart';
import 'package:absenkuv3/Bloc/LoadingBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Page/PageAkunBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAkunPage.dart';
import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/Service/userApi.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/oauth_config.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePickerBloc.dart';
import 'package:absenkuv3/UI/Template/dialog/dialogConfirmation.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateButtonAkun.dart';
import 'package:absenkuv3/UI/Template/templateForm.dart';
import 'package:absenkuv3/UI/Template/templateIconInformation.dart';
import 'package:absenkuv3/UI/Template/verticalDivider.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/progress_dialog.dart';

class HalamanAkun extends StatefulWidget {
  @override
  _HalamanAkunState createState() => _HalamanAkunState();
}

class _HalamanAkunState extends State<HalamanAkun> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  StatusPengajuanDataRespon? dataStatusPengajuan;
  JumlahBadge? jumlahBadge;
  late AadOAuth oauth;

  @override
  void initState() {
    super.initState();
    oauth = OAuthService.oauth;
    BlocProvider.of<StatusPengajuanDataBloc>(context)
        .add(getStatusPengajuanDataEvent(context));
    BlocProvider.of<NotifikasiAkunBloc>(context)
        .add(getBadgeAkunEvent(context));
    BlocProvider.of<PageAkunBloc>(context).add(GetDataPageAkun(context));
  }

  Future<bool> keluar() async {
    Navigator.pop(context);
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateRemoveToDashboard(context));
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: BlocBuilder<PageAkunBloc, PageAkunState>(
          builder: (context, languageState) {
        if (languageState is PageAkunGetSuccess) {
          return Scaffold(
            key: scaffoldKey,
            backgroundColor: CustomStyle.backgroundColor,
            appBar: AppBar(
              centerTitle: true,
              title: Text(
                languageState.pageAkunModel!.menuAkun!.title!,
                style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
              ),
              flexibleSpace: Image(
                image: AssetImage(ValueImage.headerBiruDashboard),
                fit: BoxFit.cover,
              ),
              forceMaterialTransparency: true,
              backgroundColor: Colors.transparent,
            ),
            body: Stack(
              children: <Widget>[
                Column(
                  children: <Widget>[
                    Container(
                      width: double.infinity,
                      height: MediaQuery.of(context).size.height / 3,
                      child: Image.asset(
                        ValueImage.headerBiruDashboard,
                        fit: BoxFit.fitWidth,
                      ),
                    ),
                    Expanded(
                      child: Container(
                        height: MediaQuery.of(context).size.height / 3,
                        color: CustomStyle.backgroundDashboardColor,
                        // color: Colors.orange,
                      ),
                    ),
                  ],
                ),
                BlocBuilder<AuthBloc, LoginRespon>(
                    builder: (BuildContext context, LoginRespon loginRespon) {
                  if (loginRespon != false) {
                    return SafeArea(
                      child: SingleChildScrollView(
                        child: Padding(
                          padding: const EdgeInsets.fromLTRB(12, 20, 12, 16),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: <Widget>[
                              // SizedBox(
                              //   height: 80,
                              // ),
                              cardNama(
                                  loginRespon.dataLogin,
                                  languageState
                                      .pageAkunModel!.menuAkun!.jabatan!,
                                  languageState
                                      .pageAkunModel!.menuAkun!.departemen!),
                              SizedBox(
                                height: 28,
                              ),
                              cardInfoDetail(loginRespon.dataLogin!,
                                  languageState.pageAkunModel!.menuAkun!),
                              SizedBox(
                                height: 28,
                              ),
                              loginRespon.dataLogin!.komponenMobile != null &&
                                      loginRespon.dataLogin!.komponenMobile!
                                              .length >
                                          13
                                  ? loginRespon
                                              .dataLogin!.komponenMobile![13] ==
                                          '1'
                                      ? TemplateButtonAkun(
                                          icon: Image.asset(
                                            ValueImage.iconPkwt,
                                            height: 30,
                                          ),
                                          title: 'PKWT',
                                          onClick: () => BlocProvider.of<
                                                  NavigatorBloc>(context)
                                              .add(NavigateToPkwtSaya(context)))
                                      : Container()
                                  : Container(),

                              SizedBox(
                                height: 5,
                              ),
                              TemplateButtonAkun(
                                  icon: Image.asset(
                                    ValueImage.iconKontakV2,
                                    height: 30,
                                  ),
                                  title: languageState.pageAkunModel!.menuAkun!
                                      .kontakSemuaPegawai!,
                                  onClick: () => BlocProvider.of<NavigatorBloc>(
                                          context)
                                      .add(NavigateToHalamanListKontakPegawai(
                                          context))),
                              SizedBox(
                                height: 5,
                              ),
                              TemplateButtonAkun(
                                icon: Image.asset(ValueImage.iconBahasa,
                                    height: 30),
                                title: languageState
                                    .pageAkunModel!.menuAkun!.bahasa!,
                                onClick: () => _settingModalBottomSheet(
                                    loginRespon.dataLogin!,
                                    languageState.pageAkunModel!.menuAkun!),
                              ),
                              SizedBox(
                                height: 5,
                              ),
                              TemplateButtonAkun(
                                icon: Icon(Icons.lock_outline),
                                title: languageState
                                    .pageAkunModel!.menuAkun!.gantiPassword!,
                                onClick: () =>
                                    BlocProvider.of<NavigatorBloc>(context)
                                        .add(NavigateToUbahPassword(context)),
                              ),
                              SizedBox(
                                height: 5,
                              ),
                              TemplateButtonAkun(
                                icon: Icon(Icons.subdirectory_arrow_left),
                                title: languageState
                                    .pageAkunModel!.menuAkun!.logout!,
                                onClick: () {
                                  showDialog(
                                    barrierDismissible: false,
                                    context: context,
                                    builder: (BuildContext contextAlert) =>
                                        AlertConfirmation(
                                            message: languageState
                                                .pageAkunModel!
                                                .menuAkun!
                                                .messageExit!,
                                            textBtnSubmit: languageState
                                                .pageAkunModel!
                                                .menuAkun!
                                                .btnYa!,
                                            textBtnCancel: languageState
                                                .pageAkunModel!
                                                .menuAkun!
                                                .btnNo!,
                                            onClick: () async {

                                              Navigator.of(contextAlert).pop();
                                              await oauth.logout();
                                              BlocProvider.of<AuthBloc>(context)
                                                  .add(LogoutEvent(
                                                      context, scaffoldKey));
                                            }),
                                  );
                                },
                              ),
                              SizedBox(
                                height: 24,
                              ),
                              Text(
                                "${languageState.pageAkunModel!.menuAkun!.versi} : ${ServerInfo.versionName}",
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeSmall,
                                    color: CustomStyle.fontColorGrey),
                              ),
                            ],
                          ),
                        ),
                      ),
                    );
                  } else
                    return Container(
                      height: MediaQuery.of(context).size.height,
                      child: Center(
                        child: CircularProgressIndicator(
                          strokeWidth: 8,
                        ),
                      ),
                    );
                }),
              ],
            ),
          );
        } else {
          return Container();
        }
      }),
    );
  }

  Widget cardNama(
      DataLogin? dataLogin, String titleJabatan, String titleDepartemen) {
    return Container(
        width: MediaQuery.of(context).size.width,
        padding: EdgeInsets.fromLTRB(12, 16, 12, 8),
        decoration: CustomStyle.boxDecoration,
        child: Column(
          children: <Widget>[
            Row(
              children: <Widget>[
                BlocListener<MultiImagePickerBloc, MultiImagePickerState>(
                  listener:
                      (BuildContext context, MultiImagePickerState state) {
                    if (state is MultiImageSuccessState)
                      BlocProvider.of<AuthBloc>(context).add(
                          UploadFotoProfilEvent(
                              state.listData[0].base64, context, scaffoldKey));
                  },
                  child: GestureDetector(
                    onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
                        NavigateToDetailImageClickedAkun(
                            context, dataLogin!.foto)),
                    child: Container(
                      decoration: new BoxDecoration(
                          color: Colors.grey[100],
                          borderRadius:
                              new BorderRadius.all(Radius.circular(120.0))),
                      child: ClipRRect(
                          borderRadius: BorderRadius.circular(120.0),
                          child: dataLogin!.foto != '-'
                              ? Image.network(
                                  dataLogin!.foto!,
                                  height: 64,
                                  width: 64,
                                  fit: BoxFit.cover,
                                  errorBuilder: (c, obj, st) {
                                    return Padding(
                                      padding: const EdgeInsets.all(8.0),
                                      child: Icon(
                                        Icons.person,
                                        color: Colors.grey[400],
                                        size: 48,
                                      ),
                                    );
                                  },
                                )
                              : Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Icon(
                                    Icons.person,
                                    color: Colors.grey[400],
                                    size: 48,
                                  ),
                                )),
                    ),
                  ),
                ),
                SizedBox(
                  width: 12,
                ),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Text(
                        dataLogin.namaUser!,
                        style: TextStyle(
                            fontSize: CustomStyle.fontSizeSubTitle,
                            fontWeight: FontWeight.bold,
                            color: CustomStyle.fontColorBlack),
                      ),
                      SizedBox(
                        height: 2,
                      ),
                      Text(
                        dataLogin.nik!,
                        style: TextStyle(
                            fontSize: CustomStyle.fontSizeNormal,
                            fontWeight: FontWeight.normal,
                            color: CustomStyle.fontColorBlack),
                      ),
                    ],
                  ),
                ),
                BlocBuilder<NotifikasiAkunBloc, NotifikasiAkunState>(
                    builder: (BuildContext context, NotifikasiAkunState state) {
                  if (state is getBadgeAkunSuccessState) {
                    jumlahBadge = state.dataBadge;
                  }
                  return GestureDetector(
                      onTap: () => BlocProvider.of<NavigatorBloc>(context)
                          .add(NavigateToHalamanNotifikasiAkun(context)),
                      child: jumlahBadge == null
                          ? Image.asset('images/akun/log_icon.png',
                              height: 25, width: 25)
                          : jumlahBadge!.data == 0
                              ? Image.asset('images/akun/log_icon.png',
                                  height: 25, width: 25)
                              : Badge(
                                  label: Text(jumlahBadge!.data.toString()),
                                  offset: Offset(11.0, -7.0),
                                  child: Image.asset('images/akun/log_icon.png',
                                      height: 25, width: 25)));
                }),
                SizedBox(width: 15),
              ],
            ),
            SizedBox(
              height: 4,
            ),
            Divider(
              thickness: 1,
            ),
            SizedBox(
              height: 8,
            ),
            Row(
              children: [
                Expanded(
                  child: IconInformation(
                    icon: ValueImage.iconJabatan,
                    title: titleJabatan,
                    subtitle: dataLogin.namaJabatan,
                    sizeIcon: 25,
                  ),
                ),
                VerticalDividerAbsenku(),
                Expanded(
                  child: IconInformation(
                    icon: ValueImage.iconDepartement,
                    title: titleDepartemen,
                    subtitle: dataLogin.namaDepartemen ?? '-',
                    sizeIcon: 25,
                  ),
                ),
              ],
            )
          ],
        ));
  }

  Widget cardInfoDetail(DataLogin dataLogin, MenuAkun redaksional) {
    return BlocBuilder<StatusPengajuanDataBloc, StatusPengajuanDataState>(
      builder: (BuildContext context, StatusPengajuanDataState state) {
        if (state is getStatusPengajuanDataSuccessState) {
          dataStatusPengajuan = state.listStatusPengajuanData;
        }
        return Container(
          width: MediaQuery.of(context).size.width,
          padding: EdgeInsets.fromLTRB(12, 16, 12, 16),
          decoration: CustomStyle.boxDecoration,
          child: Column(
            children: [
              GestureDetector(
                onTap: () {
                  BlocProvider.of<NavigatorBloc>(context)
                      .add(NavigateToHalamanDataDiri(context, 0));
                },
                child: Container(
                  color: Colors.transparent,
                  width: MediaQuery.of(context).size.width,
                  child: IconInformation(
                    icon: ValueImage.iconDataDiri,
                    title: redaksional.dataDiri,
                    enableSubTitle: false,
                    sizeIcon: 30,
                    rightOptionalWidget: Container(
                        margin: EdgeInsets.only(right: 11),
                        child: Row(
                          children: [
                            // data == null ? Container() : data.statusDataDiri == '0' ? Container() :
                            // data.statusDataDiri == '2' ? Container(
                            //     padding: EdgeInsets.all(2),
                            //     decoration: BoxDecoration(shape: BoxShape.circle,color: Colors.blue[700]),
                            //     child: Icon(Icons.check_sharp,color: Colors.white,size: 15,)):
                            dataStatusPengajuan == null
                                ? Container()
                                : !dataStatusPengajuan!.statusPengajuanDataDiri!
                                    ? Container()
                                    : Container(
                                        decoration: BoxDecoration(
                                            color: Colors.orange,
                                            shape: BoxShape.circle),
                                        height: 11,
                                        width: 11,
                                      ),
                            SizedBox(width: 9),
                            Icon(
                              Icons.arrow_forward_ios,
                              color: CustomStyle.color1,
                              size: 21,
                            ),
                          ],
                        )),
                  ),
                ),
              ),
              Divider(),
              GestureDetector(
                onTap: () => BlocProvider.of<NavigatorBloc>(context)
                    .add(NavigateToHalamanDataKeluarga(context, 0)),
                child: Container(
                  color: Colors.transparent,
                  child: IconInformation(
                    icon: ValueImage.iconDataKeluarga,
                    title: redaksional.dataKeluarga,
                    enableSubTitle: false,
                    sizeIcon: 30,
                    rightOptionalWidget: Container(
                        child: Container(
                            margin: EdgeInsets.only(right: 11),
                            child: Row(
                              children: [
                                dataStatusPengajuan == null
                                    ? Container()
                                    : !dataStatusPengajuan!.statusDataKeluarga!
                                        ? Container()
                                        : Container(
                                            decoration: BoxDecoration(
                                                color: Colors.orange,
                                                shape: BoxShape.circle),
                                            height: 11,
                                            width: 11,
                                          ),
                                SizedBox(width: 9),
                                Icon(
                                  Icons.arrow_forward_ios,
                                  color: CustomStyle.color1,
                                  size: 21,
                                ),
                              ],
                            ))),
                  ),
                ),
              ),
              Divider(),
              GestureDetector(
                  onTap: () => BlocProvider.of<NavigatorBloc>(context)
                      .add(NavigateToHalamanDataPendidikan(context, 0)),
                  child: Container(
                      color: Colors.transparent,
                      child: IconInformation(
                        icon: ValueImage.iconDataPendidikan,
                        title: redaksional.dataPendidikan,
                        enableSubTitle: false,
                        sizeIcon: 30,
                        rightOptionalWidget: Container(
                            child: Container(
                                margin: EdgeInsets.only(right: 11),
                                child: Row(
                                  children: [
                                    // data == null ? Container() : data.statusDataKeluarga == '0' ? Container() :
                                    // data.statusDataKeluarga == '2' ? Container(
                                    //     padding: EdgeInsets.all(2),
                                    //     decoration: BoxDecoration(shape: BoxShape.circle,color: Colors.blue[700]),
                                    //     child: Icon(Icons.check_sharp,color: Colors.white,size: 15,)):
                                    dataStatusPengajuan == null
                                        ? Container()
                                        : !dataStatusPengajuan!
                                                .statusDataPendidikan!
                                            ? Container()
                                            : Container(
                                                decoration: BoxDecoration(
                                                    color: Colors.orange,
                                                    shape: BoxShape.circle),
                                                height: 11,
                                                width: 11,
                                              ),
                                    SizedBox(width: 9),
                                    Icon(
                                      Icons.arrow_forward_ios,
                                      color: CustomStyle.color1,
                                      size: 21,
                                    ),
                                  ],
                                ))),
                      ))),
              Divider(),
              GestureDetector(
                onTap: () => BlocProvider.of<NavigatorBloc>(context)
                    .add(NavigateToHalamanDataPengalamanKerja(context, 0)),
                child: Container(
                  color: Colors.transparent,
                  child: IconInformation(
                    icon: ValueImage.iconDataPengalamanKerja,
                    title: redaksional.pengalamanKerja,
                    enableSubTitle: false,
                    sizeIcon: 30,
                    rightOptionalWidget: Container(
                        child: Container(
                            margin: EdgeInsets.only(right: 11),
                            child: Row(
                              children: [
                                // data == null ? Container() : data.statusDataKeluarga == '0' ? Container() :
                                // data.statusDataKeluarga == '2' ? Container(
                                //     padding: EdgeInsets.all(2),
                                //     decoration: BoxDecoration(shape: BoxShape.circle,color: Colors.blue[700]),
                                //     child: Icon(Icons.check_sharp,color: Colors.white,size: 15,)):
                                dataStatusPengajuan == null
                                    ? Container()
                                    : !dataStatusPengajuan!
                                            .statusPengalamanKerja!
                                        ? Container()
                                        : Container(
                                            decoration: BoxDecoration(
                                                color: Colors.orange,
                                                shape: BoxShape.circle),
                                            height: 11,
                                            width: 11,
                                          ),
                                SizedBox(width: 9),
                                Icon(
                                  Icons.arrow_forward_ios,
                                  color: CustomStyle.color1,
                                  size: 21,
                                ),
                              ],
                            ))),
                  ),
                ),
              ),
              Divider(),
              GestureDetector(
                onTap: () => BlocProvider.of<NavigatorBloc>(context)
                    .add(NavigateToHalamanDataKelengkapanFile(context, 0)),
                child: Container(
                  color: Colors.transparent,
                  child: IconInformation(
                    icon: ValueImage.iconDataFile,
                    title: redaksional.kelengkapanFile,
                    enableSubTitle: false,
                    sizeIcon: 30,
                    rightOptionalWidget: Container(
                        child: Container(
                            margin: EdgeInsets.only(right: 11),
                            child: Row(
                              children: [
                                // data == null ? Container() : data.statusDataKeluarga == '0' ? Container() :
                                // data.statusDataKeluarga == '2' ? Container(
                                //     padding: EdgeInsets.all(2),
                                //     decoration: BoxDecoration(shape: BoxShape.circle,color: Colors.blue[700]),
                                //     child: Icon(Icons.check_sharp,color: Colors.white,size: 15,)):
                                dataStatusPengajuan == null
                                    ? Container()
                                    : !dataStatusPengajuan!
                                            .statusDataKelengkapanFile!
                                        ? Container()
                                        : Container(
                                            decoration: BoxDecoration(
                                                color: Colors.orange,
                                                shape: BoxShape.circle),
                                            height: 11,
                                            width: 11,
                                          ),
                                SizedBox(width: 9),
                                Icon(
                                  Icons.arrow_forward_ios,
                                  color: CustomStyle.color1,
                                  size: 21,
                                ),
                              ],
                            ))),
                  ),
                ),
              ),
              !dataLogin.lockFaceRecognition!
                  ? Column(
                      children: [
                        Divider(),
                        IconInformation(
                          icon: ValueImage.iconDataDiri,
                          title: redaksional.dataWajah,
                          subtitle: dataLogin.fotoFace != null &&
                                  dataLogin.fotoFace != '-'
                              ? redaksional.teregistrasi
                              : redaksional.belumRegistrasi,
                          sizeIcon: 30,
                          rightOptionalWidget: dataLogin.fotoFace != null &&
                                  dataLogin.fotoFace != '-'
                              ? GestureDetector(
                                  onTap: () =>
                                      BlocProvider.of<NavigatorBloc>(context)
                                          .add(NavigateToDetailImageClicked(
                                              context, dataLogin.fotoFace)),
                                  child: Container(
                                    width: 40,
                                    child: Text(
                                      redaksional.lihat!,
                                      style: TextStyle(
                                          fontSize: CustomStyle.fontSizeSmall,
                                          color: CustomStyle.color1),
                                    ),
                                  ),
                                )
                              : Container(width: 30),
                        ),
                      ],
                    )
                  : Container(),
            ],
          ),
        );
      },
    );
  }

  Future<bool> back() async {
    return false;
  }

  void _settingModalBottomSheet(
      DataLogin loginRespon, MenuAkun redaksional) async {
    String bahasa = await sharedPreferences().getBahasa();
    ChooseLanguage? _character;
    if (bahasa == "id")
      _character = ChooseLanguage.id;
    else
      _character = ChooseLanguage.en;
    LoadingBloc loadingBloc = LoadingBloc();
    showModalBottomSheet(
        elevation: 0,
        showDragHandle: true,
        enableDrag: true,
        context: context,
        isDismissible: false,
        shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.only(
                topRight: Radius.circular(18), topLeft: Radius.circular(18))),
        isScrollControlled: true,
        builder: (context) => WillPopScope(
              onWillPop: () async {
                Navigator.pop(context);
                // print('Testing back');
                return false;
              },
              child: StatefulBuilder(builder: (BuildContext context,
                  StateSetter setState /*You can rename this!*/) {
                return SingleChildScrollView(
                  child: Padding(
                    padding: EdgeInsets.only(
                        bottom: MediaQuery.of(context).viewInsets.bottom),
                    child: ConstrainedBox(
                      constraints: BoxConstraints(
                          minHeight: MediaQuery.of(context).size.height / 4),
                      child: Container(
                        padding: EdgeInsets.fromLTRB(18, 0, 18, 14),
                        color: Colors.white,
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(redaksional.pilihBahasa!,
                                style: TextStyle(
                                    color: CustomStyle.fontColorBlack,
                                    fontSize: 16,
                                    fontWeight: FontWeight.w700)),
                            SizedBox(height: 13),

                            BlocProvider(
                                create: (context) => loadingBloc,
                                child: BlocBuilder<LoadingBloc, LoadingState>(
                                    builder: (context, state) {
                                  if (state == LoadingState.loading) {
                                    return LinearProgressIndicator(
                                      valueColor: AlwaysStoppedAnimation<Color>(
                                          Color.fromRGBO(145, 152, 255, 1.0)),
                                    );
                                  } else {
                                    return Divider(color: Colors.grey);
                                  }
                                })),
                            SizedBox(height: 13),
                            GestureDetector(
                              onTap: () {
                                setState(() {
                                  _character = ChooseLanguage.id;
                                });
                              },
                              child: Container(
                                color: Colors.transparent,
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  mainAxisAlignment:
                                      MainAxisAlignment.spaceBetween,
                                  children: [
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Text('Indonesia',
                                            style: TextStyle(
                                                fontWeight: FontWeight.bold)),
                                        SizedBox(height: 3),
                                        FutureBuilder(
                                            future:
                                                PengaturanBahasa().language(),
                                            builder: (context, snapshot) {
                                              return Text(
                                                  snapshot.data == null
                                                      ? ""
                                                      : snapshot.data!.bahasa!
                                                          .indonesia!,
                                                  style: TextStyle(
                                                      color: Colors.grey,
                                                      fontSize: 12,
                                                      fontWeight:
                                                          FontWeight.w400));
                                            })
                                      ],
                                    ),
                                    Radio<ChooseLanguage>(
                                        value: ChooseLanguage.id,
                                        groupValue: _character,
                                        onChanged: (ChooseLanguage? val) {
                                          setState(() {
                                            _character = val;
                                          });
                                        })
                                  ],
                                ),
                              ),
                            ),
                            // SizedBox(height: 7),
                            Divider(),
                            SizedBox(height: 7),
                            GestureDetector(
                              onTap: () {
                                setState(() {
                                  _character = ChooseLanguage.en;
                                });
                              },
                              child: Container(
                                color: Colors.transparent,
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  mainAxisAlignment:
                                      MainAxisAlignment.spaceBetween,
                                  children: [
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Text('English',
                                            style: TextStyle(
                                                fontWeight: FontWeight.bold)),
                                        SizedBox(height: 3),
                                        FutureBuilder(
                                            future:
                                                PengaturanBahasa().language(),
                                            builder: (context, snapshot) {
                                              return Text(
                                                  snapshot.data == null
                                                      ? ""
                                                      : snapshot.data!.bahasa!
                                                          .english!,
                                                  style: TextStyle(
                                                      color: Colors.grey,
                                                      fontSize: 12,
                                                      fontWeight:
                                                          FontWeight.w400));
                                            })
                                      ],
                                    ),
                                    Radio<ChooseLanguage>(
                                        value: ChooseLanguage.en,
                                        groupValue: _character,
                                        onChanged: (ChooseLanguage? val) {
                                          setState(() {
                                            _character = val;
                                          });
                                        }),
                                  ],
                                ),
                              ),
                            ),
                            SizedBox(height: 37),
                            Divider(color: Colors.grey),
                            SizedBox(height: 13),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Expanded(
                                  child: Container(
                                    decoration: BoxDecoration(
                                        border: Border.all(
                                            color: CustomStyle.color1),
                                        borderRadius:
                                            BorderRadius.circular(18)),
                                    child: BlocProvider(
                                        create: (context) => loadingBloc,
                                        child: BlocBuilder<LoadingBloc,
                                                LoadingState>(
                                            builder: (context, state) {
                                          bool enable = false;
                                          if (state == LoadingState.loading) {
                                            enable = false;
                                          } else {
                                            enable = true;
                                          }
                                          return TemplateButton(
                                            onClick: () =>
                                                BlocProvider.of<NavigatorBloc>(
                                                        context)
                                                    .add(NavigatePop(context)),
                                            label: redaksional.btnBatalkan,
                                            expand: true,
                                            color: Colors.transparent,
                                            contentColor: CustomStyle.color1,
                                            fontSize:
                                                CustomStyle.fontSizeNormal - 2,
                                            bold: true,
                                            borderColor: enable
                                                ? CustomStyle.color1
                                                : Colors.grey,
                                            enabled: enable,
                                            paddingTopBottom: 0,
                                            heightButton: 34,
                                            paddingLeftRight: 8,
                                          );
                                        })),
                                  ),
                                ),
                                SizedBox(width: 13),
                                Expanded(
                                  child: Container(
                                    decoration: BoxDecoration(
                                        border: Border.all(
                                            color: CustomStyle.color1),
                                        borderRadius:
                                            BorderRadius.circular(18)),
                                    child: TemplateButton(
                                      onClick: () async {
                                        String lang = "";
                                        if (_character == ChooseLanguage.en) {
                                          lang = 'en';
                                        } else {
                                          lang = 'id';
                                        }
                                        loadingBloc.setLoading();
                                        // ProgressDialogDelayed.show(pd, isDismissible: false);
                                        BasicRespon respon =
                                            await UserApi().updateBahasa(lang);
                                        // ProgressDialogDelayed.hide(pd);
                                        if (respon.success!) {
                                          await sharedPreferences()
                                              .setBahasa(lang);
                                        }
                                        BlocProvider.of<NavigatorBloc>(context)
                                            .add(NavigatePop(context));
                                        BlocProvider.of<PageAkunBloc>(context)
                                            .add(GetDataPageAkun(context));

                                        loadingBloc.setLoaded();
                                      },
                                      label: redaksional.btnTerapkan,
                                      expand: true,
                                      color: CustomStyle.color1,
                                      contentColor: CustomStyle.backgroundColor,
                                      fontSize: CustomStyle.fontSizeNormal - 2,
                                      bold: true,
                                      paddingTopBottom: 0,
                                      heightButton: 34,
                                      paddingLeftRight: 8,
                                    ),
                                  ),
                                ),
                              ],
                            ),
                            SizedBox(height: 13),
                          ],
                        ),
                      ),
                    ),
                  ),
                );
              }),
            ));
  }

  openDialog(DataLogin dataLogin) {
    TextEditingController noTelp = new TextEditingController();
    noTelp.text = dataLogin.noTelp!;
    showDialog(
        context: context,
        builder: (BuildContext context) {
          return AlertDialog(
            shape: RoundedRectangleBorder(
                borderRadius:
                    BorderRadius.all(Radius.circular(CustomStyle.boxRadius))),
            content: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Padding(
                  padding: const EdgeInsets.only(bottom: 12, top: 6),
                  child: SingleChildScrollView(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        TemplateForm(
                          keyboardNumber: true,
                          controller: noTelp,
                          color: CustomStyle.formColor,
                          radius: CustomStyle.formRadius,
                          formHeight: CustomStyle.formHeight,
                          titleText: "No Telepon/Handphone",
                        ),
                        TemplateButton(
                          onClick: () => BlocProvider.of<AuthBloc>(context).add(
                              GantiProfilEvent(
                                  noTelp.text, context, scaffoldKey)),
                          radius: CustomStyle.formRadius + 6,
                          label: "Ubah Nomor Telepon/Handphone",
                          color: CustomStyle.color1,
                          expand: true,
                          bold: true,
                          heightButton: 40,
                        ),
                      ],
                    ),
                  ),
                ),
              ],
            ),
          );
        });
  }
}

enum ChooseLanguage { id, en }
