import 'package:absenkuv3/Bloc/Akun/DataPendidikan/DataPendidikanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownAsalLulusanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenjangBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataPendidikan/mDataPendidikan.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataPendidikan/mDataPendidikanById.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataPendidikanPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisAsalLulusan.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisJenjang.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisAsalLulusan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisJenjang.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePicker2Bloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePickerBloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel2.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/templateMultiImagePicker.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/templateMultiImagePicker2.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class HalamanEditDataPendidikan extends StatefulWidget {
  var idPendidikan;
  HalamanEditDataPendidikan(this.idPendidikan);

  @override
  _HalamanEditDataPendidikanState createState() => _HalamanEditDataPendidikanState();
}

class _HalamanEditDataPendidikanState extends State<HalamanEditDataPendidikan> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  String? idPendidikan;
  JenisData? jenjangPendidikan;
  TextEditingController jurusan = new TextEditingController();
  TextEditingController namaSekolah = new TextEditingController();
  TextEditingController tanggalMasuk = new TextEditingController();
  TextEditingController tanggalLulus = new TextEditingController();
  TextEditingController gelar = new TextEditingController();
  JenisData? lulusanAsal;

  List<MultiImagePickerModel>? listImageIjazah;
  List<MultiImagePickerModel2>? listImageTranskrip;


  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataPendidikanBloc>(context).add(getDataPendidikanPengajuanByIdEvent(context,widget.idPendidikan, 'data'));
  }

  Future<bool> keluar() async {
    Navigator.pop(context);
    return false;
  }

  void setDataKeluarga(DataDatapendidikanById state){
    idPendidikan          = state.idPendidikan!;
    jenjangPendidikan     = state.jenjang;
    jurusan.text          = state.jurusan!;
    namaSekolah.text      = state.namaSekolah!;
    lulusanAsal           = state.lulusanAsal;
    tanggalMasuk.text     = state.tahunMasuk!;
    tanggalLulus.text     = state.tahunLulus!;
    gelar.text            = state.gelar!;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataPendidikanModel>(
        future: PengaturanBahasa().dataPendidikan(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
              key: scaffoldKey,
              appBar: AppBar(centerTitle: true,
                iconTheme: IconThemeData(color: CustomStyle.color15),
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
                title: Text(
                  snapshot.data!.menuDataPendidikan!.editTitle!,
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15),
                ),
              ),
              body: BlocBuilder<DataPendidikanBloc, DataPendidikanState>(
                  builder: (BuildContext context, DataPendidikanState state){
                    if(state is getDataPendidikanByIdSuccessState) {
                      setDataKeluarga(state.dataById![0]);
                      return SingleChildScrollView(
                        child: Container(
                          margin: EdgeInsets.all(10),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              BlocListener<DropdownJenjangBloc, DropdownJenjangState>(
                                listener: (BuildContext context, DropdownJenjangState state) {
                                  if (state is DropdownJenjangSuccessState && state.selectedValue != null) {
                                    jenjangPendidikan = state.selectedValue;
                                  }
                                },
                                child: BottomSheetJenisJenjang(
                                  snapshot.data!.menuDataPendidikan!.dataPendidikan!.jenjangPendidikan!,
                                  initialData: jenjangPendidikan == null ? null : jenjangPendidikan!.nama,
                                  color: Colors.black,
                                  marginHorizontal: 13,
                                ),
                              ),
                              TemplateTextFormAkun(
                                adaValidasi: false,
                                controller: jurusan,
                                color: Colors.black,
                                fontSize: 13,
                                titleText: snapshot.data!.menuDataPendidikan!.dataPendidikan!.jurusan,
                                radius: CustomStyle.formRadius,
                                marginHorizontal: 13,
                                // hintText: "Jurusan",
                              ),
                              SizedBox(height: 17),
                              TemplateTextFormAkun(
                                adaValidasi: true,
                                controller: namaSekolah,
                                color: Colors.black,
                                marginHorizontal: 13,
                                fontSize: 13,
                                titleText: snapshot.data!.menuDataPendidikan!.dataPendidikan!.namaSekolah,
                                radius: CustomStyle.formRadius,
                                // hintText: "Nama Sekolah",
                              ),
                              SizedBox(height: 17),
                              TemplateTextFormAkun(
                                adaValidasi: true,
                                controller: tanggalMasuk,
                                color: Colors.black,
                                fontSize: 13,
                                titleText: snapshot.data!.menuDataPendidikan!.dataPendidikan!.tahunMasuk,
                                keyboardNumber: true,
                                radius: CustomStyle.formRadius,
                                marginHorizontal: 13,
                                // hintText: "Tahun Masuk",
                              ),
                              SizedBox(height: 17),
                              TemplateTextFormAkun(
                                adaValidasi: true,
                                controller: tanggalLulus,
                                color: Colors.black,
                                fontSize: 13,
                                titleText: snapshot.data!.menuDataPendidikan!.dataPendidikan!.tahunLulus,
                                radius: CustomStyle.formRadius,
                                keyboardNumber: true,
                                marginHorizontal: 13,
                                // hintText: "Tahun Lulus",
                              ),
                              BlocListener<DropdownAsalLulusanBloc, DropdownAsalLulusanState>(
                                listener: (BuildContext context, DropdownAsalLulusanState state) {
                                  if (state is DropdownAsalLulusanSuccessState && state.selectedValue != null) {
                                    lulusanAsal = state.selectedValue;
                                  }
                                },
                                child: BottomSheetJenisAsalLulusan(
                                  snapshot.data!.menuDataPendidikan!.dataPendidikan!.lulusanAsal!,
                                  initialData: lulusanAsal == null ? null : lulusanAsal!.nama,
                                  color: Colors.black,
                                  marginHorizontal: 14,
                                ),
                              ),
                              SizedBox(height: 11),
                              TemplateTextFormAkun(
                                adaValidasi: false,
                                controller: gelar,
                                color: Colors.black,
                                fontSize: 13,
                                titleText: snapshot.data!.menuDataPendidikan!.dataPendidikan!.gelar,
                                radius: CustomStyle.formRadius,
                                marginHorizontal: 13,
                                // hintText: "Gelar",
                              ),
                              SizedBox(height: 17),
                              Container(
                                  margin: EdgeInsets.only(bottom: 9, left: 15, right: 15),
                                  child: Text(snapshot.data!.menuDataPendidikan!.dataPendidikan!.lampiranIjasah!,style: TextStyle(color: Colors.grey[600]),)),
                              BlocListener<MultiImagePickerBloc, MultiImagePickerState>(
                                listener: (BuildContext context, MultiImagePickerState st) {
                                  if (st is MultiImageSuccessState){
                                    if(st.listData.length == 0) {
                                      if(state.dataById![0].ijazah != null) state.dataById![0].ijazah = "";
                                      listImageIjazah = null;
                                    }else{
                                      listImageIjazah = st.listData;
                                    }
                                  }
                                },
                                child: Container(
                                  margin: EdgeInsets.only(left: 15, right: 15),
                                  child: TemplateMultiImagePicker(
                                      multiImage: false,
                                      initialData: state.dataById![0].ijazah == "" ? null : [state.dataById![0].ijazah]
                                  ),
                                ),
                              ),

                              Container(
                                  margin: EdgeInsets.only(bottom: 9, left: 15, right: 15, top: 17),
                                  child: Text(snapshot.data!.menuDataPendidikan!.dataPendidikan!.lampiranTranskrip!,style: TextStyle(color: Colors.grey[600]),)),
                              BlocListener<MultiImagePicker2Bloc, MultiImagePicker2State>(
                                listener:
                                    (BuildContext context, MultiImagePicker2State state) {
                                  if (state is MultiImageSuccess2State)
                                    listImageTranskrip = state.listData;
                                },
                                child: Container(
                                  margin: EdgeInsets.only(left: 15, right: 15),
                                  child: TemplateMultiImagePicker2(
                                      multiImage: false,
                                      initialData: state.dataById![0].transkrip == "" ? null : [state.dataById![0].transkrip!]
                                  ),
                                ),
                              ),
                              Container(
                                margin: EdgeInsets.only(top: 15),
                                width: double.infinity,
                                height: 41,
                                child: MaterialButton(onPressed: () {
                                  if(jenjangPendidikan == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataPendidikan!.message!.jenjangPendidikanEmpty, context);
                                  else if(namaSekolah.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataPendidikan!.message!.namaSekolahEmpty, context);
                                  else if(tanggalMasuk.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataPendidikan!.message!.tahunMasuk, context);
                                  else if(tanggalLulus.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataPendidikan!.message!.tahunLulus, context);
                                  else if(lulusanAsal == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataPendidikan!.message!.lulusanAsal, context);
                                  else
                                    BlocProvider.of<DataPendidikanBloc>(context).add(
                                        EditDataPendidikanEvent(
                                            context,
                                            scaffoldKey,
                                            DataDatapendidikan(
                                              jenjang: jenjangPendidikan!.nama,
                                              jurusan: jurusan.text,
                                              namaSekolah: namaSekolah.text,
                                              idPendidikan: idPendidikan,
                                              tahunMasuk: tanggalMasuk.text,
                                              tahunLulus: tanggalLulus.text,
                                              lulusanAsal: lulusanAsal!.nama,
                                              gelar: gelar.text,
                                              ijazah: state.dataById![0].ijazah,
                                              transkrip: state.dataById![0].transkrip,
                                            ),
                                            listImageIjazah,
                                            listImageTranskrip
                                        ));
                                },
                                  shape: RoundedRectangleBorder(
                                      borderRadius: BorderRadius.circular(15)
                                  ),
                                  color: CustomStyle.color1,
                                  textColor: Colors.white,
                                  child: Text(snapshot.data!.menuDataPendidikan!.button!.ajukanPerubahanData!),
                                ),
                              )
                            ],
                          ),
                        ),
                      );
                    }
                    else if(state is DataPendidikanProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                    else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                  }
              ),
            );
          }else{
            return Container();
          }
        }
      ),
    );
  }
}
