import 'package:absenkuv3/Bloc/Akun/DataPendidikan/DataPendidikanBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataPendidikanPage.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataPendidikan/CardDataPendidikan.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanDataPendidikanPengajuan extends StatefulWidget {
  final PageDataPendidikanModel redaksional;
  HalamanDataPendidikanPengajuan(this.redaksional);

  @override
  _HalamanDataPendidikanPengajuanState createState() => _HalamanDataPendidikanPengajuanState();
}

class _HalamanDataPendidikanPengajuanState extends State<HalamanDataPendidikanPengajuan> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataPendidikanBloc>(context).add(getDataPendidikanPengajuanEvent(context));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: BlocBuilder<DataPendidikanBloc, DataPendidikanState>(
          builder: (BuildContext context, DataPendidikanState state){
            if(state is getDataPendidikanSuccessState) {
              return ListView.builder(
                  physics: AlwaysScrollableScrollPhysics(),
                  controller: _scrollController,
                  itemCount: state.data!.length,
                  itemBuilder: (BuildContext context, index) {
                    return CardDataPendidikanPengajuan(scaffoldKey,state.data![index],"pengajuan", widget.redaksional);
                  }
              );
            }
            else if(state is DataPendidikanProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
            else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
          }
      ),
    );
  }

}
