import 'package:absenkuv3/Bloc/Akun/DataKeluarga/DataKeluargaBloc.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownAgamaBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownHubunganBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenisStatusBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownPekerjaanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownPendidikanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownStatusPerkawinanBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataKeluarga/mDataKeluarga.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKeluargaPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenisKelaminBloc.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetAgama.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisHubungan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisKelamin.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisPekerjaan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisStatus.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetPendidikan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetStatusPerkawinan.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerTglKawinBloc.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerTglLahirBloc.dart';
import 'package:absenkuv3/UI/Template/DatePicker/UI/templateDatePickerTglKawin.dart';
import 'package:absenkuv3/UI/Template/DatePicker/UI/templateDatePickerTglLahir.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

// ignore: must_be_immutable
class
HalamanAddDataKeluarga extends StatefulWidget {
  var idKeluarga;
  HalamanAddDataKeluarga(this.idKeluarga);

  @override
  _HalamanAddDataKeluargaState createState() => _HalamanAddDataKeluargaState();
}

class _HalamanAddDataKeluargaState extends State<HalamanAddDataKeluarga> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  // DATA DIRI
  TextEditingController nik = new TextEditingController();
  TextEditingController namaLengkap = new TextEditingController();
  TextEditingController tanggalLahirRaw = new TextEditingController();
  JenisData? pendTerakhir;
  JenisData? jenisKelamin;
  JenisData? jenisStatus;
  JenisData? jenisStatusPerkawinan;
  JenisData? jenisPekerjaan;
  JenisData? jenisHubunganKeluarga;
  TextEditingController tmptLahir = new TextEditingController();
  TextEditingController telp = new TextEditingController();
  TextEditingController noBPJS = new TextEditingController();
  JenisData? agama;
  final dateFormat = new DateFormat('dd-MM-yyyy');
  DateFormat dateFormatRaw = DateFormat('d MMMM yyyy', 'id_ID');
  String tanggalLahir = '00-00-0000';
  String tglPerkawinan = '00-00-0000';
  TextEditingController tglPerkawinanRaw = new TextEditingController();


  Future<bool> keluar() async {
    Navigator.pop(context);
    return false;
  }



  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataKeluargaModel>(
        future: PengaturanBahasa().dataKeluarga(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            dateFormatRaw = DateFormat('d MMMM yyyy', snapshot.data!.menuDataKeluarga!.locale);
            return Scaffold(
                key: scaffoldKey,
                appBar: AppBar(centerTitle: true,
                  iconTheme: IconThemeData(color: CustomStyle.color15),
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  title: Text(snapshot.data!.menuDataKeluarga!.addTitle!,
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle, color: CustomStyle.color15),
                  ),
                ),
                body: SingleChildScrollView(
                  child: Container(
                    margin: EdgeInsets.all(10),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        BlocListener<DropdownHubunganBloc, DropdownHubunganState>(
                          listener: (BuildContext context, DropdownHubunganState state) {
                            if (state is DropdownHubunganSuccessState && state.selectedValue != null) {
                              jenisHubunganKeluarga = state.selectedValue;
                            }
                          },
                          child: BottomSheetJenisHubungan(
                            snapshot.data!.menuDataKeluarga!.dataKeluarga!.hubKeluarga!,
                            initialData: jenisHubunganKeluarga==null?null:jenisHubunganKeluarga!.nama,
                            marginHorizontal: 13,
                          ),
                        ),
                        SizedBox(height: 17),
                        TemplateTextFormAkun(
                          adaValidasi: false,
                          controller: nik,
                          color: Colors.black,
                          fontSize: 13,
                          titleText: snapshot.data!.menuDataKeluarga!.dataKeluarga!.nik,
                          keyboardNumber: true,
                          marginHorizontal: 13,
                          radius: CustomStyle.formRadius,
                          // hintText: "NIK",
                        ),
                        SizedBox(height: 17),
                        TemplateTextFormAkun(
                          adaValidasi: true,
                          controller: namaLengkap,
                          color: Colors.black,
                          marginHorizontal: 13,
                          fontSize: 13,
                          titleText: snapshot.data!.menuDataKeluarga!.dataKeluarga!.namaLengkap,
                          radius: CustomStyle.formRadius,
                          // hintText: "Nama Lengkap",
                        ),
                        SizedBox(height: 17),
                        TemplateTextFormAkun(
                          adaValidasi: true,
                          controller: tmptLahir,
                          color: Colors.grey[600],
                          fontSize: 13,
                          titleText: snapshot.data!.menuDataKeluarga!.dataKeluarga!.tempatLahir,
                          marginHorizontal: 13,
                          radius: CustomStyle.formRadius,
                          // hintText: "Tempat Lahir",
                        ),
                        SizedBox(height: 17),
                        BlocListener<DatePickerTglLahirBloc, DateTime>(
                          listener: (BuildContext context, DateTime date) {
                            tanggalLahir = dateFormat.format(date);//dateFormat.format(date);
                            tanggalLahirRaw.text = dateFormatRaw.format(date);
                          },
                          child: TemplateDatePickerTglLahir(
                            '${snapshot.data!.menuDataKeluarga!.dataKeluarga!.tanggalLahir} ',
                            marginHorizontal: 13,
                            textEditingController: tanggalLahirRaw,
                            initialData: tanggalLahir == '00-00-0000'
                                ? null
                                : DateTime(int.parse(tanggalLahir.split('-')[2]),int.parse(tanggalLahir.split('-')[1]),int.parse(tanggalLahir.split('-')[0])),),
                        ),
                        SizedBox(height: 11),
                        BlocListener<DropdownJenisKelaminBloc, DropdownJenisKelaminState>(
                          listener: (BuildContext context, DropdownJenisKelaminState state) {
                            if (state is DropdownJenisKelaminSuccessState && state.selectedValue != null) {
                              jenisKelamin = state.selectedValue;
                            }
                          },
                          child: BottomSheetJenisKelamin(
                            snapshot.data!.menuDataKeluarga!.dataKeluarga!.jenisKelamin!,
                            marginHorizontal: 13,
                            initialData: jenisKelamin==null?null:jenisKelamin!.nama,
                          ),
                        ),
                        SizedBox(height: 13),
                        BlocListener<DropdownAgamaBloc, DropdownAgamaState>(
                          listener: (BuildContext context, DropdownAgamaState state) {
                            if (state is DropdownAgamaSuccessState && state.selectedValue != null) {
                              agama = state.selectedValue;
                            }
                          },
                          child: BottomSheetAgama(
                            snapshot.data!.menuDataKeluarga!.dataKeluarga!.agama!,
                            marginHorizontal: 13,
                            initialData: agama == null ? null : agama!.nama,
                          ),
                        ),
                        SizedBox(height: 23),
                        TemplateTextFormAkun(
                          adaValidasi: false,
                          controller: telp,
                          color: Colors.black,
                          marginHorizontal: 13,
                          keyboardNumber: true,
                          fontSize: 13,
                          titleText: snapshot.data!.menuDataKeluarga!.dataKeluarga!.telepon,
                          radius: CustomStyle.formRadius,
                          // hintText: "No Telepon",
                        ),
                        SizedBox(height: 13),
                        BlocListener<DropdownPekerjaanBloc, DropdownPekerjaanState>(
                          listener: (BuildContext context, DropdownPekerjaanState state) {
                            if (state is DropdownPekerjaanSuccessState && state.selectedValue != null) {
                              jenisPekerjaan = state.selectedValue;
                            }
                          },
                          child: BottomSheetJenisPekerjaan(
                            snapshot.data!.menuDataKeluarga!.dataKeluarga!.pekerjaan!,
                            marginHorizontal: 13,
                            initialData: jenisPekerjaan==null?null:jenisPekerjaan!.nama,
                          ),
                        ),
                        SizedBox(height: 13),
                        BlocListener<DropdownStatusPerkawinanBloc, DropdownStatusPerkawinanState>(
                          listener: (BuildContext context, DropdownStatusPerkawinanState state) {
                            if (state is DropdownStatusPerkawinanSuccessState && state.selectedValue != null) {
                              jenisStatusPerkawinan = state.selectedValue;
                            }
                          },
                          child: BottomSheetStatusPerkawinan(
                            snapshot.data!.menuDataKeluarga!.dataKeluarga!.statusPerkawinan!,
                            initialData: jenisStatusPerkawinan==null?null:jenisStatusPerkawinan!.nama,
                            marginHorizontal: 13,
                          ),
                        ),
                        SizedBox(height: 29),
                        BlocListener<DatePickerTglKawinBloc, DateTime>(
                          listener: (BuildContext context, DateTime date) {
                            tglPerkawinan = dateFormat.format(date);//dateFormat.format(date);
                            tglPerkawinanRaw.text = dateFormatRaw.format(date);
                          },
                          child: TemplateDatePickerTglKawin(
                            snapshot.data!.menuDataKeluarga!.dataKeluarga!.tanggalPerkawinan!,
                            marginHorizontal: 13,
                            validasi: false,
                            textEditingController: tglPerkawinanRaw,
                            initialData: tglPerkawinan == '00-00-0000'
                                ? null
                                : DateTime(int.parse(tglPerkawinan.split('-')[2]),int.parse(tglPerkawinan.split('-')[1]),int.parse(tglPerkawinan.split('-')[0])),),
                        ),
                        SizedBox(height: 17),
                        TemplateTextFormAkun(
                          adaValidasi: false,
                          controller: noBPJS,
                          color: Colors.black,
                          marginHorizontal: 13,
                          fontSize: 13,
                          titleText: snapshot.data!.menuDataKeluarga!.dataKeluarga!.noBpjsKes,
                          radius: CustomStyle.formRadius,
                          keyboardNumber: true,
                          // hintText: "Nomor BPJS Kesehatan",
                        ),
                        SizedBox(height: 9),
                        BlocListener<DropdownJenisStatusBloc, DropdownJenisStatusState>(
                          listener: (BuildContext context, DropdownJenisStatusState state) {
                            if (state is DropdownJenisStatusSuccessState && state.selectedValue != null) {
                              jenisStatus = state.selectedValue;
                            }
                          },
                          child: BottomSheetJenisStatus(
                            snapshot.data!.menuDataKeluarga!.dataKeluarga!.status!,
                            initialData: jenisStatus==null?null:jenisStatus!.nama,
                            marginHorizontal: 13,
                          ),
                        ),
                        //
                        SizedBox(height: 11),
                        BlocListener<DropdownPendidikanBloc, DropdownPendidikanState>(
                          listener: (BuildContext context, DropdownPendidikanState state) {
                            if (state is DropdownPendidikanSuccessState && state.selectedValue != null) {
                              pendTerakhir = state.selectedValue;
                            }
                          },
                          child: BottomSheetPendidikan(
                            snapshot.data!.menuDataKeluarga!.dataKeluarga!.pendidikanTerakhir!,
                            marginHorizontal: 13,
                            initialData: pendTerakhir == null ? null : pendTerakhir!.nama,
                          ),
                        ),
                        Container(
                          margin: EdgeInsets.only(top: 15),
                          width: double.infinity,
                          height: 41,
                          child: MaterialButton(onPressed: () {
                            if(jenisHubunganKeluarga == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.hubKeluargaEmpty, context);
                            else if(namaLengkap.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.namaLengkapEmpty, context);
                            else if(tmptLahir.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.tempatLahirEmpty, context);
                            else if(tanggalLahir =='00-00-0000') showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.tanggalLahirEmpty, context);
                            else if(jenisKelamin == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.jenisKelaminEmpty, context);
                            else if(agama == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.agamaEmpty, context);
                            else if(jenisPekerjaan == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.jenisPekerjaan, context);
                            else if(jenisStatusPerkawinan == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.statusPerkawinan, context);
                            else if(jenisStatus == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.status, context);
                            else if(pendTerakhir == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.pendidikanTerakhirEmpty, context);
                            else
                              BlocProvider.of<DataKeluargaBloc>(context).add(
                                  PengajuanTambahDataKeluargaEvent(
                                      context,
                                      scaffoldKey,
                                      DataDatakeluarga(
                                          hubKeluarga: jenisHubunganKeluarga==null?"":jenisHubunganKeluarga!.nama,
                                          nik: nik.text,
                                          namaLengkap: namaLengkap.text,
                                          tempatLahir: tmptLahir.text,
                                          tglLahir: '${tanggalLahir.split('-')[2]}-${tanggalLahir.split('-')[1]}-${tanggalLahir.split('-')[0]}',
                                          jenisKelamin: jenisKelamin==null?"":jenisKelamin!.id,
                                          agama: agama==null?"":agama!.nama,
                                          telepon: telp.text,
                                          pekerjaan: jenisPekerjaan==null?"":jenisPekerjaan!.nama,
                                          statusPerkawinan: jenisStatusPerkawinan==null?"":jenisStatusPerkawinan!.nama,
                                          tanggalPerkawinan: '${tglPerkawinan.split('-')[2]}-${tglPerkawinan.split('-')[1]}-${tglPerkawinan.split('-')[0]}',
                                          noBpjs: noBPJS.text,
                                          status: jenisStatus==null?"":jenisStatus!.nama,
                                          pendidikanTerakhir: pendTerakhir==null?"":pendTerakhir!.nama
                                      )
                                  ));
                            // }
                          },
                            shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(15)
                            ),
                            color: CustomStyle.color1,
                            textColor: Colors.white,
                            child: Text(snapshot.data!.menuDataKeluarga!.button!.ajukanData!),
                          ),
                        )
                      ],
                    ),
                  ),
                )
            );
          }else{
            return Container();
          }
        }
      )
    );
  }
}
