import 'package:absenkuv3/Bloc/Absensi/DataAbsensiPegawaiBloc.dart';
import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Absensi/KomponenAbsensi.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/FilterBottomSheet.dart';
import 'package:absenkuv3/UI/Template/FilterHeaderSheet.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListAbsensiPegawai extends StatefulWidget {
  final PageDataAbsensiModel redaksional;
  HalamanListAbsensiPegawai(this.redaksional);

  @override
  _HalamanListAbsensiPegawaiState createState() =>
      _HalamanListAbsensiPegawaiState();
}

class _HalamanListAbsensiPegawaiState extends State<HalamanListAbsensiPegawai> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  DateTime? dateTime;
  ModelFilter? modelFilterDataAbsensi;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    // BlocProvider.of<DataAbsensiPegawaiBloc>(context)
    //     .add(getListDataAbsensiPegawaiEvent(context, modelFilterDataAbsensi));
    BlocProvider.of<DataAbsensiPegawaiBloc>(context)
        .add(getListDataAbsensiKaryawanEvent(context, modelFilterDataAbsensi));
    _scrollController.addListener(() =>
        BlocProvider.of<DataAbsensiPegawaiBloc>(context).add(
            loadMoreKaryawanEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          Column(
            children: [
              Container(
                height: 50,
                width: MediaQuery.of(context).size.width * 1.5,
                child: BlocListener<FilterBottomSheetBloc, FilterBottomSheetState>(
                listener: (BuildContext context, FilterBottomSheetState state) {
                  if (state is setFilterSuccess) {
                    modelFilterDataAbsensi = state.modelFilter;
                    BlocProvider.of<DataAbsensiPegawaiBloc>(context).add(
                        getListDataAbsensiKaryawanEvent(
                            context, modelFilterDataAbsensi));
                  }
                },
                child: FilterHeaderSheet()),
              ),
            ],
          ),
          Padding(
            padding: const EdgeInsets.only(top: 50),
            child: BlocBuilder<DataAbsensiPegawaiBloc, DataAbsensiPegawaiState>(
                builder: (BuildContext context, DataAbsensiPegawaiState state) {
              if (state is getListDataAbsensiKaryawanSuccessState ||
                  state is LoadMoreProgressState)
                return Stack(
                  children: <Widget>[
                    ListView.builder(
                        physics: AlwaysScrollableScrollPhysics(),
                        controller: _scrollController,
                        itemCount: state.data!.length,
                        itemBuilder: (BuildContext context, index) {
                          return CardAbsensi(
                            state.data![index],
                            widget.redaksional,
                            absensiPegawai: true,
                          );
                        }),
                    state is LoadMoreProgressState
                        ? Positioned(
                            bottom: 16,
                            child: Container(
                                width: MediaQuery.of(context).size.width,
                                child: Center(
                                    child: CircularProgressIndicator(
                                  strokeWidth: 8,
                                ))))
                        : Container(),
                  ],
                );
              else if (state is DataAbsensiPegawaiProgressState)
                return Center(
                  child: CircularProgressIndicator(
                    strokeWidth: 8,
                  ),
                );
              else
                return Center(
                  child: Image.asset(
                    ValueImage.noData,
                    height: 250,
                  ),
                );
            }),
          ),
        ],
      ),
    );
  }
}
