// ignore_for_file: must_be_immutable

import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownCabangBloc.dart' as cabang;
import 'package:absenkuv3/Bloc/Dropdown/DropdownDepartemenBloc.dart'
    as departemen;
import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/DropdownCabang.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/DropdownDepartemen.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'KomponenAbsensi.dart';

class FilterAbsensi extends StatelessWidget {
  BuildContext? context;
  DataDropdown? dataDepartemen;
  DataDropdown? dataCabang;
  FilterAbsensi(this.context, this.dataCabang, this.dataDepartemen);
  @override
  Widget build(BuildContext context) {
    return TombolIcon(
      onClick: () => openDialog(),
      icon: Icons.filter_alt,
      bgnColor: Colors.white,
      size: 32,
      iconColor: CustomStyle.color1,
    );
  }

  openDialog() {
    showDialog(
        context: context!,
        builder: (BuildContext context) {
          return BlocBuilder<AuthBloc, LoginRespon>(
              builder: (BuildContext context, LoginRespon loginRespon) {
            return AlertDialog(
              shape: RoundedRectangleBorder(
                  borderRadius:
                      BorderRadius.all(Radius.circular(CustomStyle.boxRadius))),
              content: Column(
                mainAxisSize: MainAxisSize.min,
                children: [
                  Container(
                    padding: const EdgeInsets.only(bottom: 12, top: 6),
                    width: MediaQuery.of(context).size.width,
                    child: SingleChildScrollView(
                      child: Column(
                        children: [
                          Center(
                            child: Text(
                              "Filter",
                              style: TextStyle(fontWeight: FontWeight.w600),
                            ),
                          ),
                          SizedBox(
                            height: 4,
                          ),
                          Divider(
                            thickness: 1,
                          ),
                          SizedBox(
                            height: 4,
                          ),
                          loginRespon.dataLogin!.level == 4
                              ? BlocListener<cabang.DropdownCabangBloc,
                                  cabang.DropdownState>(
                                  listener: (BuildContext context,
                                      cabang.DropdownState state) {
                                    if (state is cabang.DropdownSuccessState &&
                                        state.selectedValue != null)
                                      dataCabang = state.selectedValue;
                                  },
                                  child: DropdownCabang(
                                    color: Colors.grey[600],
                                    formHeight: 32,
                                  ),
                                )
                              : Container(),
                          BlocListener<departemen.DropdownDepartemenBloc,
                              departemen.DropdownState>(
                            listener: (BuildContext context,
                                departemen.DropdownState state) {
                              if (state is departemen.DropdownSuccessState &&
                                  state.selectedValue != null)
                                dataDepartemen = state.selectedValue;
                            },
                            child: DropdownDepartemen(
                              color: Colors.grey[600],
                              formHeight: 32,
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      TemplateButton(
                        onClick: () => BlocProvider.of<NavigatorBloc>(context)
                            .add(NavigatePop(context)),
                        label: "Tutup",
                        color: Colors.transparent,
                        contentColor: CustomStyle.color1,
                        fontSize: CustomStyle.fontSizeNormal,
                        bold: true,
                      ),
                      TemplateButton(
                        onClick: () {
                          BlocProvider.of<FilterBottomSheetBloc>(context).add(
                              setFilterBottomSheet(ModelFilter(
                                  idCabang: dataCabang != null
                                      ? dataCabang!.id
                                      : null,
                                  idDepartemen: dataDepartemen != null
                                      ? dataDepartemen!.id
                                      : null)));
                          BlocProvider.of<NavigatorBloc>(context)
                              .add(NavigatePop(context));
                        },
                        label: "Terapkan",
                        color: Colors.transparent,
                        contentColor: CustomStyle.color1,
                        fontSize: CustomStyle.fontSizeNormal,
                        bold: true,
                      )
                    ],
                  )
                ],
              ),
            );
          });
        });
  }
}
