import 'package:flutter/services.dart';

class SecurityService {
  static const platform = MethodChannel("com.example.absenkuv3/security");

  static Future<bool> isDeveloperModeEnabled() async {
    try {
      final bool result = await platform.invokeMethod('isDeveloperModeEnabled');
      return result;
    } on PlatformException catch (e) {
      print("Failed to check developer mode: '${e.message}'.");
      return false;
    }
  }

  static Future<String> isCheckSource() async {
    const _platform = MethodChannel("com.example.absenkuv3");
    try {
      final String result = await _platform.invokeMethod('startCekSource');
      return result;
    } on PlatformException catch (e) {
      print("Failed to check secure environment: '${e.message}'.");
      return "";
    }
  }
  static Future<bool> isLocationFake() async {
    const _platform = MethodChannel("com.example.absenkuv3/location");
    try {
      final bool result = await _platform.invokeMethod('isLocationFake');
      return result;
    } on PlatformException catch (e) {
      print("Failed to check isLocationFake: '${e.message}'.");
      return false;
    }
  }
}