import 'package:absenkuv3/Bloc/Absensi/AbsensiBloc.dart';
import 'package:absenkuv3/Bloc/Absensi/DataAbsensiBloc.dart';
import 'package:absenkuv3/Bloc/Absensi/DataAbsensiPegawaiBloc.dart';
import 'package:absenkuv3/Bloc/Absensi/DataDetailAbsensiBloc.dart';
import 'package:absenkuv3/Bloc/Aktivitas/AbsensiAktivitasBloc.dart';
import 'package:absenkuv3/Bloc/Aktivitas/DetailAktivitasBloc.dart';
import 'package:absenkuv3/Bloc/Akun/DataDiri/DataDiriBloc.dart';
import 'package:absenkuv3/Bloc/Akun/DataDiri/DataDiriEditBloc.dart';
import 'package:absenkuv3/Bloc/Akun/DataPendidikan/DataPendidikanBloc.dart';
import 'package:absenkuv3/Bloc/Akun/KelengkapanFile/DataKelengkapanFileBloc.dart';
import 'package:absenkuv3/Bloc/Akun/KontakSemuaPegawai/KontakPegawaiBloc.dart';
import 'package:absenkuv3/Bloc/Akun/NotifikasiAkunBloc.dart';
import 'package:absenkuv3/Bloc/Akun/PengalamanKerja/DataPengalamanKerjaBloc.dart';
import 'package:absenkuv3/Bloc/Akun/StatusPengajuanDataBloc.dart';
import 'package:absenkuv3/Bloc/Badge/BadgeNotificationDashboardBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownSalesBawahanBloc.dart';
import 'package:absenkuv3/Bloc/Patroli/CekValidasiWaktuBloc.dart';
import 'package:absenkuv3/Bloc/Patroli/DetailPatroliBloc.dart';
import 'package:absenkuv3/Bloc/Cuti/GetDataCutiBloc.dart';
import 'package:absenkuv3/Bloc/Cuti/HistoryCutiBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownAgamaBloc.dart';
import 'package:absenkuv3/Bloc/Akun/DataKeluarga/DataKeluargaBloc.dart';
import 'package:absenkuv3/Bloc/Badge/BadgeShiftBloc.dart' as badgeShift;
import 'package:absenkuv3/Bloc/BadgeNotifBloc.dart' as badgeNotif;
import 'package:absenkuv3/Bloc/Berita/BeritaBloc.dart';
import 'package:absenkuv3/Bloc/Berita/DetailBeritaBloc.dart';
import 'package:absenkuv3/Bloc/Dashboard/DashboardBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownAsalLulusanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownGolonganDarahBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownHubunganBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenisStatusBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenjangBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownKabupatenBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownKecamatanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownKelurahanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownPekerjaanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownPendidikanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownProvinsiBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownStatusPerkawinanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownJenisAktivitasBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownJenisIzinBloc.dart'
    as dropdownJenisIzin;
import 'package:absenkuv3/Bloc/Dropdown/DropdownJenisPerusahaanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownLeadMasterBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownProdukLayananBloc.dart';
import 'package:absenkuv3/Bloc/Gaji/GajiBloc.dart';
import 'package:absenkuv3/Bloc/Izin/DetailIzinBloc.dart';
import 'package:absenkuv3/Bloc/Izin/JumlahIzinBloc.dart';
import 'package:absenkuv3/Bloc/Izin/RekapIzinPegawaiBloc.dart';
import 'package:absenkuv3/Bloc/Izin/RekapIzinSayaBloc.dart'
    as rekapIzinSayaBloc;
import 'package:absenkuv3/Bloc/Izin/SisaCutiBloc.dart';
import 'package:absenkuv3/Bloc/Kpi/Core/GetKomponenAtasanBloc.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetDataPengajuanKpiTeamBloc.dart';
import 'package:absenkuv3/Bloc/Lembur/AbsensiLemburBloc.dart';
import 'package:absenkuv3/Bloc/Lembur/DetailLemburBloc.dart';
import 'package:absenkuv3/Bloc/Lembur/RekapLemburPegawaiBloc.dart';
import 'package:absenkuv3/Bloc/Lembur/RekapLemburSayaBloc.dart'
    as rekapLemburSayaBloc;
import 'package:absenkuv3/Bloc/LoadingBloc.dart';
import 'package:absenkuv3/Bloc/MapsBloc.dart';
import 'package:absenkuv3/Bloc/NavbarBloc.dart';
import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Bloc/Page/PageReimbursementBloc.dart';
import 'package:absenkuv3/Bloc/Patroli/SelectedJadwalPatroliBloc.dart';
import 'package:absenkuv3/Bloc/PengaturanBloc.dart';
import 'package:absenkuv3/Bloc/Pengumuman/DetailPengumumanBloc.dart';
import 'package:absenkuv3/Bloc/Pengumuman/PengumumanBloc.dart';
import 'package:absenkuv3/Bloc/Pkwt/DetailPkwtBloc.dart';
import 'package:absenkuv3/Bloc/Pkwt/PkwtBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementDetailBloc.dart'
    as reimbursementDetailBloc;
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementItemBloc.dart'
    as reimbursementItemBloc;
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementSayaBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataAktivitasSalesBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataDailyAktivitasSalesBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataLayananDetailBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataLayananDetailByIdBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DetailDailyAktivitasSalesBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DetailKanbanSalesBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/KambanBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/LayananDraftBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/PelangganBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/StepperBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TahapanBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TargetSalesBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TotalDataLayananDetailBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TotalKambanBloc.dart';
import 'package:absenkuv3/Bloc/Shift/PilihShiftV2Bloc.dart';
import 'package:absenkuv3/Bloc/Shift/ShiftV2Bloc.dart';
import 'package:absenkuv3/Bloc/SlipGaji/SlipGajiBloc.dart';
import 'package:absenkuv3/Bloc/Sos/DetailSosBloc.dart';
import 'package:absenkuv3/Bloc/Summary/SummaryBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDailyActivity.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataKanban.dart';
import 'package:absenkuv3/Repository/Model/mReimbursement.dart';
import 'package:absenkuv3/Repository/Model/mShift.dart';
import 'package:absenkuv3/UI/Modul/Absensi/ParentTabDataAbsensi.dart';
import 'package:absenkuv3/UI/Modul/Absensi/halamanAbsensi.dart';
import 'package:absenkuv3/UI/Modul/Absensi/halamanDetailListAbsensi.dart';
import 'package:absenkuv3/UI/Modul/Aktivitas/HalamanDetailAktivitas.dart';
import 'package:absenkuv3/UI/Modul/Aktivitas/HalamanPengajuanAktivitas.dart';
import 'package:absenkuv3/UI/Modul/Aktivitas/ParentTabAktivitas.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataDiri/HalamanDetailNotifikasiDataDiri.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataDiri/HalamanEditDataDiri.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataDiri/HalamanEditPengajuanDataDiri.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataDiri/ParentTabDataDiri.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataKeluarga/HalamanAddDataKeluarga.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataKeluarga/HalamanDetailNotifikasiDataKeluarga.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataKeluarga/HalamanEditDataKeluarga.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataKeluarga/HalamanEditPengajuanDataKeluarga.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataKeluarga/ParentTabDataKeluarga.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataPendidikan/HalamanAddDataPendidikan.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataPendidikan/HalamanDetailNotifikasiDataPendidikan.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataPendidikan/HalamanEditDataPendidikan.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataPendidikan/HalamanEditPengajuanDataPendidikan.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataPendidikan/ParentTabDataPendidikan.dart';
import 'package:absenkuv3/UI/Modul/Akun/HalamanAkun.dart';
import 'package:absenkuv3/UI/Modul/Akun/HalamanGantiPassword.dart';
import 'package:absenkuv3/UI/Modul/Akun/KelengkapanFile/HalamanAddDataKelengkapanFile.dart';
import 'package:absenkuv3/UI/Modul/Akun/KelengkapanFile/HalamanDetailNotifikasiKelengkapanFile.dart';
import 'package:absenkuv3/UI/Modul/Akun/KelengkapanFile/HalamanEditDataKelengkapanFile.dart';
import 'package:absenkuv3/UI/Modul/Akun/KelengkapanFile/HalamanEditPengajuanDataKelengkapanFile.dart';
import 'package:absenkuv3/UI/Modul/Akun/KelengkapanFile/ParentTabKelengkapanFile.dart';
import 'package:absenkuv3/UI/Modul/Akun/KontakSemuaPegawai/HalamanDetailKontakPegawai.dart';
import 'package:absenkuv3/UI/Modul/Akun/KontakSemuaPegawai/HalamanListKontakPegawai.dart';
import 'package:absenkuv3/UI/Modul/Akun/PengalamanKerja/HalamanAddDataPengalamanKerja.dart';
import 'package:absenkuv3/UI/Modul/Akun/PengalamanKerja/HalamanDetailNotifikasiDataPengalamanKerja.dart';
import 'package:absenkuv3/UI/Modul/Akun/PengalamanKerja/HalamanEditDataPengalamanKerja.dart';
import 'package:absenkuv3/UI/Modul/Akun/PengalamanKerja/HalamanEditPengajuanDataPengalamanKerja.dart';
import 'package:absenkuv3/UI/Modul/Akun/PengalamanKerja/ParentTabDataPengalamanKerja.dart';
import 'package:absenkuv3/UI/Modul/Akun/detailImageClickedAkun.dart';
import 'package:absenkuv3/UI/Modul/Berita/HalamanDetailBerita.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenisKelaminBloc.dart';
import 'package:absenkuv3/UI/Modul/Login_SplashScreen/halamanLoginSso.dart';
import 'package:absenkuv3/UI/Modul/Patroli/HalamanDetailPatroli.dart';
import 'package:absenkuv3/UI/Modul/Patroli/ParentTabPatroli.dart';
import 'package:absenkuv3/UI/Modul/Cuti/HalamanCuti.dart';
import 'package:absenkuv3/UI/Modul/Cuti/HalamanListHistoryCuti.dart';
import 'package:absenkuv3/UI/Modul/Gaji/HalamanGaji.dart';
import 'package:absenkuv3/UI/Modul/Izin/HalamanDetailIzin.dart';
import 'package:absenkuv3/UI/Modul/Izin/HalamanPengajuanIzin.dart';
import 'package:absenkuv3/UI/Modul/Izin/ParentTabIzin.dart';
import 'package:absenkuv3/UI/Modul/Izin/ParentTabRekapIzin.dart';
import 'package:absenkuv3/UI/Modul/Kpi/HalamanKpi.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiApprovalTeam/HalamanApprovedkpiTeam/HalamanApprovedKpiteam.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiApprovalTeam/HalamanPengajuanApprovalKpiTeam/HalamanPengajuanApprovalKpiTeam.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiApprovalTeam/ParentTabApprovalKpiTeam.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/HalamanDetailApprovalKpiSaya/HalamanDetailApprovalKpiSaya.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/HalamanDetailDiterimaKpiSaya/HalamanDetailDiterimaKpiSaya.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/HalamanDetailPengajuanKpiSaya/HalamanDetailPengajuanKpiSaya.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/HalamanPengajuanKpiSaya.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/ParentTabKpiSaya.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiTeam/HalamanPengajuanKpiTeam.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiTeam/ParenTabkpiTeam.dart';
import 'package:absenkuv3/UI/Modul/Lembur/HalamanDetailLembur.dart';
import 'package:absenkuv3/UI/Modul/Lembur/HalamanPengajuanLembur.dart';
import 'package:absenkuv3/UI/Modul/Lembur/ParentTabLembur.dart';
import 'package:absenkuv3/UI/Modul/Lembur/ParentTabRekapLembur.dart';
import 'package:absenkuv3/UI/Modul/Login_SplashScreen/halamanLogin.dart';
import 'package:absenkuv3/UI/Modul/Login_SplashScreen/halamanSplashScreen.dart';
import 'package:absenkuv3/UI/Modul/MonitorAbsensi/ListMonitorAbsen/HalamanListIzinMonitor.dart';
import 'package:absenkuv3/UI/Modul/MonitorAbsensi/ListMonitorAbsen/HalamanListLemburMonitor.dart';
import 'package:absenkuv3/UI/Modul/MonitorAbsensi/ListMonitorAbsen/HalamanListMonitor.dart';
import 'package:absenkuv3/UI/Modul/MonitorAbsensi/ListMonitorAbsen/HalamanListMonitorAbsen.dart';
import 'package:absenkuv3/UI/Modul/Notif/HalamanListNotif.dart';
import 'package:absenkuv3/UI/Modul/Notif/HalamanNotifikasiAkun.dart';
import 'package:absenkuv3/UI/Modul/Pengumuman/HalamanDetailPengumuman.dart';
import 'package:absenkuv3/UI/Modul/Pkwt/HalamanDetailPkwtSaya.dart';
import 'package:absenkuv3/UI/Modul/Pkwt/HalamanListPkwtSaya.dart';
import 'package:absenkuv3/UI/Modul/Reimbursement/ParentTabReimbursement.dart';
import 'package:absenkuv3/UI/Modul/Reimbursement/ParentTabRekapReimbursement.dart';
import 'package:absenkuv3/UI/Modul/Reimbursement/halamanDetailReimbursement.dart';
import 'package:absenkuv3/UI/Modul/Reimbursement/halamanPengajuanReimbursement.dart';
import 'package:absenkuv3/UI/Modul/Reimbursement/halamanTambahItemPengajuanReimbursement.dart';
import 'package:absenkuv3/UI/Modul/Rekap/halamanRekapKaryawan.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/DailyActivity/halamanDailyActivity.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/DailyActivity/halamanDetailDailyActivity.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/DailyActivity/halamanDetailKanbanBoardActivity.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/DailyActivity/halamanEditAktivitasSales.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/halamanAddAktivitasSales.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/halamanDetailKanbanBoard.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Layanan/AddLayanan.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/halamanKambanBoard.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/halamanSalesActivity.dart';
import 'package:absenkuv3/UI/Modul/Shift/DetailListShiftKaryawan.dart';
import 'package:absenkuv3/UI/Modul/Shift/DetailListShiftTeman.dart';
import 'package:absenkuv3/UI/Modul/Shift/HalamanPengajuanTukarShift.dart';
import 'package:absenkuv3/UI/Modul/Shift/ParentTabShift.dart';
import 'package:absenkuv3/UI/Modul/SlipGaji/HalamanSlipGaji.dart';
import 'package:absenkuv3/UI/Modul/Sos/HalamanDetailSos.dart';
import 'package:absenkuv3/UI/Modul/Sos/HalamanListSos.dart';
import 'package:absenkuv3/UI/Modul/Sos/HalamanPengajuanSos.dart';
import 'package:absenkuv3/UI/Modul/TukarShift/Detail/DetailTukarShiftPengajuan.dart';
import 'package:absenkuv3/UI/Modul/TukarShift/ParentTabTukarShift.dart';
import 'package:absenkuv3/UI/ParentTabBeritaPengumuman.dart';
import 'package:absenkuv3/UI/Template/AutoComplete/Bloc/AutoCompletePerusahaanBloc.dart';
import 'package:absenkuv3/UI/Template/Camera/Bloc/CameraBloc.dart';
import 'package:absenkuv3/UI/Template/Camera/UI/HalamanCamera.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerMulaiBloc.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerSelesaiBloc.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerTglKawinBloc.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerTglLahirBloc.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/TemplateTimePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerRekapBloc.dart'
    as month;
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePicker2Bloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePicker3Bloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePickerBloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/detailImageClicked.dart';
import 'package:absenkuv3/UI/Template/halamanDetailMap.dart';
import 'package:absenkuv3/UI/parentTab.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../Bloc/Reimbursement/CekakunReimbursementBloc.dart';
import '../Bloc/Shift/TukarShiftDetailBloc.dart';
import '../UI/Template/CameraX/Bloc/FaceXBloc.dart';

const String homeRoute = '/';
const String tukarShiftReplaceRoute = '/tukar_shift_replace';
const String loginRoute = '/login';
const String loginSsoRoute = '/login_sso';
const String absensiRoute = '/absensi';
const String absensiReplaceRoute = '/absensi_replace';
const String splashscreenRoute = 'splash_screen';
const String listIzin = '/list_izin';
const String listRekapIzin = '/list_rekap_izin';
const String izinDetail = '/detail_izin';
const String pengajuanIzin = '/pengajuan_izin';
const String listLembur = '/list_lembur';
const String listRekapLembur = '/list_rekap_lembur';
const String lemburDetail = '/detail_lembur';
const String pengajuanLembur = '/pengajuan_lembur';
const String detailImageClicked = '/detail_image_clicked';
const String detailImageClickedAkun = '/detail_image_clicked_akun';
const String listAbsensi = '/list_absensi';
const String detailAbsensi = '/detail_absensi';
const String pengajuanAktivitas = '/pengajuan_aktivitas';
const String listAktivitas = '/list_aktivitas';
const String aktivitasDetail = '/detail_aktivitas';
const String listBerita = '/list_berita';
const String beritaDetail = '/detail_berita';
const String pengumumanDetail = '/detail_pengumuman';
const String halamanShift = '/parent_shift';
const String halamanTukarShift = '/parent_tukar_shift';
// const String halamanDetailShiftTeman = '/detail_shift_teman';
// const String halamanDetailShiftKaryawan = '/detail_shift_karyawan';
const String halamanInfoGaji = '/info_gaji';
const String halamanSlipGaji = '/slip_gaji';
// const String halamanPengajuanTukarShift = '/pengajuan_tukar_shift';
const String halamanDetailTukarShift = '/detail_tukar_shift';
const String ubahPassword = '/ubah_password';
const String akun = '/akun';
const String cameraApp = '/camera_app';
const String halamanMainReimbursement = '/main_reimbursement';
const String halamanDetailReimbursement = '/detail_reimbursement';
const String halamanPengajuanReimbursement = '/pengajuan_reimbursement';
const String halamanTambahItemPengajuanReimbursement =
    '/tambah_item_pengajuan_reimbursement';
const String halamanEditItemPengajuanReimbursement =
    '/edit_item_pengajuan_reimbursement';
const String halamanMainRekapReimbursement = '/main_rekap_reimbursement';
const String faceAuth = '/face_auth';
const String faceRecognition = '/face_recognition';
const String faceRegistration = '/face_registration';
const String rekapKaryawan = '/rekap_karyawan';
const String detailMap = '/detail_map';
const String listNotif = '/list_notif';

const String datadiri = '/datadiri';
const String editdatadiri = '/editdatadiri';
const String editDataPengajuanDataDiri = '/edit_pengajuan_data_diri';

const String dataKeluarga = '/data_keluarga';
const String addDataKeluarga = '/adddatakeluarga';
const String editDataKeluarga = '/editdatakeluarga';
const String editPengajuanDataKeluarga = '/editpengajuandatakeluarga';

const String dataPendidikan = '/data_pendidikan';
const String addDataPendidikan = '/add_data_pendidikan';
const String editDataPendidikan = '/edit_data_pendidikan';
const String editPengajuanDataPendidikan = '/edit_pengajuan_data_pendidikan';

const String dataKelengkapanFile = '/data_kelengkapan_file';
const String addDataKelengkapanFile = '/add_data_kelengkapan_file';
const String editDataKelengkapanFile = '/edit_data_kelengkapan_file';
const String editPengajuanDataKelengkapanFile =
    '/edit_pengajuan_data_kelengkapan_file';

const String dataPengalamanKerja = '/data_pengalaman_kerja';
const String addDataPengalamanKerja = '/add_data_pengalaman_kerja';
const String editDataPengalamanKerja = '/edit_data_pengalaman_kerja';
const String editPengajuanDataPengalamanKerja =
    '/edit_pengajuan_data_pengalaman_kerja';

const String notifikasiAkun = '/notifikasi_akun';
const String halamanDetailDataDiri = '/detail_data_diri';
const String halamanDetailDataKeluarga = '/detail_data_keluarga';
const String halamanDetailDataPendidikan = '/detail_data_pendidikan';
const String halamanDetailDataPengalamanKerja = '/detail_data_pengalaman_kerja';
const String halamanDetailDataKelengkapanFile = '/detail_data_kelengkapan_file';

const String halamanListMonitorAbsen = '/list_monitor_absen';
const String halamanListMonitor = '/list_monitor';
const String halamanListIzinMonitor = '/list_monitor_izin';
const String halamanListLemburMonitor = '/list_monitor_lembur';
const String halamanListKontakPegawai = '/list_kontak_pegawai';
const String halamanDetailKontakPegawai = '/detail_kontak_pegawai';
const String halamanSalesActivity = '/sales_activity_page';
const String halamanKambanBoardSalesActivity =
    '/kamban_board_sales_activity_page';
const String halamanAddLayanan = '/add_layanan_kamban';
const String halamanDetailSalesActivity = '/detail_sales_activity';
const String halamanDetailKanbanActivity = '/detail_kanban_activity';
const String halamanAddSalesActivityPage = '/add_sales_activity';
const String halamanEditSalesActivityPage = '/edit_sales_activity';
const String halamanDailySalesActivity = '/daily_sales_activity';
const String halamanDetailDailySalesActivity = '/detail_daily_sales_activity';
const String halamanCuti = '/cuti';
const String listHistoryCuti = '/list_history_cuti';

const String halamanKpi = '/kpi';
const String parentTabKpiTeam = '/parent_tab_kpi_team';
const String parentTabKpiSaya = '/parent_tab_kpi_saya';
const String parentTabKpiApprovalTeam = '/parent_tab_kpi_approval_team';
const String halamanPengajuanKpiTeam = '/halaman_pengajuan_kpi_team';
const String halamanPengajuanKpiSaya = '/halaman_pengajuan_kpi_saya';
const String halamanPengajuanKpiApprovalTeam =
    '/halaman_pengajuan_kpi_approval_team';
const String halamanDetailPengajuanKpiSaya =
    '/halaman_detail_pengajuan_kpi_saya';
const String halamanDetailApprovedKpi = '/halaman_detail_approval_kpi';
const String halamanDetailApprovalKpiSaya = '/halaman_detail_approval_kpi_saya';
const String halamanDetailDiterimaKpiSaya = '/halaman_detail_diterima_kpi_saya';
const String patroliDetail = '/detail_patroli';
const String patroli = '/patroli';
const String pengajuanSos = '/pengajuan_sos';
const String halamanlistSos = '/halaman_list_sos';
const String halamanDetailSos = '/halaman_detail_sos';
//PKWT
const String listPkwtSaya = '/list_pkwt_saya';
const String listPkwtSayaReplace = '/list_pkwt_saya_replace';
const String detailPkwtSaya = '/detail_pkwt_saya';
const String detailPkwtSayaReplace = '/detail_pkwt_saya_replace';

//END PKWT
class RouterGenerator {
  static Route<dynamic> generateRoute(RouteSettings settings) {
    switch (settings.name) {
      case homeRoute: //HALAMAN BERANDA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DashboardBloc>(
              create: (context) {
                return DashboardBloc(GetProgress());
              },
            ),
            BlocProvider<NavbarBloc>(
              create: (context) {
                return NavbarBloc(0);
              },
            ),
            BlocProvider<BadgeNotificationDashboardBloc>(
              create: (context) {
                return BadgeNotificationDashboardBloc(
                    GetBadgeNotificationDashboardProgress());
              },
            ),
            BlocProvider<PengaturanBloc>(create: (context) {
              return PengaturanBloc(GetProgressPengaturan());
            }),
            BlocProvider<badgeNotif.BadgeNotifBloc>(
              create: (context) {
                return badgeNotif.BadgeNotifBloc(badgeNotif.GetProgress());
              },
            ),
            BlocProvider<NotifikasiAkunBloc>(
              create: (context) {
                return NotifikasiAkunBloc(NotifikasiAkunProgressState());
              },
            ),

            /*BlocProvider<MonthPickerBloc>(
              create: (context) {
                return MonthPickerBloc();
              },
            ),*/
          ], child: ParentTab()),
        );
      case loginRoute: //HALAMAN LOGIN
        return MaterialPageRoute(
          builder: (context) => HalamanLogin(),
        );
      case loginSsoRoute: //HALAMAN LOGIN
        return MaterialPageRoute(
          builder: (context) => HalamanLoginSSO(),
        );
      case absensiRoute: //HALAMAN ABSENSI
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<AbsensiBloc>(
              create: (context) {
                return AbsensiBloc(AbsensiLoading());
              },
            ),
            BlocProvider<FaceXBloc>(
              create: (context) {
                return FaceXBloc(regisState());
              },
            ),
          ], child: HalamanAbsensi()),
        );
      case absensiReplaceRoute: //HALAMAN ABSENSI REPLACE
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<AbsensiBloc>(
              create: (context) {
                return AbsensiBloc(AbsensiLoading());
              },
            ),
            BlocProvider<ShiftV2Bloc>(
              create: (context) {
                return ShiftV2Bloc(ShiftProgressV2State());
              },
            ),
            BlocProvider<PilihShiftV2Bloc>(
              create: (context) {
                return PilihShiftV2Bloc(DataShiftProgress());
              },
            ),
            BlocProvider<FaceXBloc>(
              create: (context) {
                return FaceXBloc(regisState());
              },
            ),
          ], child: HalamanAbsensi()),
        );

      case listNotif: //HALAMAN REKAP IZIN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<NotifBloc>(
              create: (context) {
                return NotifBloc(ProgressNotifState());
              },
            ),
            BlocProvider<badgeNotif.BadgeNotifBloc>(
              create: (context) {
                return badgeNotif.BadgeNotifBloc(badgeNotif.GetProgress());
              },
            ),
          ], child: HalamanListNotif()),
        );
      case tukarShiftReplaceRoute: //HALAMAN ABSENSI
        return MaterialPageRoute(
            builder: (context) => MultiBlocProvider(providers: [
                  BlocProvider<badgeShift.BadgeShiftBloc>(
                    create: (context) {
                      return badgeShift.BadgeShiftBloc(
                          badgeShift.GetProgress());
                    },
                  ),
                ], child: ParentTabTukarShift(settings.arguments as String))
            // builder: (context) => ParentTabTukarShift(),
            );
      case splashscreenRoute: //HALAMAN SPLASHSCREEN
        return MaterialPageRoute(builder: (_) => HalamanSplashScreen());
      case listIzin: //HALAMAN LIST IZIN
        return MaterialPageRoute(
          builder: (context) => ParentTabIzin(),
        );
      case listRekapIzin: //HALAMAN REKAP IZIN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<rekapIzinSayaBloc.RekapIzinSayaBloc>(
              create: (context) {
                return rekapIzinSayaBloc.RekapIzinSayaBloc(
                    rekapIzinSayaBloc.RekapIzinProgressState());
              },
            ),
            BlocProvider<RekapIzinPegawaiBloc>(
              create: (context) {
                return RekapIzinPegawaiBloc(RekapIzinProgressState());
              },
            ),
          ], child: ParentTabRekapIzin()),
        );
      case pengajuanIzin: //HALAMAN PENGAJUAN IZIN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DatePickerMulaiBloc>(
              create: (context) {
                return DatePickerMulaiBloc(DateTime.now());
              },
            ),
            BlocProvider<DatePickerSelesaiBloc>(
              create: (context) {
                return DatePickerSelesaiBloc(DateTime.now());
              },
            ),
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
            BlocProvider<dropdownJenisIzin.DropdownJenisIzinBloc>(
              create: (context) {
                return dropdownJenisIzin.DropdownJenisIzinBloc(
                    dropdownJenisIzin.DropdownProgressState());
              },
            ),
            BlocProvider<SisaCutiBloc>(
              create: (context) {
                return SisaCutiBloc(SisaCutiProgress());
              },
            ),
            BlocProvider<JumlahIzinBloc>(
              create: (context) {
                return JumlahIzinBloc(JumlahIzinError());
              },
            ),
          ], child: HalamanPengajuanIzin()),
        );

      case detailImageClicked: //HALAMAN DETAIL IMAGE CLICKED
        return MaterialPageRoute(
          builder: (context) =>
              DetailImageClicked(settings.arguments as String?),
        );
      case detailImageClickedAkun: //HALAMAN DETAIL IMAGE CLICKED
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
          ], child: DetailImageClickedAkun(settings.arguments as String?)),
        );
      case izinDetail: //HALAMAN IZIN DETAIL
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DetailIzinBloc>(
              create: (context) {
                return DetailIzinBloc(DetailIzinProgress());
              },
            ),
            BlocProvider<NotifBloc>(
              create: (context) {
                return NotifBloc(ProgressNotifState());
              },
            ),
          ], child: HalamanDetailIzin(settings.arguments)),
        );
      case listAbsensi: //HALAMAN DATA ABSENSI
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DataAbsensiBloc>(
              create: (context) {
                return DataAbsensiBloc(DataAbsensiProgressState());
              },
            ),
            BlocProvider<DataAbsensiPegawaiBloc>(
              create: (context) {
                return DataAbsensiPegawaiBloc(
                    DataAbsensiPegawaiProgressState());
              },
            ),
          ], child: ParentTabDataAbsensi()),
        );
      case detailAbsensi: // HALAMAN DETAIL LIST ABSENSI
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(
              providers: [
                BlocProvider<DataDetailAbsensiBloc>(
                  create: (context) {
                    return DataDetailAbsensiBloc(
                        DataDetailAbsensiProgressState());
                  },
                ),
              ],
              child:
                  HalamanDetailListAbsensi(settings.arguments as List<String>)),
        );
      case listLembur: //HALAMAN LIST LEMBUR
        return MaterialPageRoute(
          builder: (context) => ParentTabLembur(),
        );
      case listRekapLembur: //HALAMAN REKAP LEMBUR
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<rekapLemburSayaBloc.RekapLemburSayaBloc>(
              create: (context) {
                return rekapLemburSayaBloc.RekapLemburSayaBloc(
                    rekapLemburSayaBloc.LemburProgressState());
              },
            ),
            BlocProvider<RekapLemburPegawaiBloc>(
              create: (context) {
                return RekapLemburPegawaiBloc(LemburProgressState());
              },
            ),
          ], child: ParentTabRekapLembur()),
        );
      case pengajuanLembur: //HALAMAN PENGAJUAN LEMBUR
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<AbsensiLemburBloc>(
              create: (context) {
                return AbsensiLemburBloc(AbsensiLemburLoading());
              },
            ),
            BlocProvider<FaceXBloc>(
              create: (context) {
                return FaceXBloc(regisState());
              },
            ),
          ], child: HalamanPengajuanLembur()),
        );
      case lemburDetail: //HALAMAN PENGAJUAN IZIN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DetailLemburBloc>(
              create: (context) {
                return DetailLemburBloc(DetailLemburProgress());
              },
            ),
            BlocProvider<NotifBloc>(
              create: (context) {
                return NotifBloc(ProgressNotifState());
              },
            ),
          ], child: HalamanDetailLembur(settings.arguments)),
        );
      case detailImageClicked: //HALAMAN DETAIL IMAGE CLICKED
        return MaterialPageRoute(
          builder: (context) =>
              DetailImageClicked(settings.arguments as String?),
        );
      case cameraApp: //HALAMAN CAMERA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<CameraBloc>(
              create: (context) {
                return CameraBloc(InitializeCameraProgress());
              },
            ),
          ], child: CameraApp(settings.arguments as String?, false)),
        );
      case pengajuanAktivitas: //HALAMAN PENGAJUAN AKTIVITAS
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<AbsensiAktivitasBloc>(
              create: (context) {
                return AbsensiAktivitasBloc(AbsensiAktivitasLoading());
              },
            ),
          ], child: HalamanPengajuanAktivitas()),
        );
      case listAktivitas: //HALAMAN LIST AKTIVITAS
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<NavbarBloc>(
              create: (context) {
                return NavbarBloc(0);
              },
            ),
          ], child: ParentTabAktivitas()),
        );
      case aktivitasDetail: //HALAMAN DETAIL AKTIVITAS
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DetailAktivitasBloc>(
              create: (context) {
                return DetailAktivitasBloc(DetailAktivitasProgress());
              },
            ),
          ], child: HalamanDetailAktivitas(settings.arguments as String?)),
        );
      case listBerita: //HALAMAN LIST AKTIVITAS
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<NavbarBloc>(
              create: (context) {
                return NavbarBloc(0);
              },
            ),
            BlocProvider<BeritaBloc>(
              create: (context) {
                return BeritaBloc(BeritaProgressState());
              },
            ),
            BlocProvider<PengumumanBloc>(
              create: (context) {
                return PengumumanBloc(PengumumanProgressState());
              },
            ),
          ], child: ParentTabBeritaPengumuman()),
        );
      case beritaDetail: //HALAMAN DETAIL BERITA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DetailBeritaBloc>(
              create: (context) {
                return DetailBeritaBloc(DetailBeritaProgress());
              },
            ),
            BlocProvider<NotifBloc>(
              create: (context) {
                return NotifBloc(ProgressNotifState());
              },
            ),
          ], child: HalamanDetailBerita(settings.arguments)),
        );
      case pengumumanDetail: //HALAMAN DETAIL PENGUMUMAN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DetailPengumumanBloc>(
              create: (context) {
                return DetailPengumumanBloc(DetailPengumumanProgress());
              },
            ),
            BlocProvider<NotifBloc>(
              create: (context) {
                return NotifBloc(ProgressNotifState());
              },
            ),
          ], child: HalamanDetailPengumuman(settings.arguments)),
        );
      case halamanShift: //HALAMAN SHIFT
        return MaterialPageRoute(
          builder: (context) => ParentTabShift(),
        );
      case halamanTukarShift: //HALAMAN TUKAR SHIFT
        return MaterialPageRoute(
          builder: (context) =>
              ParentTabTukarShift(settings.arguments as String?),
        );
      // case halamanDetailShiftTeman: //HALAMAN DETAIL IMAGE CLICKED
      //   return MaterialPageRoute(
      //     builder: (context) =>
      //         DetailListShiftTeman(settings.arguments as DataShift?),
      //   );
      // case halamanDetailShiftKaryawan: //HALAMAN DETAIL IMAGE CLICKED
      //   return MaterialPageRoute(
      //     builder: (context) =>
      //         DetailListShiftKaryawan(settings.arguments as DataShift?),
      //   );
      // case halamanPengajuanTukarShift: //HALAMAN DETAIL IMAGE CLICKED
      //   return MaterialPageRoute(
      //     builder: (context) =>
      //         HalamanPengajuanTukarShift(settings.arguments as String?),
      //   );
      case halamanDetailTukarShift:
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<TukarShiftDetailBloc>(
              create: (context) {
                return TukarShiftDetailBloc(TukarShiftDetailProgressState());
              },
            ),
            BlocProvider<NotifBloc>(
              create: (context) {
                return NotifBloc(ProgressNotifState());
              },
            )
          ], child: HalamanDetailTukarShiftPengajuanSaya(settings.arguments)),
        );
      case halamanInfoGaji: //HALAMAN INFO GAJI
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<GajiBloc>(
              create: (context) {
                return GajiBloc(GajiProgressState());
              },
            ),
          ], child: HalamanGaji()),
        );
      case halamanSlipGaji: //HALAMAN INFO GAJI
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<SlipGajiBloc>(
              create: (context) {
                return SlipGajiBloc(SlipGajiProgressState());
              },
            ),
            BlocProvider<NotifBloc>(
              create: (context) {
                return NotifBloc(ProgressNotifState());
              },
            ),
          ], child: HalamanSlipGaji(settings.arguments)),
        );
      case halamanMainReimbursement: //HALAMAN REIMBURSEMENT
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<CekAkunReimbursementBloc>(
              create: (context) {
                return CekAkunReimbursementBloc(
                    CekAkunReimbursementProgressState());
              },
            ),
            BlocProvider<PageReimbursementBloc>(
              create: (context) {
                return PageReimbursementBloc(PageReimbursementGetProgress());
              },
            ),
          ], child: ParentTabReimbursement()),
        );

      case halamanMainRekapReimbursement: //HALAMAN REIMBURSEMENT
        return MaterialPageRoute(
          builder: (context) => ParentTabRekapReimbursement(),
        );
      case halamanDetailReimbursement: //HALAMAN REIMBURSEMENT
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<reimbursementDetailBloc.ReimbursementDetailBloc>(
              create: (context) {
                return reimbursementDetailBloc.ReimbursementDetailBloc(
                    reimbursementDetailBloc.ReimbursementProgressState());
              },
            ),
          ], child: HalamanDetailReimbursement(settings.arguments)),
        );
      case halamanPengajuanReimbursement: //HALAMAN REIMBURSEMENT
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<ReimbursementSayaBloc>(
              create: (context) {
                return ReimbursementSayaBloc(ReimbursementProgressState());
              },
            ),
            BlocProvider<reimbursementItemBloc.ReimbursementItemBloc>(
              create: (context) {
                return reimbursementItemBloc.ReimbursementItemBloc(
                    reimbursementItemBloc.ReimbursementProgressState());
              },
            ),
            BlocProvider<PageReimbursementBloc>(
              create: (context) {
                return PageReimbursementBloc(PageReimbursementGetProgress());
              },
            ),
          ], child: HalamanPengajuanReimbursement()),
        );
      case halamanTambahItemPengajuanReimbursement: //HALAMAN REIMBURSEMENT
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(
              providers: [
                BlocProvider<reimbursementItemBloc.ReimbursementItemBloc>(
                  create: (context) {
                    return reimbursementItemBloc.ReimbursementItemBloc(
                        reimbursementItemBloc.ReimbursementProgressState());
                  },
                ),
                BlocProvider<DatePickerMulaiBloc>(
                  create: (context) {
                    return DatePickerMulaiBloc(DateTime.now());
                  },
                ),
                BlocProvider<MultiImagePickerBloc>(
                  create: (context) {
                    return MultiImagePickerBloc(MultiImageProgressState());
                  },
                ),
              ],
              child: HalamanTambahItemPengajuanReimbursement(
                  settings.arguments as DataItem?)),
        );
      case halamanEditItemPengajuanReimbursement: //HALAMAN REIMBURSEMENT
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(
              providers: [
                BlocProvider<reimbursementItemBloc.ReimbursementItemBloc>(
                  create: (context) {
                    return reimbursementItemBloc.ReimbursementItemBloc(
                        reimbursementItemBloc.ReimbursementProgressState());
                  },
                ),
                BlocProvider<DatePickerMulaiBloc>(
                  create: (context) {
                    return DatePickerMulaiBloc(DateTime.now());
                  },
                ),
                BlocProvider<MultiImagePickerBloc>(
                  create: (context) {
                    return MultiImagePickerBloc(MultiImageProgressState());
                  },
                ),
              ],
              child: HalamanEditItemPengajuanReimbursement(
                  settings.arguments as ListItemTemp?)),
        );
      case ubahPassword: //HALAMAN UBAH PASSWORD
        return MaterialPageRoute(
          builder: (context) => HalamanUbahPassword(),
        );
      case detailMap: //HALAMAN UBAH PASSWORD
        return MaterialPageRoute(
            builder: (context) =>
                HalamanDetailMap(settings.arguments as ModelDetailMap));
      case akun: //HALAMAN AKUN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
            BlocProvider<StatusPengajuanDataBloc>(
              create: (context) {
                return StatusPengajuanDataBloc(
                    StatusPengajuanDataProgressState());
              },
            ),
            BlocProvider<NotifikasiAkunBloc>(
              create: (context) {
                return NotifikasiAkunBloc(NotifikasiAkunProgressState());
              },
            ),
          ], child: HalamanAkun()),
        );
      case rekapKaryawan: //HALAMAN REKAP LEMBUR
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<SummaryBloc>(
              create: (context) {
                return SummaryBloc(SummaryErrorState());
              },
            ),
          ], child: HalamanRekapKaryawan()),
        );

      case datadiri: //HALAMAN DATADIRI
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DataDiriBloc>(
              create: (context) {
                return DataDiriBloc(DataDiriProgressState());
              },
            ),
            BlocProvider<DataDiriEditBloc>(
              create: (context) {
                return DataDiriEditBloc(DataDiriEditProgressState());
              },
            ),
            BlocProvider<StatusPengajuanDataBloc>(
              create: (context) {
                return StatusPengajuanDataBloc(
                    StatusPengajuanDataProgressState());
              },
            ),
          ], child: ParentTabDataDiri(settings.arguments)),
        );
      case editdatadiri: //HALAMAN EDIT DATADIRI
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DataDiriEditBloc>(
              create: (context) {
                return DataDiriEditBloc(DataDiriEditProgressState());
              },
            ),
            BlocProvider<DatePickerTglLahirBloc>(
              create: (context) {
                return DatePickerTglLahirBloc(DateTime.now());
              },
            ),
            BlocProvider<DropdownPendidikanBloc>(
              create: (context) {
                return DropdownPendidikanBloc(
                    DropdownPendidikanProgressState());
              },
            ),
            BlocProvider<DropdownJenisKelaminBloc>(
              create: (context) {
                return DropdownJenisKelaminBloc(
                    DropdownJenisKelaminProgressState());
              },
            ),
            BlocProvider<DropdownGolonganDarahBloc>(
              create: (context) {
                return DropdownGolonganDarahBloc(
                    DropdownGolonganDarahProgressState());
              },
            ),
            BlocProvider<DropdownAgamaBloc>(
              create: (context) {
                return DropdownAgamaBloc(DropdownAgamaProgressState());
              },
            ),
            BlocProvider<DropdownProvinsiBloc>(
              create: (context) {
                return DropdownProvinsiBloc(DropdownProvinsiProgressState());
              },
            ),
            BlocProvider<DropdownKabupatenBloc>(
              create: (context) {
                return DropdownKabupatenBloc(DropdownKabupatenProgressState());
              },
            ),
            BlocProvider<DropdownKecamatanBloc>(
              create: (context) {
                return DropdownKecamatanBloc(DropdownKecamatanProgressState());
              },
            ),
            BlocProvider<DropdownKelurahanBloc>(
              create: (context) {
                return DropdownKelurahanBloc(DropdownKelurahanProgressState());
              },
            ),
          ], child: HalamanEditDataDiri()),
        );
      case editDataPengajuanDataDiri: //HALAMAN DATA PENGAJUAN EDIT DATA DIRI
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DataDiriEditBloc>(
              create: (context) {
                return DataDiriEditBloc(DataDiriEditProgressState());
              },
            ),
            BlocProvider<DatePickerTglLahirBloc>(
              create: (context) {
                return DatePickerTglLahirBloc(DateTime.now());
              },
            ),
            BlocProvider<DropdownPendidikanBloc>(
              create: (context) {
                return DropdownPendidikanBloc(
                    DropdownPendidikanProgressState());
              },
            ),
            BlocProvider<DropdownJenisKelaminBloc>(
              create: (context) {
                return DropdownJenisKelaminBloc(
                    DropdownJenisKelaminProgressState());
              },
            ),
            BlocProvider<DropdownGolonganDarahBloc>(
              create: (context) {
                return DropdownGolonganDarahBloc(
                    DropdownGolonganDarahProgressState());
              },
            ),
            BlocProvider<DropdownAgamaBloc>(
              create: (context) {
                return DropdownAgamaBloc(DropdownAgamaProgressState());
              },
            ),
            BlocProvider<DropdownProvinsiBloc>(
              create: (context) {
                return DropdownProvinsiBloc(DropdownProvinsiProgressState());
              },
            ),
            BlocProvider<DropdownKabupatenBloc>(
              create: (context) {
                return DropdownKabupatenBloc(DropdownKabupatenProgressState());
              },
            ),
            BlocProvider<DropdownKecamatanBloc>(
              create: (context) {
                return DropdownKecamatanBloc(DropdownKecamatanProgressState());
              },
            ),
            BlocProvider<DropdownKelurahanBloc>(
              create: (context) {
                return DropdownKelurahanBloc(DropdownKelurahanProgressState());
              },
            ),
          ], child: HalamanEditPengajuanDataDiri()),
        );
      case dataKeluarga: //HALAMAN DATA KELUARGA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DataKeluargaBloc>(
              create: (context) {
                return DataKeluargaBloc(DataKeluargaProgressState());
              },
            ),
            BlocProvider<StatusPengajuanDataBloc>(
              create: (context) {
                return StatusPengajuanDataBloc(
                    StatusPengajuanDataProgressState());
              },
            ),
          ], child: ParentTabDataKeluarga(settings.arguments)),
        );
      case addDataKeluarga: //HALAMAN EDIT DATA KELUARGA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DropdownHubunganBloc>(
              create: (context) {
                return DropdownHubunganBloc(DropdownHubunganProgressState());
              },
            ),
            BlocProvider<DatePickerTglLahirBloc>(
              create: (context) {
                return DatePickerTglLahirBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DropdownJenisKelaminBloc>(
              create: (context) {
                return DropdownJenisKelaminBloc(
                    DropdownJenisKelaminProgressState());
              },
            ),
            BlocProvider<DropdownAgamaBloc>(
              create: (context) {
                return DropdownAgamaBloc(DropdownAgamaProgressState());
              },
            ),
            BlocProvider<DropdownStatusPerkawinanBloc>(
              create: (context) {
                return DropdownStatusPerkawinanBloc(
                    DropdownStatusPerkawinanProgressState());
              },
            ),
            BlocProvider<DropdownPekerjaanBloc>(
              create: (context) {
                return DropdownPekerjaanBloc(DropdownPekerjaanProgressState());
              },
            ),
            BlocProvider<DatePickerTglKawinBloc>(
              create: (context) {
                return DatePickerTglKawinBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DropdownJenisStatusBloc>(
              create: (context) {
                return DropdownJenisStatusBloc(
                    DropdownJenisStatusProgressState());
              },
            ),
            BlocProvider<DropdownPendidikanBloc>(
              create: (context) {
                return DropdownPendidikanBloc(
                    DropdownPendidikanProgressState());
              },
            ),
            BlocProvider<DataKeluargaBloc>(
              create: (context) {
                return DataKeluargaBloc(DataKeluargaProgressState());
              },
            ),
          ], child: HalamanAddDataKeluarga(settings.arguments)),
        );
      case editPengajuanDataKeluarga: //HALAMAN EDIT PENGAJUAN DATA KELUARGA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DropdownHubunganBloc>(
              create: (context) {
                return DropdownHubunganBloc(DropdownHubunganProgressState());
              },
            ),
            BlocProvider<DatePickerTglLahirBloc>(
              create: (context) {
                return DatePickerTglLahirBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DropdownJenisKelaminBloc>(
              create: (context) {
                return DropdownJenisKelaminBloc(
                    DropdownJenisKelaminProgressState());
              },
            ),
            BlocProvider<DropdownAgamaBloc>(
              create: (context) {
                return DropdownAgamaBloc(DropdownAgamaProgressState());
              },
            ),
            BlocProvider<DropdownStatusPerkawinanBloc>(
              create: (context) {
                return DropdownStatusPerkawinanBloc(
                    DropdownStatusPerkawinanProgressState());
              },
            ),
            BlocProvider<DropdownPekerjaanBloc>(
              create: (context) {
                return DropdownPekerjaanBloc(DropdownPekerjaanProgressState());
              },
            ),
            BlocProvider<DatePickerTglKawinBloc>(
              create: (context) {
                return DatePickerTglKawinBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DropdownJenisStatusBloc>(
              create: (context) {
                return DropdownJenisStatusBloc(
                    DropdownJenisStatusProgressState());
              },
            ),
            BlocProvider<DropdownPendidikanBloc>(
              create: (context) {
                return DropdownPendidikanBloc(
                    DropdownPendidikanProgressState());
              },
            ),
            BlocProvider<DataKeluargaBloc>(
              create: (context) {
                return DataKeluargaBloc(DataKeluargaProgressState());
              },
            ),
          ], child: HalamanEditPengajuanDataKeluarga(settings.arguments)),
        );
      case editDataKeluarga: //HALAMAN EDIT DATA KELUARGA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DropdownHubunganBloc>(
              create: (context) {
                return DropdownHubunganBloc(DropdownHubunganProgressState());
              },
            ),
            BlocProvider<DatePickerTglLahirBloc>(
              create: (context) {
                return DatePickerTglLahirBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DropdownJenisKelaminBloc>(
              create: (context) {
                return DropdownJenisKelaminBloc(
                    DropdownJenisKelaminProgressState());
              },
            ),
            BlocProvider<DropdownAgamaBloc>(
              create: (context) {
                return DropdownAgamaBloc(DropdownAgamaProgressState());
              },
            ),
            BlocProvider<DropdownStatusPerkawinanBloc>(
              create: (context) {
                return DropdownStatusPerkawinanBloc(
                    DropdownStatusPerkawinanProgressState());
              },
            ),
            BlocProvider<DropdownPekerjaanBloc>(
              create: (context) {
                return DropdownPekerjaanBloc(DropdownPekerjaanProgressState());
              },
            ),
            BlocProvider<DatePickerTglKawinBloc>(
              create: (context) {
                return DatePickerTglKawinBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DropdownJenisStatusBloc>(
              create: (context) {
                return DropdownJenisStatusBloc(
                    DropdownJenisStatusProgressState());
              },
            ),
            BlocProvider<DropdownPendidikanBloc>(
              create: (context) {
                return DropdownPendidikanBloc(
                    DropdownPendidikanProgressState());
              },
            ),
            BlocProvider<DataKeluargaBloc>(
              create: (context) {
                return DataKeluargaBloc(DataKeluargaProgressState());
              },
            ),
          ], child: HalamanEditDataKeluarga(settings.arguments)),
        );
      // END DATA KELUARGA

      // BEGIN DATA PENDIDIKAN
      case dataPendidikan: //HALAMAN DATA PENDIDIKAN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DataPendidikanBloc>(
              create: (context) {
                return DataPendidikanBloc(DataPendidikanProgressState());
              },
            ),
            BlocProvider<StatusPengajuanDataBloc>(
              create: (context) {
                return StatusPengajuanDataBloc(
                    StatusPengajuanDataProgressState());
              },
            ),
          ], child: ParentTabDataPendidikan(settings.arguments)),
        );
      case addDataPendidikan: //HALAMAN TAMBAH DATA PENDIDIKAN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DropdownJenjangBloc>(
              create: (context) {
                return DropdownJenjangBloc(DropdownJenjangProgressState());
              },
            ),
            BlocProvider<DropdownAsalLulusanBloc>(
              create: (context) {
                return DropdownAsalLulusanBloc(
                    DropdownAsalLulusanProgressState());
              },
            ),
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
            BlocProvider<MultiImagePicker2Bloc>(
              create: (context) {
                return MultiImagePicker2Bloc(MultiImage2ProgressState());
              },
            ),
            BlocProvider<DatePickerTglKawinBloc>(
              create: (context) {
                return DatePickerTglKawinBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DataPendidikanBloc>(
              create: (context) {
                return DataPendidikanBloc(DataPendidikanProgressState());
              },
            ),
          ], child: HalamanAddDataPendidikan()),
        );
      case editPengajuanDataPendidikan: //HALAMAN EDIT PENGAJUAN DATA PENDIDIKAN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DropdownJenjangBloc>(
              create: (context) {
                return DropdownJenjangBloc(DropdownJenjangProgressState());
              },
            ),
            BlocProvider<DropdownAsalLulusanBloc>(
              create: (context) {
                return DropdownAsalLulusanBloc(
                    DropdownAsalLulusanProgressState());
              },
            ),
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
            BlocProvider<MultiImagePicker2Bloc>(
              create: (context) {
                return MultiImagePicker2Bloc(MultiImage2ProgressState());
              },
            ),
            BlocProvider<DatePickerTglKawinBloc>(
              create: (context) {
                return DatePickerTglKawinBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DataPendidikanBloc>(
              create: (context) {
                return DataPendidikanBloc(DataPendidikanProgressState());
              },
            ),
          ], child: HalamanEditPengajuanDataPendidikan(settings.arguments)),
        );
      case editDataPendidikan: //HALAMAN EDIT DATA PENDIDIKAN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DropdownJenjangBloc>(
              create: (context) {
                return DropdownJenjangBloc(DropdownJenjangProgressState());
              },
            ),
            BlocProvider<DropdownAsalLulusanBloc>(
              create: (context) {
                return DropdownAsalLulusanBloc(
                    DropdownAsalLulusanProgressState());
              },
            ),
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
            BlocProvider<MultiImagePicker2Bloc>(
              create: (context) {
                return MultiImagePicker2Bloc(MultiImage2ProgressState());
              },
            ),
            BlocProvider<DatePickerTglKawinBloc>(
              create: (context) {
                return DatePickerTglKawinBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DataPendidikanBloc>(
              create: (context) {
                return DataPendidikanBloc(DataPendidikanProgressState());
              },
            ),
          ], child: HalamanEditDataPendidikan(settings.arguments)),
        );
      // END DATA PENDIDIKAN

      // BEGIN DATA KELENGKAPAN FILE
      case dataKelengkapanFile: //HALAMAN DATA KELENGKAPAN FILE
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<KelengkapanFileBloc>(
              create: (context) {
                return KelengkapanFileBloc(KelengkapanFileProgressState());
              },
            ),
            BlocProvider<StatusPengajuanDataBloc>(
              create: (context) {
                return StatusPengajuanDataBloc(
                    StatusPengajuanDataProgressState());
              },
            ),
          ], child: ParentTabKelengkapanFile(settings.arguments)),
        );
      case addDataKelengkapanFile: //HALAMAN TAMBAH DATA KELENGKAPAN FILE
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
            BlocProvider<KelengkapanFileBloc>(
              create: (context) {
                return KelengkapanFileBloc(KelengkapanFileProgressState());
              },
            ),
          ], child: HalamanAddDataKelengkapanFile(settings.arguments)),
        );
      case editPengajuanDataKelengkapanFile: //HALAMAN EDIT PENGAJUAN DATA KELENGKAPAN FILE
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(
              providers: [
                BlocProvider<MultiImagePickerBloc>(
                  create: (context) {
                    return MultiImagePickerBloc(MultiImageProgressState());
                  },
                ),
                BlocProvider<KelengkapanFileBloc>(
                  create: (context) {
                    return KelengkapanFileBloc(KelengkapanFileProgressState());
                  },
                ),
              ],
              child:
                  HalamanEditPengajuanDataKelengkapanFile(settings.arguments)),
        );
      case editDataKelengkapanFile: //HALAMAN EDIT PENGAJUAN DATA KELENGKAPAN FILE
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
            BlocProvider<KelengkapanFileBloc>(
              create: (context) {
                return KelengkapanFileBloc(KelengkapanFileProgressState());
              },
            ),
          ], child: HalamanEditDataKelengkapanFile(settings.arguments)),
        );
      // END KELENGKAPAN FILE

      // BEGIN PENGALAMAN KERJA
      case dataPengalamanKerja: //HALAMAN DATA PENGALAMAN KERJA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DataPengalamanKerjaBloc>(
              create: (context) {
                return DataPengalamanKerjaBloc(
                    DataPengalamanKerjaProgressState());
              },
            ),
            BlocProvider<StatusPengajuanDataBloc>(
              create: (context) {
                return StatusPengajuanDataBloc(
                    StatusPengajuanDataProgressState());
              },
            ),
          ], child: ParentTabDataPengalamanKerja(settings.arguments)),
        );
      case addDataPengalamanKerja: //HALAMAN TAMBAH DATA PENGALAMAN KERJA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DatePickerTglKawinBloc>(
              create: (context) {
                return DatePickerTglKawinBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DropdownProvinsiBloc>(
              create: (context) {
                return DropdownProvinsiBloc(DropdownProvinsiProgressState());
              },
            ),
            BlocProvider<DropdownKabupatenBloc>(
              create: (context) {
                return DropdownKabupatenBloc(DropdownKabupatenProgressState());
              },
            ),
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
            BlocProvider<DatePickerTglLahirBloc>(
              create: (context) {
                return DatePickerTglLahirBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DataPengalamanKerjaBloc>(
              create: (context) {
                return DataPengalamanKerjaBloc(
                    DataPengalamanKerjaProgressState());
              },
            ),
          ], child: HalamanAddDataPengalamanKerja()),
        );
      case editPengajuanDataPengalamanKerja: //HALAMAN EDIT PENGAJUAN DATA PENGALAMAN KERJA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(
              providers: [
                BlocProvider<DatePickerTglKawinBloc>(
                  create: (context) {
                    return DatePickerTglKawinBloc(DateTime(0001, 01, 01));
                  },
                ),
                BlocProvider<DropdownProvinsiBloc>(
                  create: (context) {
                    return DropdownProvinsiBloc(
                        DropdownProvinsiProgressState());
                  },
                ),
                BlocProvider<DropdownKabupatenBloc>(
                  create: (context) {
                    return DropdownKabupatenBloc(
                        DropdownKabupatenProgressState());
                  },
                ),
                BlocProvider<MultiImagePickerBloc>(
                  create: (context) {
                    return MultiImagePickerBloc(MultiImageProgressState());
                  },
                ),
                BlocProvider<DatePickerTglLahirBloc>(
                  create: (context) {
                    return DatePickerTglLahirBloc(DateTime(0001, 01, 01));
                  },
                ),
                BlocProvider<DataPengalamanKerjaBloc>(
                  create: (context) {
                    return DataPengalamanKerjaBloc(
                        DataPengalamanKerjaProgressState());
                  },
                ),
              ],
              child:
                  HalamanEditPengajuanDataPengalamanKerja(settings.arguments)),
        );
      case editDataPengalamanKerja: //HALAMAN EDIT DATA PENGALAMAN KERJA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DatePickerTglKawinBloc>(
              create: (context) {
                return DatePickerTglKawinBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DropdownProvinsiBloc>(
              create: (context) {
                return DropdownProvinsiBloc(DropdownProvinsiProgressState());
              },
            ),
            BlocProvider<DropdownKabupatenBloc>(
              create: (context) {
                return DropdownKabupatenBloc(DropdownKabupatenProgressState());
              },
            ),
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
            BlocProvider<DatePickerTglLahirBloc>(
              create: (context) {
                return DatePickerTglLahirBloc(DateTime(0001, 01, 01));
              },
            ),
            BlocProvider<DataPengalamanKerjaBloc>(
              create: (context) {
                return DataPengalamanKerjaBloc(
                    DataPengalamanKerjaProgressState());
              },
            ),
          ], child: HalamanEditDataPengalamanKerja(settings.arguments)),
        );

      case notifikasiAkun: //HALAMAN NOTIFIKASI AKUN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<NotifikasiAkunBloc>(
              create: (context) {
                return NotifikasiAkunBloc(NotifikasiAkunProgressState());
              },
            ),
          ], child: HalamanNotifikasiAkun()),
        );
      case halamanDetailDataDiri: //HALAMAN DETAIL NOTIFIKASI DATA DIRI
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(
              providers: [
                BlocProvider<DataDiriBloc>(
                  create: (context) {
                    return DataDiriBloc(DataDiriProgressState());
                  },
                ),
                BlocProvider<NotifBloc>(
                  create: (context) {
                    return NotifBloc(ProgressNotifState());
                  },
                ),
              ],
              child: HalamanDetailNotifikasiDataDiri(
                  settings.arguments as DataNotifikasiAkun)),
        );
      case halamanDetailDataKeluarga: //HALAMAN DETAIL NOTIFIKASI DATA KELUARGA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(
              providers: [
                BlocProvider<DataKeluargaBloc>(
                  create: (context) {
                    return DataKeluargaBloc(DataKeluargaProgressState());
                  },
                ),
                BlocProvider<NotifBloc>(
                  create: (context) {
                    return NotifBloc(ProgressNotifState());
                  },
                ),
              ],
              child: HalamanDetailNotifikasiDataKeluarga(
                  settings.arguments as DataNotifikasiAkun)),
        );
      case halamanDetailDataPendidikan: //HALAMAN DETAIL NOTIFIKASI DATA PENDIDIKAN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(
              providers: [
                BlocProvider<DataPendidikanBloc>(
                  create: (context) {
                    return DataPendidikanBloc(DataPendidikanProgressState());
                  },
                ),
                BlocProvider<NotifBloc>(
                  create: (context) {
                    return NotifBloc(ProgressNotifState());
                  },
                ),
              ],
              child: HalamanDetailNotifikasiDataPendidikan(
                  settings.arguments as DataNotifikasiAkun)),
        );
      case halamanDetailDataPengalamanKerja: //HALAMAN DETAIL NOTIFIKASI DATA PENGALAMAN KERJA
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(
              providers: [
                BlocProvider<DataPengalamanKerjaBloc>(
                  create: (context) {
                    return DataPengalamanKerjaBloc(
                        DataPengalamanKerjaProgressState());
                  },
                ),
                BlocProvider<NotifBloc>(
                  create: (context) {
                    return NotifBloc(ProgressNotifState());
                  },
                ),
              ],
              child: HalamanDetailNotifikasiDataPengalamanKerja(
                  settings.arguments as DataNotifikasiAkun)),
        );
      case halamanDetailDataKelengkapanFile: //HALAMAN DETAIL NOTIFIKASI DATA KELENGKAPAN FILE
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(
              providers: [
                BlocProvider<KelengkapanFileBloc>(
                  create: (context) {
                    return KelengkapanFileBloc(KelengkapanFileProgressState());
                  },
                ),
                BlocProvider<NotifBloc>(
                  create: (context) {
                    return NotifBloc(ProgressNotifState());
                  },
                ),
              ],
              child: HalamanDetailNotifikasiKelengkapanFile(
                  settings.arguments as DataNotifikasiAkun)),
        );
      case halamanListMonitorAbsen:
        return MaterialPageRoute(
          builder: (context) => HalamanListMonitorAbsensi(settings.arguments),
        );

      case halamanListIzinMonitor:
        return MaterialPageRoute(
          builder: (context) => HalamanListIzinMonitor(settings.arguments),
        );
      case halamanListLemburMonitor:
        return MaterialPageRoute(
          builder: (context) => HalamanListLemburMonitor(settings.arguments),
        );
      case halamanListMonitor:
        return MaterialPageRoute(
          builder: (context) => HalamanListMonitor(settings.arguments),
        );
      case halamanListKontakPegawai: //HALAMAN LIST IZIN
        return MaterialPageRoute(
            builder: (context) => MultiBlocProvider(
                  providers: [
                    BlocProvider<KontakPegawaiBloc>(
                      create: (context) {
                        return KontakPegawaiBloc(KontakPegawaiProgressState());
                      },
                    ),
                  ],
                  child: HalamanListKontakPegawai(),
                ));
      case halamanDetailKontakPegawai: //HALAMAN LIST IZIN
        return MaterialPageRoute(
          builder: (context) => HalamanDetailKontakPegawai(settings.arguments),
        );

      case halamanSalesActivity:
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(
            providers: [
              BlocProvider<TargetSalesBloc>(
                create: (context) {
                  return TargetSalesBloc(TargetSalesProgressState());
                },
              ),
            ],
            child: HalamanSalesActivity(),
          ),
        );
      case halamanKambanBoardSalesActivity:
        return MaterialPageRoute(
            builder: (context) => MultiBlocProvider(
                  providers: [
                    BlocProvider<month.MonthPickerRekapBloc>(
                      create: (context) {
                        return month.MonthPickerRekapBloc(
                            month.MonthPickerProgressRekapState());
                      },
                    ),
                    BlocProvider<TahapanBloc>(
                      create: (context) {
                        return TahapanBloc(TahapanProgressState());
                      },
                    ),
                    BlocProvider<KambanBloc>(
                      create: (context) {
                        return KambanBloc(KambanProgressState());
                      },
                    ),
                    BlocProvider<TotalKambanBloc>(
                      create: (context) {
                        return TotalKambanBloc(TotalKambanProgressState());
                      },
                    ),
                  ],
                  child: HalamanKambanBoard(),
                ));
      case halamanAddLayanan:
        return MaterialPageRoute(
            builder: (context) => MultiBlocProvider(
                  providers: [
                    BlocProvider<DropdownProdukLayananBloc>(
                      create: (context) {
                        return DropdownProdukLayananBloc(
                            DropdownProdukLayananProgressState());
                      },
                    ),
                    BlocProvider<LayananDraftBloc>(
                      create: (context) {
                        return LayananDraftBloc(LayananDraftProgressState());
                      },
                    ),
                    BlocProvider<StepperBloc>(
                      create: (context) {
                        return StepperBloc(0);
                      },
                    ),
                    BlocProvider<DropdownLeadMasterBloc>(
                      create: (context) {
                        return DropdownLeadMasterBloc(
                            DropdownLeadMasterProgressState());
                      },
                    ),
                    BlocProvider<DropdownSalesBawahanBloc>(
                      create: (context) {
                        return DropdownSalesBawahanBloc(
                            DropdownSalesBawahanProgressState());
                      },
                    ),
                    BlocProvider<DropdownJenisPerusahaanBloc>(
                      create: (context) {
                        return DropdownJenisPerusahaanBloc(
                            DropdownJenisPerusahaanProgressState());
                      },
                    ),
                    BlocProvider<DropdownProvinsiBloc>(
                      create: (context) {
                        return DropdownProvinsiBloc(
                            DropdownProvinsiProgressState());
                      },
                    ),
                    BlocProvider<DropdownKabupatenBloc>(
                      create: (context) {
                        return DropdownKabupatenBloc(
                            DropdownKabupatenProgressState());
                      },
                    ),
                    BlocProvider<DropdownKecamatanBloc>(
                      create: (context) {
                        return DropdownKecamatanBloc(
                            DropdownKecamatanProgressState());
                      },
                    ),
                    BlocProvider<DropdownKelurahanBloc>(
                      create: (context) {
                        return DropdownKelurahanBloc(
                            DropdownKelurahanProgressState());
                      },
                    ),
                    BlocProvider<AutoCompletePerusahaanBloc>(
                      create: (context) {
                        return AutoCompletePerusahaanBloc(ProgressState());
                      },
                    ),
                  ],
                  child: HalamanAddLayanan(settings.arguments),
                ));
      case halamanDetailSalesActivity:
        return MaterialPageRoute(
            builder: (context) => MultiBlocProvider(
                  providers: [
                    BlocProvider<PelangganBloc>(
                      create: (context) {
                        return PelangganBloc(PelangganProgressState());
                      },
                    ),
                    BlocProvider<TahapanBloc>(
                      create: (context) {
                        return TahapanBloc(TahapanProgressState());
                      },
                    ),
                    BlocProvider<TotalDataLayananDetailBloc>(
                      create: (context) {
                        return TotalDataLayananDetailBloc(
                            TotalDataLayananDetailProgressState());
                      },
                    ),
                    BlocProvider<DataLayananDetailBloc>(
                      create: (context) {
                        return DataLayananDetailBloc(
                            DataLayananDetailProgressState());
                      },
                    ),
                    BlocProvider<DropdownProdukLayananBloc>(
                      create: (context) {
                        return DropdownProdukLayananBloc(
                            DropdownProdukLayananProgressState());
                      },
                    ),
                    BlocProvider<LayananDraftBloc>(
                      create: (context) {
                        return LayananDraftBloc(LayananDraftProgressState());
                      },
                    ),
                    // BlocProvider<KambanBloc>(
                    //   create: (context) {
                    //     return KambanBloc(KambanProgressState());
                    //   },
                    // ),
                    BlocProvider<TotalKambanBloc>(
                      create: (context) {
                        return TotalKambanBloc(TotalKambanProgressState());
                      },
                    ),
                    BlocProvider<DataAktivitasSalesBloc>(
                      create: (context) {
                        return DataAktivitasSalesBloc(
                            DataAktivitasSalesProgressState());
                      },
                    ),
                    BlocProvider<DataLayananDetailByIdBloc>(
                      create: (context) {
                        return DataLayananDetailByIdBloc(
                            DataLayananDetailByIdProgressState());
                      },
                    ),
                  ],
                  // child: HalamanDetailKanbanBoard(settings.arguments as DataKanban),
                  child: HalamanDetailKanbanBoard(settings.arguments),
                ));
      case halamanDetailKanbanActivity:
        return MaterialPageRoute(
            builder: (context) => MultiBlocProvider(
                  providers: [
                    BlocProvider<PelangganBloc>(
                      create: (context) {
                        return PelangganBloc(PelangganProgressState());
                      },
                    ),
                    BlocProvider<TahapanBloc>(
                      create: (context) {
                        return TahapanBloc(TahapanProgressState());
                      },
                    ),
                    BlocProvider<TotalDataLayananDetailBloc>(
                      create: (context) {
                        return TotalDataLayananDetailBloc(
                            TotalDataLayananDetailProgressState());
                      },
                    ),
                    BlocProvider<DataLayananDetailBloc>(
                      create: (context) {
                        return DataLayananDetailBloc(
                            DataLayananDetailProgressState());
                      },
                    ),
                    BlocProvider<DropdownProdukLayananBloc>(
                      create: (context) {
                        return DropdownProdukLayananBloc(
                            DropdownProdukLayananProgressState());
                      },
                    ),
                    BlocProvider<LayananDraftBloc>(
                      create: (context) {
                        return LayananDraftBloc(LayananDraftProgressState());
                      },
                    ),
                    // BlocProvider<KambanBloc>(
                    //   create: (context) {
                    //     return KambanBloc(KambanProgressState());
                    //   },
                    // ),
                    BlocProvider<TotalKambanBloc>(
                      create: (context) {
                        return TotalKambanBloc(TotalKambanProgressState());
                      },
                    ),
                    BlocProvider<DataAktivitasSalesBloc>(
                      create: (context) {
                        return DataAktivitasSalesBloc(
                            DataAktivitasSalesProgressState());
                      },
                    ),
                    BlocProvider<DataLayananDetailByIdBloc>(
                      create: (context) {
                        return DataLayananDetailByIdBloc(
                            DataLayananDetailByIdProgressState());
                      },
                    ),

                    BlocProvider<DetailKanbanSalesBloc>(
                      create: (context) {
                        return DetailKanbanSalesBloc(
                            DetailKanbanSalesProgressState());
                      },
                    ),
                  ],
                  child: HalamanDetailKanbanBoardActivity(settings.arguments),
                ));
      case halamanAddSalesActivityPage:
        return MaterialPageRoute(
            builder: (context) => MultiBlocProvider(
                  providers: [
                    BlocProvider<PelangganBloc>(
                      create: (context) {
                        return PelangganBloc(PelangganProgressState());
                      },
                    ),
                    BlocProvider<DropdownJenisAktivitasBloc>(
                      create: (context) {
                        return DropdownJenisAktivitasBloc(
                            DropdownJenisAktivitasProgressState());
                      },
                    ),
                    BlocProvider<MultiImagePicker3Bloc>(
                      create: (context) {
                        return MultiImagePicker3Bloc(
                            ImagePickerProgressState());
                      },
                    ),
                    BlocProvider<MapsBloc>(
                      create: (context) {
                        return MapsBloc(MapsInitial());
                      },
                    ),
                    BlocProvider<DataAktivitasSalesBloc>(
                      create: (context) {
                        return DataAktivitasSalesBloc(
                            DataAktivitasSalesProgressState());
                      },
                    ),
                    BlocProvider<DatePickerTglKawinBloc>(
                      create: (context) {
                        return DatePickerTglKawinBloc(DateTime(0001, 01, 01));
                      },
                    ),
                    BlocProvider<TemplateTimePickerBloc>(
                      create: (context) {
                        return TemplateTimePickerBloc(
                            TimeOfDay(hour: 00, minute: 00));
                      },
                    ),
                  ],
                  child: HalamanAddAktivitasSales(settings.arguments),
                ));
      case halamanEditSalesActivityPage:
        return MaterialPageRoute(
            builder: (context) => MultiBlocProvider(
                  providers: [
                    BlocProvider<PelangganBloc>(
                      create: (context) {
                        return PelangganBloc(PelangganProgressState());
                      },
                    ),
                    BlocProvider<DropdownJenisAktivitasBloc>(
                      create: (context) {
                        return DropdownJenisAktivitasBloc(
                            DropdownJenisAktivitasProgressState());
                      },
                    ),
                    BlocProvider<MultiImagePicker3Bloc>(
                      create: (context) {
                        return MultiImagePicker3Bloc(
                            ImagePickerProgressState());
                      },
                    ),
                    BlocProvider<MultiImagePickerBloc>(
                      create: (context) {
                        return MultiImagePickerBloc(MultiImageProgressState());
                      },
                    ),
                    BlocProvider<MapsBloc>(
                      create: (context) {
                        return MapsBloc(MapsInitial());
                      },
                    ),
                    BlocProvider<DataAktivitasSalesBloc>(
                      create: (context) {
                        return DataAktivitasSalesBloc(
                            DataAktivitasSalesProgressState());
                      },
                    ),
                    BlocProvider<DatePickerTglKawinBloc>(
                      create: (context) {
                        return DatePickerTglKawinBloc(DateTime(0001, 01, 01));
                      },
                    ),
                    BlocProvider<TemplateTimePickerBloc>(
                      create: (context) {
                        return TemplateTimePickerBloc(
                            TimeOfDay(hour: 00, minute: 00));
                      },
                    ),
                    BlocProvider<DetailDailyAktivitasSalesBloc>(
                      create: (context) {
                        return DetailDailyAktivitasSalesBloc(
                            DetailDailyAktivitasSalesProgressState());
                      },
                    ),
                  ],
                  child: HalamanEditAktivitasSales(settings.arguments),
                ));
      case halamanDailySalesActivity:
        return MaterialPageRoute(
            builder: (context) => MultiBlocProvider(
                  providers: [
                    BlocProvider<DataDailyAktivitasSalesBloc>(
                      create: (context) {
                        return DataDailyAktivitasSalesBloc(
                            DataDailyAktivitasSalesProgressState());
                      },
                    ),
                  ],
                  child: DailyActivityPage(),
                ));
      case halamanDetailDailySalesActivity:
        return MaterialPageRoute(
            builder: (context) => MultiBlocProvider(
                  providers: [
                    BlocProvider<DetailDailyAktivitasSalesBloc>(
                      create: (context) {
                        return DetailDailyAktivitasSalesBloc(
                            DetailDailyAktivitasSalesProgressState());
                      },
                    ),
                  ],
                  child: HalamanDetailDailyActivity(settings.arguments),
                ));
      case halamanCuti: //HALAMAN ABSENSI
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DataCutiBloc>(
              create: (context) {
                return DataCutiBloc(DataCutiProggres());
              },
            ),
          ], child: HalamanCuti()),
        );
      case listHistoryCuti: //HALAMAN ABSENSI
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<HistoryCutiBloc>(
              create: (context) {
                return HistoryCutiBloc(HistoryCutiProgressState());
              },
            ),
          ], child: HalamanListHistoryCuti(settings.arguments)),
        );
      //KPI//
      case halamanKpi:
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<GetKomponenAtasanBloc>(
              create: (context) {
                return GetKomponenAtasanBloc(DataKomponenAtasanProgress());
              },
            ),
          ], child: HalamanKpi()),
        );
      case parentTabKpiSaya: //HALAMAN UBAH PASSWORD
        return MaterialPageRoute(
          builder: (context) => ParentTabKpiSaya(settings.arguments),
        );
      case parentTabKpiTeam: //HALAMAN UBAH PASSWORD
        return MaterialPageRoute(
          builder: (context) => ParentTabKpiTeam(),
        );
      case parentTabKpiApprovalTeam: //HALAMAN UBAH PASSWORD
        return MaterialPageRoute(
          builder: (context) => ParentTabApprobalKpiTeam(),
        );
      case halamanPengajuanKpiTeam: //HALAMAN IZIN DETAIL
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<GetDataPengajuanKpiTeamBloc>(
              create: (context) {
                return GetDataPengajuanKpiTeamBloc(
                    DataPengajuanKpiTeamProgressState());
              },
            ),
          ], child: HalamanPengajuanKpiTeam(settings.arguments)),
        );
      case halamanPengajuanKpiSaya: //HALAMAN IZIN DETAIL
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<GetDataPengajuanKpiTeamBloc>(
              create: (context) {
                return GetDataPengajuanKpiTeamBloc(
                    DataPengajuanKpiTeamProgressState());
              },
            ),
            BlocProvider<NotifBloc>(
              create: (context) {
                return NotifBloc(ProgressNotifState());
              },
            ),
          ], child: HalamanPengajuanKpiSaya(settings.arguments)),
        );
      case halamanDetailPengajuanKpiSaya: //HALAMAN IZIN DETAIL
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<GetDataPengajuanKpiTeamBloc>(
              create: (context) {
                return GetDataPengajuanKpiTeamBloc(
                    DataPengajuanKpiTeamProgressState());
              },
            ),
          ], child: HalamanDetailPengajuanKpiSaya(settings.arguments)),
        );
      case halamanPengajuanKpiApprovalTeam: //HALAMAN IZIN DETAIL
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<GetDataPengajuanKpiTeamBloc>(
              create: (context) {
                return GetDataPengajuanKpiTeamBloc(
                    DataPengajuanKpiTeamProgressState());
              },
            ),
          ], child: HalamanPengajuanApprovalKpiTeam(settings.arguments)),
        );
      case halamanDetailApprovedKpi: //HALAMAN IZIN DETAIL
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<GetDataPengajuanKpiTeamBloc>(
              create: (context) {
                return GetDataPengajuanKpiTeamBloc(
                    DataPengajuanKpiTeamProgressState());
              },
            ),
          ], child: HalamanApprovedKpiteam(settings.arguments)),
        );
      case halamanDetailApprovalKpiSaya: //HALAMAN IZIN DETAIL
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<GetDataPengajuanKpiTeamBloc>(
              create: (context) {
                return GetDataPengajuanKpiTeamBloc(
                    DataPengajuanKpiTeamProgressState());
              },
            ),
          ], child: HalamanDetailApprovalKpiSaya(settings.arguments)),
        );
      case halamanDetailDiterimaKpiSaya: //HALAMAN IZIN DETAIL
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<GetDataPengajuanKpiTeamBloc>(
              create: (context) {
                return GetDataPengajuanKpiTeamBloc(
                    DataPengajuanKpiTeamProgressState());
              },
            ),
          ], child: HalamanDetailDiterimaKpiSaya(settings.arguments)),
        );
      //END KPI //
      case patroliDetail:
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DetailPatroliBloc>(
              create: (context) {
                return DetailPatroliBloc(DetailPatroliProgress());
              },
            ),
          ], child: HalamanDetailPatroli(settings.arguments)),
        );
      case patroli: //HALAMAN LIST AKTIVITAS
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<NavbarBloc>(
              create: (context) {
                return NavbarBloc(0);
              },
            ),
            BlocProvider<CekValidasiWaktuBloc>(create: (context) {
              return CekValidasiWaktuBloc(ChekValidasiProgress());
            }),
            BlocProvider<SelectedJadwalPatroliBloc>(create: (context) {
              return SelectedJadwalPatroliBloc();
            })
          ], child: ParentTabPatroli()),
        );
      case pengajuanSos: //HALAMAN PENGAJUAN IZIN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
          ], child: HalamanPengajuanSos()),
        );
      case halamanlistSos: //HALAMAN PENGAJUAN IZIN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<MultiImagePickerBloc>(
              create: (context) {
                return MultiImagePickerBloc(MultiImageProgressState());
              },
            ),
          ], child: HalamanListSos()),
        );
      case halamanDetailSos: //HALAMAN PENGAJUAN IZIN
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DetailSosBloc>(
              create: (context) {
                return DetailSosBloc(DetailSosProgress());
              },
            ),
          ], child: HalamanDetailSos(settings.arguments)),
        );
      //PKWT//
      case listPkwtSaya:
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<PkwtBloc>(
              create: (context) {
                return PkwtBloc(PkwtProgressState());
              },
            ),
          ], child: HalamanListPkwtSaya()),
        );
      case listPkwtSayaReplace:
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<PkwtBloc>(
              create: (context) {
                return PkwtBloc(PkwtProgressState());
              },
            ),
          ], child: HalamanListPkwtSaya()),
        );
      case detailPkwtSaya: //HALAMAN DETAIL AKTIVITAS
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DetailPkwtBloc>(
              create: (context) {
                return DetailPkwtBloc(DetailPkwtProgress());
              },
            ),
          ], child: HalamanDetailPkwtSaya(settings.arguments)),
        );
      case detailPkwtSayaReplace: //HALAMAN DETAIL AKTIVITAS
        return MaterialPageRoute(
          builder: (context) => MultiBlocProvider(providers: [
            BlocProvider<DetailPkwtBloc>(
              create: (context) {
                return DetailPkwtBloc(DetailPkwtProgress());
              },
            ),
          ], child: HalamanDetailPkwtSaya(settings.arguments)),
        );

      //END PKWT//
      default:
        return MaterialPageRoute(
            builder: (_) => Scaffold(
                  body: Center(
                      child: Text(
                          'No route defined for ${settings.name}')) /*Container()*/,
                ));
    }
  }
}
