import 'dart:convert';

import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:shared_preferences/shared_preferences.dart';

class sharedPreferences {
  getInitialMockStatus() async{
    final prefs = await SharedPreferences.getInstance();
    return prefs.getBool('initialMockStatus')??true;
  }

  setInitialMockStatus(bool status) async{
    final prefs = await SharedPreferences.getInstance();
    prefs.setBool('initialMockStatus', status);
  }

  getInitialPermanentStatus() async{
    final prefs = await SharedPreferences.getInstance();
    return prefs.getBool('initialPermanentStatus')??false;
  }

  setInitialPermanentStatus(bool status) async{
    final prefs = await SharedPreferences.getInstance();
    prefs.setBool('initialPermanentStatus', status);
  }

  read(String key) async {
    final prefs = await SharedPreferences.getInstance();
    return json.decode(prefs.getString(key)!);
  }

  save(String key, value) async {
    final prefs = await SharedPreferences.getInstance();
    prefs.setString(key, json.encode(value));
  }

  remove(String key) async {
    final prefs = await SharedPreferences.getInstance();
    prefs.remove(key);
  }

  setUserData(LoginRespon value) async {
    final prefs = await SharedPreferences.getInstance();
    prefs.setString('user', loginResponToJson(value));
  }

  Future<LoginRespon> getUserData() async {
    final prefs = await SharedPreferences.getInstance();
    if (prefs.getString('user') != null)
      return loginResponFromJson(prefs.getString('user')!);
    else
      return LoginRespon(success: false);
  }

  setTokenFCM(String _token) async {
    final prefs = await SharedPreferences.getInstance();
    prefs.setString('token', _token);
  }

  Future<String?> getToken() async {
    final prefs = await SharedPreferences.getInstance();
    if (prefs.getString('token') != null)
      return prefs.getString('token');
    else
      return null;
  }

  getBahasa() async{
    final prefs = await SharedPreferences.getInstance();
    return prefs.getString('bahasa')??'en';
  }

  setBahasa(String bahasa) async{
    final prefs = await SharedPreferences.getInstance();
    prefs.setString('bahasa', bahasa);
  }
}
