import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mJadwalShift.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mShift2.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../sharedPreference.dart';
import 'serviceInfo.dart';

class ShiftApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();

  Future<ShiftRespon> getDataShift(offset, ModelFilter? modelFilter) async {
    // print('TRIGGERED');
    // debugPrint(Header().getHeader());
    LoginRespon data = await sharedPreferences().getUserData();
    var respon = await dio.get("tukar-shift-new/data-shift",
        queryParameters: {
          "id_karyawan": modelFilter != null && modelFilter.idPegawai != null
              ? modelFilter.idPegawai
              : data.dataLogin!.idKaryawan,
          "limit": ServerInfo.limit,
          "offset": offset,
          "id_company": data.dataLogin!.idCompany,
          "id_departemen": data.dataLogin!.idDepartemen,
          "id_cabang": data.dataLogin!.idCabang,
          "level": data.dataLogin!.level,
          "konteks": 'shiftSaya',
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return shiftResponFromJson(respon.data);
    } else {
      return ShiftRespon(success: false);
    }
  }

  Future<ShiftRespon> getDataShiftTeman(
      offset, ModelFilter? modelFilter) async {
    // print('TRIGGERED');
    LoginRespon data = await sharedPreferences().getUserData();
    var respon = await dio.get("tukar-shift-new/data-shift",
        queryParameters: {
          "id_karyawan": modelFilter != null && modelFilter.idPegawai != null
              ? modelFilter.idPegawai
              : data.dataLogin!.idKaryawan,
          "limit": ServerInfo.limit,
          "offset": offset,
          "id_company": data.dataLogin!.idCompany,
          "id_departemen": data.dataLogin!.idDepartemen,
          "id_cabang": data.dataLogin!.idCabang,
          "level": data.dataLogin!.level,
          "konteks": 'shiftTeman',
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return shiftResponFromJson(respon.data);
    } else {
      return ShiftRespon(success: false);
    }
  }

  Future<ShiftRespon> getDataShiftKaryawan(
      offset, ModelFilter? modelFilter) async {
    // print('karyawan');
    LoginRespon data = await sharedPreferences().getUserData();
    // print(data.dataLogin!.idKaryawan);
    var respon = await dio.get("tukar-shift-new/data-shift",
        queryParameters: {
          "id_karyawan": data.dataLogin!.idKaryawan,
          "limit": ServerInfo.limit,
          "offset": offset,
          "id_company": data.dataLogin!.idCompany,
          "id_cabang": modelFilter != null
              ? modelFilter.idCabang ?? null
              : data.dataLogin!.idCabang,
          "id_departemen": modelFilter != null
              ? modelFilter.idDepartemen ?? null
              : data.dataLogin!.idDepartemen,
          "id_karyawan_select":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "level": data.dataLogin!.level,
          "konteks": 'shiftKaryawan',
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return shiftResponFromJson(respon.data);
    } else {
      return ShiftRespon(success: false);
    }
  }

  Future<ShiftTemanKaryawanRespon> getDataShiftTemanDetail(offset,
      ModelFilter? modelFilter, String? idMasterShift, String? tanggal) async {
    LoginRespon data = await sharedPreferences().getUserData();
    // print(tanggal);
    var respon = await dio.get("shift/teman",
        queryParameters: {
          "id_master_shift": idMasterShift,
          "id_karyawan": data.dataLogin!.idKaryawan,
          "level": data.dataLogin!.level,
          "tanggal": tanggal,
          "limit": ServerInfo.limit,
          "offset": offset,
          "id_company": data.dataLogin!.idCompany,
          "id_departemen": data.dataLogin!.idDepartemen,
          "id_cabang": data.dataLogin!.idCabang,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return shiftTemanResponFromJson(respon.data);
    } else {
      return ShiftTemanKaryawanRespon(success: false);
    }
  }

  Future<ShiftTemanKaryawanRespon> getDataShiftKaryawanDetail(offset,
      ModelFilter? modelFilter, String? idMasterShift, String? tanggal) async {
    LoginRespon data = await sharedPreferences().getUserData();
    var respon = await dio.get("shift/karyawan", queryParameters: {
      "id_master_shift": idMasterShift,
      "id_karyawan": data.dataLogin!.idKaryawan,
      "level": data.dataLogin!.level,
      "tanggal": tanggal,
      "limit": ServerInfo.limit,
      "offset": offset,
      "id_company": data.dataLogin!.idCompany,
      "id_cabang": modelFilter != null
          ? modelFilter.idCabang ?? null
          : data.dataLogin!.idCabang,
      "id_departemen": modelFilter != null
          ? modelFilter.idDepartemen ?? null
          : data.dataLogin!.idDepartemen,
      "id_karyawan_select":
          modelFilter != null ? modelFilter.idPegawai ?? null : null,
      "range_tanggal_mulai":
          modelFilter != null && modelFilter.dateRange != null
              ? dateFormat.format(modelFilter.dateRange![0]).toString()
              : null,
      "range_tanggal_selesai":
          modelFilter != null && modelFilter.dateRange != null
              ? dateFormat.format(modelFilter.dateRange![1]).toString()
              : null,
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return shiftTemanResponFromJson(respon.data);
    } else {
      return ShiftTemanKaryawanRespon(success: false);
    }
  }
      Future<JadwalShift> getJadwalShift(
      limit, offset, keyword, bool lokasi_kantor) async {
    var respon = await dio.get("absensi/jadwal-shift",
        queryParameters: {
          'limit': limit,
          'offset': offset,
          'keyword': keyword,
          'lokasi_kantor': lokasi_kantor
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jadwalShiftFromJson(respon.data);
    } else {
      return JadwalShift(success: false);
    }
  }

}
