import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLembur.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class LemburApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');

  Dio dio = ServerInfo().getConnection();
  Future<LemburRespon> getDataLembur(
      offset, konteks, ModelFilter? modelFilter) async {
    var respon = await dio.get("lembur/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": konteks,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "status": modelFilter != null && modelFilter.status != null
              ? modelFilter.status
              : null
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return lemburResponFromJson(respon.data);
    } else {
      return LemburRespon(success: false);
    }
  }

  Future<LemburRespon> getDataRekapLemburSaya(
      offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("lembur/rekap",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": 'rekapSaya',
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return lemburResponFromJson(respon.data);
    } else {
      return LemburRespon(success: false);
    }
  }

  Future<LemburRespon> getDataRekapLemburPegawai(
      offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("lembur/rekap",
        queryParameters: {
          "id_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "id_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "id_karyawan_select":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": 'rekapPegawai',
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return lemburResponFromJson(respon.data);
    } else {
      return LemburRespon(success: false);
    }
  }

  Future<LemburRespon> getDataLemburDetail(idLemmulai, konteks) async {
    var respon = await dio.get("lembur/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": 0,
          "konteks": konteks,
          "id_lemmulai": idLemmulai,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return lemburResponFromJson(respon.data);
    } else {
      return LemburRespon(success: false);
    }
  }

  Future<LemburRespon> getDataRekapLemburDetail(idLembur) async {
    var respon = await dio.get("lembur/rekap",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": 0,
          "id_lembur": idLembur,
          "konteks": 'detailRekap',
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return lemburResponFromJson(respon.data);
    } else {
      return LemburRespon(success: false);
    }
  }

  Future<BasicRespon> batalkanLembur(String? idLemmulai) async {
    var respon = await dio.patch("lembur/batalkan/$idLemmulai",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> setujuiLembur(
    String? idLemmulai, {
    String? mulai,
    String? selesai,
  }) async {
    Map<String, String> data = {};
    if (mulai != null) data["mulai"] = mulai;
    if (selesai != null) data["selesai"] = selesai;
    var respon = await dio.patch("lembur/setujui/$idLemmulai",
        data: data,
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> MewakiliSetujuiLembur(String? idLemmulai) async {
    // print(idLemmulai);
    var respon = await dio.patch("lembur/hrd_mewakili_setujui/$idLemmulai",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> tolakLembur(String? idLemmulai) async {
    var respon = await dio.patch("lembur/tolak/$idLemmulai",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> MewakiliTolakLembur(String? idLemmulai) async {
    var respon = await dio.patch("lembur/hrd_mewakili_tolak/$idLemmulai",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<LemburHariIniRespon?> absensiLemburHariIni(DataAbsensi data) async {
    // print("cek absen");
    var respon = await dio.get("lembur/cek_absen",
        queryParameters: {
          "latitude": data.latitude,
          "longitude": data.longitude,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      // print(respon.data);
      return lemburHariIniResponFromJson(respon.data);
    } else {
      return null;
    }
  }

  //ABSENSI LEMBUR POST
  Future<BasicRespon> absensiLembur(DataAbsensi dataAbsensi) async {
    var respon = await dio.post("lembur/pengajuan",
        data: {
          "lokasi_absen": dataAbsensi.lokasiAbsen,
          "jenis_lembur": dataAbsensi.jenisAbsen,
          "latitude": dataAbsensi.latitude,
          "longitude": dataAbsensi.longitude,
          "keterangan": dataAbsensi.keteranganAbsen,
          "image": dataAbsensi.foto,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
}
