import 'package:absenkuv3/Repository/Model/mJamKerja.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class JamKerjaApi {
  Dio dio = ServerInfo().getConnection();
  final dateFormat = new DateFormat('yyyy-MM-dd');
  Future<JamKerjaRespon> getDataJamKerja() async {
    var respon = await dio.get("dashboard/jam_kerja",
        queryParameters: {
          "current_date": dateFormat.format(DateTime.now()),
        },
        options: Options(headers: await Header().getHeader()));
    // debugPrint(respon.data + 'respon jam kerja');
    if (respon.statusCode == 200) {
      return jamKerjaResponFromJson(respon.data);
    } else {
      return JamKerjaRespon(success: false);
    }
  }
}
