import 'package:absenkuv3/Repository/Model/mBerita.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class BeritaApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  Dio dio = ServerInfo().getConnection();
  Future<BeritaRespon> getDataBerita(offset, ModelFilter? modelFilter) async {
    // print(modelFilter!=null && modelFilter.dateRange!=null?dateFormat.format(modelFilter.dateRange![0]).toString():null);
    var respon = await dio.get("berita/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": offset,
          "keywords": modelFilter != null && modelFilter.keywords != null
              ? modelFilter.keywords
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return beritaResponFromJson(respon.data);
    } else {
      return BeritaRespon(success: false);
    }
  }

  Future<BeritaRespon> getDetailBerita(idBerita) async {
    var respon = await dio.get("berita/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": 0,
          "id_berita": idBerita
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return beritaResponFromJson(respon.data);
    } else {
      return BeritaRespon(success: false);
    }
  }
}
