

import 'package:absenkuv3/Repository/Model/mUsernameLupaPassword.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:dio/dio.dart';

import '../../Setting/Header.dart';

class AuthApi {
  Dio dio = ServerInfo().getConnection();

  Future<UsernameLupaPasswordRespon> cekUsername(String username) async {
    var respon = await dio.get("auth/cek-username",
        queryParameters: {"username": username}, options: Options(headers: await Header().getHeader()));
    print(respon);
    if (respon.statusCode == 200) {
      return usernameLupaPasswordResponFromJson(respon.data);
    } else {
      return UsernameLupaPasswordRespon(success: false);
    }
  }

  Future<UsernameLupaPasswordRespon> cekEmail(String idKaryawan, String idCompany, String email) async {
    var respon = await dio.get("auth/cek-email",
        queryParameters: {"id_karyawan": idKaryawan, "id_company": idCompany, "email": email},
        // options: Options(headers: {"api-key": ServerInfo.apiKey})
        options: Options(headers: await Header().getHeader())
    );
    // print(respon);
    if (respon.statusCode == 200) {
      return usernameLupaPasswordResponFromJson(respon.data);
    } else {
      return UsernameLupaPasswordRespon(success: false);
    }
  }
}