import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import '../sharedPreference.dart';
import 'serviceInfo.dart';

class SummaryApi {
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();

  Future<SummaryRespon> getDataSummary(ModelFilter? modelFilter) async {
    // print('aaa');
    // print(modelFilter!=null && modelFilter.monthYear!=null?monthYearFormat.format(modelFilter.monthYear!).toString():null);
    LoginRespon? data = await sharedPreferences().getUserData();
    var respon = await dio.get("summary/data", queryParameters: {
      "id_karyawan" : modelFilter!=null && modelFilter.idPegawai!=null?modelFilter.idPegawai:data.dataLogin!.idKaryawan,
      "month_year"  : modelFilter!=null && modelFilter.monthYear!=null?monthYearFormat.format(modelFilter.monthYear!).toString():null,
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return summaryResponFromJson(respon.data);
    } else {
      return SummaryRespon(success: false);
    }
  }

  Future<SummaryRespon> getDataSummaryRekap(ModelFilter? modelFilter,String? url) async {
    // print('aaa');
    // print(modelFilter!=null && modelFilter.monthYear!=null?monthYearFormat.format(modelFilter.monthYear!).toString():null);
    LoginRespon? data = await sharedPreferences().getUserData();
    var respon = await dio.get(url.toString(), queryParameters: {
      "id_karyawan" : modelFilter!=null && modelFilter.idPegawai!=null?modelFilter.idPegawai:data.dataLogin!.idKaryawan,
      "month_year"  : modelFilter!=null && modelFilter.monthYear!=null?monthYearFormat.format(modelFilter.monthYear!).toString():null,
    });
    if (respon.statusCode == 200) {
      return summaryResponFromJson(respon.data);
    } else {
      return SummaryRespon(success: false);
    }
  }

  // Future<SummaryRespon> getDataSummaryRekapAlpa(ModelFilter? modelFilter) async {
  //   // print('aaa');
  //   // print(modelFilter!=null && modelFilter.monthYear!=null?monthYearFormat.format(modelFilter.monthYear!).toString():null);
  //   LoginRespon? data = await sharedPreferences().getUserData();
  //   var respon = await dio.get("summary/alpa", queryParameters: {
  //     "id_karyawan" : modelFilter!=null && modelFilter.idPegawai!=null?modelFilter.idPegawai:data.dataLogin!.idKaryawan,
  //     "month_year"  : modelFilter!=null && modelFilter.monthYear!=null?monthYearFormat.format(modelFilter.monthYear!).toString():null,
  //   });
  //   if (respon.statusCode == 200) {
  //     return summaryResponFromJson(respon.data);
  //   } else {
  //     return SummaryRespon(success: false);
  //   }
  // }
}
